/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.autoupdate;

import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.extension.encoder.Encoder;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.control.AddOnCollection;
import org.zaproxy.zap.control.AddOnRunIssuesUtils;
import org.zaproxy.zap.extension.autoupdate.AddOnWrapper;
import org.zaproxy.zap.extension.autoupdate.ExtensionAutoUpdate;

public abstract class AddOnsTableModel
extends AbstractTableModel {
    public static final int COLUMN_ADD_ON_WRAPPER = -1;
    private static final long serialVersionUID = -5240438485136881299L;
    protected final Logger logger = Logger.getLogger(this.getClass());
    private final Comparator<AddOnWrapper> comparator;
    private final List<AddOnWrapper> wrappers;
    private final int progressColumn;
    private AddOnCollection addOnCollection;
    private AddOnSearcher addOnSeacher;

    @Deprecated
    public AddOnsTableModel(Comparator<AddOnWrapper> comparator, AddOnCollection addOnCollection, int n) {
        this.comparator = comparator;
        this.wrappers = new ArrayList<AddOnWrapper>();
        this.progressColumn = n;
        this.addOnCollection = addOnCollection;
    }

    public AddOnsTableModel(AddOnCollection addOnCollection, int n) {
        this.comparator = null;
        this.wrappers = new ArrayList<AddOnWrapper>();
        this.progressColumn = n;
        this.addOnCollection = addOnCollection;
    }

    public void setAddOnCollection(AddOnCollection addOnCollection) {
        this.addOnCollection = addOnCollection;
    }

    protected List<AddOnWrapper> getAddOnWrappers() {
        return this.wrappers;
    }

    public Set<AddOn> getSelectedAddOns() {
        HashSet<AddOn> hashSet = new HashSet<AddOn>();
        for (AddOnWrapper addOnWrapper : this.getAddOnWrappers()) {
            if (!addOnWrapper.isEnabled()) continue;
            hashSet.add(addOnWrapper.getAddOn());
        }
        return hashSet;
    }

    public Set<AddOn> getDownloadingAddOns() {
        HashSet<AddOn> hashSet = new HashSet<AddOn>();
        for (AddOnWrapper addOnWrapper : this.getAddOnWrappers()) {
            AddOn addOn = this.getAddOnForDownload(addOnWrapper);
            if (AddOn.InstallationStatus.DOWNLOADING != addOn.getInstallationStatus()) continue;
            hashSet.add(addOn);
        }
        return hashSet;
    }

    protected AddOn getAddOnForDownload(AddOnWrapper addOnWrapper) {
        return addOnWrapper.getAddOn();
    }

    protected void addAddOnWrapper(AddOn addOn, AddOnWrapper.Status status) {
        int n;
        AddOnWrapper addOnWrapper = this.createAddOnWrapper(addOn, status);
        if (this.comparator != null) {
            for (n = 0; n < this.getAddOnWrappers().size() && this.comparator.compare(addOnWrapper, this.getAddOnWrappers().get(n)) >= 0; ++n) {
                this.getAddOnWrappers().add(n, addOnWrapper);
            }
        } else {
            n = this.getAddOnWrappers().size();
            this.getAddOnWrappers().add(addOnWrapper);
        }
        this.fireTableRowsInserted(n, n);
        this.refreshEntries();
    }

    protected void refreshEntries() {
        for (int i = 0; i < this.getAddOnWrappers().size(); ++i) {
            if (!this.refreshEntry(this.getAddOnWrappers().get(i), i)) continue;
            this.fireTableRowsUpdated(i, i);
        }
    }

    protected boolean refreshEntry(AddOnWrapper addOnWrapper, int n) {
        boolean bl = false;
        if (addOnWrapper.getInstallationStatus() != addOnWrapper.getAddOn().getInstallationStatus()) {
            addOnWrapper.setInstallationStatus(addOnWrapper.getAddOn().getInstallationStatus());
            bl = true;
        }
        return bl |= this.refreshRunningIssues(addOnWrapper, n);
    }

    public void removeAddOn(AddOn addOn) {
        for (int i = 0; i < this.getAddOnWrappers().size(); ++i) {
            if (!addOn.isSameAddOn(this.getAddOnWrappers().get(i).getAddOn())) continue;
            this.getAddOnWrappers().remove(i);
            this.fireTableRowsDeleted(i, i);
            this.refreshEntries();
            break;
        }
    }

    public boolean notifyAddOnDownloading(AddOn addOn) {
        for (int i = 0; i < this.getAddOnWrappers().size(); ++i) {
            AddOnWrapper addOnWrapper = this.getAddOnWrappers().get(i);
            if (!addOn.isSameAddOn(this.getAddOnForDownload(addOnWrapper))) continue;
            addOnWrapper.setInstallationStatus(AddOn.InstallationStatus.DOWNLOADING);
            addOnWrapper.setEnabled(false);
            this.fireTableRowsUpdated(i, i);
            return true;
        }
        return false;
    }

    public boolean notifyAddOnDownloadFailed(String string) {
        for (int i = 0; i < this.getAddOnWrappers().size(); ++i) {
            AddOnWrapper addOnWrapper = this.getAddOnWrappers().get(i);
            AddOn addOn = this.getAddOnForDownload(addOnWrapper);
            if (!AddOnsTableModel.hasSameUrl(addOn, string)) continue;
            this.setFailed(addOnWrapper, addOn);
            this.fireTableRowsUpdated(i, i);
            return true;
        }
        return false;
    }

    private void setFailed(AddOnWrapper addOnWrapper, AddOn addOn) {
        addOnWrapper.setFailed(true);
        this.restoreInstallationStatusFailedDownload(addOnWrapper);
        addOn.setInstallationStatus(AddOn.InstallationStatus.AVAILABLE);
    }

    private static boolean hasSameUrl(AddOn addOn, String string) {
        URL uRL = addOn.getUrl();
        if (uRL == null) {
            return false;
        }
        return uRL.toString().equals(string);
    }

    public boolean notifyAddOnFailedUninstallation(AddOn addOn) {
        for (int i = 0; i < this.getAddOnWrappers().size(); ++i) {
            AddOnWrapper addOnWrapper = this.getAddOnWrappers().get(i);
            if (!addOn.isSameAddOn(this.getAddOnForDownload(addOnWrapper))) continue;
            addOnWrapper.setInstallationStatus(AddOn.InstallationStatus.UNINSTALLATION_FAILED);
            addOnWrapper.setEnabled(false);
            this.fireTableRowsUpdated(i, i);
            return true;
        }
        return false;
    }

    protected AddOnWrapper getAddOnWrapper(int n) {
        return this.getAddOnWrappers().get(n);
    }

    public void updateDownloadsProgresses(ExtensionAutoUpdate extensionAutoUpdate) {
        block9: {
            final ArrayList<Integer> arrayList = new ArrayList<Integer>(this.getAddOnWrappers().size());
            for (int i = 0; i < this.getAddOnWrappers().size(); ++i) {
                AddOnWrapper addOnWrapper = this.getAddOnWrappers().get(i);
                AddOn addOn = this.getAddOnForDownload(addOnWrapper);
                if (AddOn.InstallationStatus.DOWNLOADING != addOn.getInstallationStatus()) continue;
                URL uRL = addOn.getUrl();
                try {
                    int n = extensionAutoUpdate.getDownloadProgressPercent(uRL);
                    if (n <= 0) continue;
                    addOnWrapper.setProgress(n);
                    arrayList.add(i);
                    continue;
                }
                catch (Exception exception) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug((Object)("Error on " + uRL), (Throwable)exception);
                    }
                    this.setFailed(addOnWrapper, addOn);
                    try {
                        final int n = i;
                        EventQueue.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                AddOnsTableModel.this.fireTableRowsUpdated(n, n);
                            }
                        });
                        continue;
                    }
                    catch (InterruptedException | InvocationTargetException exception2) {
                        // empty catch block
                    }
                }
            }
            if (!arrayList.isEmpty()) {
                try {
                    EventQueue.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            for (Integer n : arrayList) {
                                AddOnsTableModel.this.fireTableCellUpdated(n, AddOnsTableModel.this.progressColumn);
                            }
                        }
                    });
                }
                catch (InterruptedException | InvocationTargetException exception) {
                    if (!this.logger.isDebugEnabled()) break block9;
                    this.logger.debug((Object)"Failed to update all the progresses: ", (Throwable)exception);
                }
            }
        }
    }

    protected abstract void restoreInstallationStatusFailedDownload(AddOnWrapper var1);

    protected void fireTableColumnUpdated(int n, int n2, int n3) {
        this.fireTableChanged(new TableModelEvent(this, n, n2, n3, 0));
    }

    protected AddOnWrapper createAddOnWrapper(AddOn addOn, AddOnWrapper.Status status) {
        if (this.addOnCollection == null) {
            return new AddOnWrapper(addOn, status);
        }
        return new AddOnWrapper(addOn, status, this.getAddOnRunningIssues(addOn.calculateRunRequirements(this.addOnCollection.getAddOns())));
    }

    protected boolean refreshRunningIssues(AddOnWrapper addOnWrapper, int n) {
        AddOn.AddOnRunRequirements addOnRunRequirements = addOnWrapper.getAddOn().calculateRunRequirements(this.addOnCollection.getAddOns());
        String string = this.getAddOnRunningIssues(addOnRunRequirements);
        addOnWrapper.setRunningIssues(string, !addOnRunRequirements.hasExtensionsWithRunningIssues());
        return !string.isEmpty();
    }

    protected String getAddOnRunningIssues(AddOn.AddOnRunRequirements addOnRunRequirements) {
        List<String> list = AddOnRunIssuesUtils.getUiRunningIssues(addOnRunRequirements, this.getAddOnSearcher());
        if (list.isEmpty()) {
            List<String> list2 = AddOnRunIssuesUtils.getUiExtensionsRunningIssues(addOnRunRequirements, this.getAddOnSearcher());
            if (!list2.isEmpty()) {
                return AddOnsTableModel.getHtmlFromIssues(Constant.messages.getString("cfu.warn.addon.with.extensions.with.missing.requirements"), list2);
            }
            return "";
        }
        return AddOnsTableModel.getHtmlFromIssues(Constant.messages.getString("cfu.warn.addon.with.missing.requirements"), list);
    }

    private static String getHtmlFromIssues(String string, List<String> list) {
        StringBuilder stringBuilder = new StringBuilder(150);
        Encoder encoder = new Encoder();
        stringBuilder.append("<html><strong>").append(encoder.getHTMLString(string)).append("</strong><ul>");
        for (String string2 : list) {
            stringBuilder.append("<li>").append(encoder.getHTMLString(string2)).append("</li>");
        }
        stringBuilder.append("</ul></html>");
        return stringBuilder.toString();
    }

    protected AddOn getMissingAddOn(String string) {
        return this.addOnCollection.getAddOn(string);
    }

    private AddOnSearcher getAddOnSearcher() {
        if (this.addOnSeacher == null) {
            this.addOnSeacher = new AddOnSearcher();
        }
        return this.addOnSeacher;
    }

    private class AddOnSearcher
    implements AddOnRunIssuesUtils.AddOnSearcher {
        private AddOnSearcher() {
        }

        @Override
        public AddOn searchAddOn(String string) {
            return AddOnsTableModel.this.getMissingAddOn(string);
        }
    }
}

