/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.scan;

import java.util.LinkedHashSet;
import java.util.Set;
import org.zaproxy.zap.scan.BaseScannerThread;
import org.zaproxy.zap.scan.ScanListener;
import org.zaproxy.zap.scan.ScanStartOptions;

public abstract class BaseContextScannerThread<StartOptions extends ScanStartOptions, Listener extends ScanListener>
extends BaseScannerThread<StartOptions> {
    protected Set<Listener> listeners;
    protected int contextId;

    public BaseContextScannerThread(int n) {
        this.contextId = n;
        this.listeners = new LinkedHashSet<Listener>();
    }

    public void addScanListener(Listener Listener) {
        this.listeners.add(Listener);
    }

    public void removeScanListener(Listener Listener) {
        this.listeners.remove(Listener);
    }

    protected void notifyScanStarted() {
        for (ScanListener scanListener : this.listeners) {
            scanListener.scanStarted(this.contextId);
        }
    }

    protected void notifyScanFinished() {
        for (ScanListener scanListener : this.listeners) {
            scanListener.scanFinished(this.contextId);
        }
    }

    protected void notifyScanProgress() {
        for (ScanListener scanListener : this.listeners) {
            scanListener.scanProgress(this.contextId, this.getScanProgress(), this.getScanMaximumProgress());
        }
    }

    @Override
    public void setScanProgress(int n) {
        super.setScanProgress(n);
        this.notifyScanProgress();
    }
}

