/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.dns;

import com.sun.jndi.dns.DnsClient;
import com.sun.jndi.dns.DnsName;
import com.sun.jndi.dns.ResourceRecord;
import com.sun.jndi.dns.ResourceRecords;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;

class Resolver {
    private DnsClient dnsClient;
    private int timeout;
    private int retries;

    Resolver(String[] servers, int timeout, int retries) throws NamingException {
        this.timeout = timeout;
        this.retries = retries;
        this.dnsClient = new DnsClient(servers, timeout, retries);
    }

    public void close() {
        this.dnsClient.close();
        this.dnsClient = null;
    }

    ResourceRecords query(DnsName fqdn, int rrclass, int rrtype, boolean recursion, boolean auth) throws NamingException {
        return this.dnsClient.query(fqdn, rrclass, rrtype, recursion, auth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResourceRecords queryZone(DnsName zone, int rrclass, boolean recursion) throws NamingException {
        try (DnsClient cl = new DnsClient(this.findNameServers(zone, recursion), this.timeout, this.retries);){
            ResourceRecords resourceRecords = cl.queryZone(zone, rrclass, recursion);
            return resourceRecords;
        }
    }

    DnsName findZoneName(DnsName fqdn, int rrclass, boolean recursion) throws NamingException {
        fqdn = (DnsName)fqdn.clone();
        while (fqdn.size() > 1) {
            ResourceRecords rrs = null;
            try {
                rrs = this.query(fqdn, rrclass, 6, recursion, false);
            }
            catch (NameNotFoundException e) {
                throw e;
            }
            catch (NamingException e) {
                // empty catch block
            }
            if (rrs != null) {
                if (rrs.answer.size() > 0) {
                    return fqdn;
                }
                for (int i = 0; i < rrs.authority.size(); ++i) {
                    DnsName zone;
                    ResourceRecord rr = (ResourceRecord)rrs.authority.elementAt(i);
                    if (rr.getType() != 6 || !fqdn.endsWith(zone = rr.getName())) continue;
                    return zone;
                }
            }
            fqdn.remove(fqdn.size() - 1);
        }
        return fqdn;
    }

    ResourceRecord findSoa(DnsName zone, int rrclass, boolean recursion) throws NamingException {
        ResourceRecords rrs = this.query(zone, rrclass, 6, recursion, false);
        for (int i = 0; i < rrs.answer.size(); ++i) {
            ResourceRecord rr = (ResourceRecord)rrs.answer.elementAt(i);
            if (rr.getType() != 6) continue;
            return rr;
        }
        return null;
    }

    private String[] findNameServers(DnsName zone, boolean recursion) throws NamingException {
        ResourceRecords rrs = this.query(zone, 1, 2, recursion, false);
        String[] ns = new String[rrs.answer.size()];
        for (int i = 0; i < ns.length; ++i) {
            ResourceRecord rr = (ResourceRecord)rrs.answer.elementAt(i);
            if (rr.getType() != 2) {
                throw new CommunicationException("Corrupted DNS message");
            }
            ns[i] = (String)rr.getRdata();
            ns[i] = ns[i].substring(0, ns[i].length() - 1);
        }
        return ns;
    }
}

