/*
 * Decompiled with CFR 0.152.
 */
package dguitar.codecs.guitarPro;

public class GPHarmonic {
    private int _index;
    private int _type;
    private static int[] harmonicValues;
    public static final GPHarmonic NONE;
    public static final GPHarmonic NATURAL;
    public static final GPHarmonic TAPPED;
    public static final GPHarmonic PITCH;
    public static final GPHarmonic SEMI;
    public static final GPHarmonic ARTIFICIAL_5;
    public static final GPHarmonic ARTIFICIAL_7;
    public static final GPHarmonic ARTIFICIAL_12;
    private static GPHarmonic[] _harmonics;
    private static String[] _harmonicStrings;

    static {
        int[] nArray = new int[8];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 4;
        nArray[4] = 5;
        nArray[5] = 15;
        nArray[6] = 17;
        nArray[7] = 22;
        harmonicValues = nArray;
        NONE = new GPHarmonic(0);
        NATURAL = new GPHarmonic(1);
        TAPPED = new GPHarmonic(3);
        PITCH = new GPHarmonic(4);
        SEMI = new GPHarmonic(5);
        ARTIFICIAL_5 = new GPHarmonic(15);
        ARTIFICIAL_7 = new GPHarmonic(17);
        ARTIFICIAL_12 = new GPHarmonic(22);
        _harmonics = new GPHarmonic[]{NONE, NATURAL, TAPPED, PITCH, SEMI, ARTIFICIAL_5, ARTIFICIAL_7, ARTIFICIAL_12};
        _harmonicStrings = new String[]{"None", "Natural", "Tapped", "Pitch", "Semi", "Artificial + 5", "Artificial + 7", "Artificial + 12"};
    }

    private GPHarmonic(int value) {
        this._type = value;
        this._index = GPHarmonic.indexOf(this._type);
    }

    public String toString() {
        String res = "Harmonic (type = " + this._type + ", index = " + this._index + ")";
        if (this._index >= 0 && this._index < harmonicValues.length) {
            res = _harmonicStrings[this._index];
        }
        return res;
    }

    private static int indexOf(int value) {
        boolean found = false;
        int res = -1;
        int i = harmonicValues.length - 1;
        while (!found && i >= 0) {
            boolean bl = found = harmonicValues[i] == value;
            if (found) {
                res = i;
            }
            --i;
        }
        return res;
    }

    public static GPHarmonic valueOf(int value) {
        GPHarmonic res = null;
        int i = GPHarmonic.indexOf(value);
        if (i >= 0) {
            res = _harmonics[i];
        }
        return res;
    }
}

