/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.analysis;

import com.google.common.collect.Maps;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Scopes;
import org.elasticsearch.common.inject.assistedinject.FactoryProvider;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.analysis.ASCIIFoldingTokenFilterFactory;
import org.elasticsearch.index.analysis.AnalysisService;
import org.elasticsearch.index.analysis.AnalysisSettingsRequired;
import org.elasticsearch.index.analysis.AnalyzerProvider;
import org.elasticsearch.index.analysis.AnalyzerProviderFactory;
import org.elasticsearch.index.analysis.ApostropheFilterFactory;
import org.elasticsearch.index.analysis.ArabicAnalyzerProvider;
import org.elasticsearch.index.analysis.ArabicNormalizationFilterFactory;
import org.elasticsearch.index.analysis.ArabicStemTokenFilterFactory;
import org.elasticsearch.index.analysis.ArmenianAnalyzerProvider;
import org.elasticsearch.index.analysis.BasqueAnalyzerProvider;
import org.elasticsearch.index.analysis.BrazilianAnalyzerProvider;
import org.elasticsearch.index.analysis.BrazilianStemTokenFilterFactory;
import org.elasticsearch.index.analysis.BulgarianAnalyzerProvider;
import org.elasticsearch.index.analysis.CJKBigramFilterFactory;
import org.elasticsearch.index.analysis.CJKWidthFilterFactory;
import org.elasticsearch.index.analysis.CatalanAnalyzerProvider;
import org.elasticsearch.index.analysis.CharFilterFactory;
import org.elasticsearch.index.analysis.CharFilterFactoryFactory;
import org.elasticsearch.index.analysis.ChineseAnalyzerProvider;
import org.elasticsearch.index.analysis.CjkAnalyzerProvider;
import org.elasticsearch.index.analysis.ClassicFilterFactory;
import org.elasticsearch.index.analysis.ClassicTokenizerFactory;
import org.elasticsearch.index.analysis.CommonGramsTokenFilterFactory;
import org.elasticsearch.index.analysis.CustomAnalyzerProvider;
import org.elasticsearch.index.analysis.CzechAnalyzerProvider;
import org.elasticsearch.index.analysis.CzechStemTokenFilterFactory;
import org.elasticsearch.index.analysis.DanishAnalyzerProvider;
import org.elasticsearch.index.analysis.DecimalDigitFilterFactory;
import org.elasticsearch.index.analysis.DelimitedPayloadTokenFilterFactory;
import org.elasticsearch.index.analysis.DutchAnalyzerProvider;
import org.elasticsearch.index.analysis.DutchStemTokenFilterFactory;
import org.elasticsearch.index.analysis.EdgeNGramTokenFilterFactory;
import org.elasticsearch.index.analysis.EdgeNGramTokenizerFactory;
import org.elasticsearch.index.analysis.ElisionTokenFilterFactory;
import org.elasticsearch.index.analysis.EnglishAnalyzerProvider;
import org.elasticsearch.index.analysis.FinnishAnalyzerProvider;
import org.elasticsearch.index.analysis.FrenchAnalyzerProvider;
import org.elasticsearch.index.analysis.FrenchStemTokenFilterFactory;
import org.elasticsearch.index.analysis.GalicianAnalyzerProvider;
import org.elasticsearch.index.analysis.GermanAnalyzerProvider;
import org.elasticsearch.index.analysis.GermanNormalizationFilterFactory;
import org.elasticsearch.index.analysis.GermanStemTokenFilterFactory;
import org.elasticsearch.index.analysis.GreekAnalyzerProvider;
import org.elasticsearch.index.analysis.HindiAnalyzerProvider;
import org.elasticsearch.index.analysis.HindiNormalizationFilterFactory;
import org.elasticsearch.index.analysis.HtmlStripCharFilterFactory;
import org.elasticsearch.index.analysis.HungarianAnalyzerProvider;
import org.elasticsearch.index.analysis.HunspellTokenFilterFactory;
import org.elasticsearch.index.analysis.IndicNormalizationFilterFactory;
import org.elasticsearch.index.analysis.IndonesianAnalyzerProvider;
import org.elasticsearch.index.analysis.IrishAnalyzerProvider;
import org.elasticsearch.index.analysis.ItalianAnalyzerProvider;
import org.elasticsearch.index.analysis.KStemTokenFilterFactory;
import org.elasticsearch.index.analysis.KeepTypesFilterFactory;
import org.elasticsearch.index.analysis.KeepWordFilterFactory;
import org.elasticsearch.index.analysis.KeywordAnalyzerProvider;
import org.elasticsearch.index.analysis.KeywordMarkerTokenFilterFactory;
import org.elasticsearch.index.analysis.KeywordTokenizerFactory;
import org.elasticsearch.index.analysis.LatvianAnalyzerProvider;
import org.elasticsearch.index.analysis.LengthTokenFilterFactory;
import org.elasticsearch.index.analysis.LetterTokenizerFactory;
import org.elasticsearch.index.analysis.LimitTokenCountFilterFactory;
import org.elasticsearch.index.analysis.LithuanianAnalyzerProvider;
import org.elasticsearch.index.analysis.LowerCaseTokenFilterFactory;
import org.elasticsearch.index.analysis.LowerCaseTokenizerFactory;
import org.elasticsearch.index.analysis.MappingCharFilterFactory;
import org.elasticsearch.index.analysis.NGramTokenFilterFactory;
import org.elasticsearch.index.analysis.NGramTokenizerFactory;
import org.elasticsearch.index.analysis.NorwegianAnalyzerProvider;
import org.elasticsearch.index.analysis.PathHierarchyTokenizerFactory;
import org.elasticsearch.index.analysis.PatternAnalyzerProvider;
import org.elasticsearch.index.analysis.PatternCaptureGroupTokenFilterFactory;
import org.elasticsearch.index.analysis.PatternReplaceCharFilterFactory;
import org.elasticsearch.index.analysis.PatternReplaceTokenFilterFactory;
import org.elasticsearch.index.analysis.PatternTokenizerFactory;
import org.elasticsearch.index.analysis.PersianAnalyzerProvider;
import org.elasticsearch.index.analysis.PersianNormalizationFilterFactory;
import org.elasticsearch.index.analysis.PorterStemTokenFilterFactory;
import org.elasticsearch.index.analysis.PortugueseAnalyzerProvider;
import org.elasticsearch.index.analysis.ReverseTokenFilterFactory;
import org.elasticsearch.index.analysis.RomanianAnalyzerProvider;
import org.elasticsearch.index.analysis.RussianAnalyzerProvider;
import org.elasticsearch.index.analysis.RussianStemTokenFilterFactory;
import org.elasticsearch.index.analysis.ScandinavianFoldingFilterFactory;
import org.elasticsearch.index.analysis.ScandinavianNormalizationFilterFactory;
import org.elasticsearch.index.analysis.SerbianNormalizationFilterFactory;
import org.elasticsearch.index.analysis.ShingleTokenFilterFactory;
import org.elasticsearch.index.analysis.SimpleAnalyzerProvider;
import org.elasticsearch.index.analysis.SnowballAnalyzerProvider;
import org.elasticsearch.index.analysis.SnowballTokenFilterFactory;
import org.elasticsearch.index.analysis.SoraniAnalyzerProvider;
import org.elasticsearch.index.analysis.SoraniNormalizationFilterFactory;
import org.elasticsearch.index.analysis.SpanishAnalyzerProvider;
import org.elasticsearch.index.analysis.StandardAnalyzerProvider;
import org.elasticsearch.index.analysis.StandardHtmlStripAnalyzerProvider;
import org.elasticsearch.index.analysis.StandardTokenFilterFactory;
import org.elasticsearch.index.analysis.StandardTokenizerFactory;
import org.elasticsearch.index.analysis.StemmerOverrideTokenFilterFactory;
import org.elasticsearch.index.analysis.StemmerTokenFilterFactory;
import org.elasticsearch.index.analysis.StopAnalyzerProvider;
import org.elasticsearch.index.analysis.StopTokenFilterFactory;
import org.elasticsearch.index.analysis.SwedishAnalyzerProvider;
import org.elasticsearch.index.analysis.SynonymTokenFilterFactory;
import org.elasticsearch.index.analysis.ThaiAnalyzerProvider;
import org.elasticsearch.index.analysis.ThaiTokenizerFactory;
import org.elasticsearch.index.analysis.TokenFilterFactory;
import org.elasticsearch.index.analysis.TokenFilterFactoryFactory;
import org.elasticsearch.index.analysis.TokenizerFactory;
import org.elasticsearch.index.analysis.TokenizerFactoryFactory;
import org.elasticsearch.index.analysis.TrimTokenFilterFactory;
import org.elasticsearch.index.analysis.TruncateTokenFilterFactory;
import org.elasticsearch.index.analysis.TurkishAnalyzerProvider;
import org.elasticsearch.index.analysis.UAX29URLEmailTokenizerFactory;
import org.elasticsearch.index.analysis.UniqueTokenFilterFactory;
import org.elasticsearch.index.analysis.UpperCaseTokenFilterFactory;
import org.elasticsearch.index.analysis.WhitespaceAnalyzerProvider;
import org.elasticsearch.index.analysis.WhitespaceTokenizerFactory;
import org.elasticsearch.index.analysis.WordDelimiterTokenFilterFactory;
import org.elasticsearch.index.analysis.compound.DictionaryCompoundWordTokenFilterFactory;
import org.elasticsearch.index.analysis.compound.HyphenationCompoundWordTokenFilterFactory;
import org.elasticsearch.indices.analysis.IndicesAnalysisService;

public class AnalysisModule
extends AbstractModule {
    private final Settings settings;
    private final IndicesAnalysisService indicesAnalysisService;
    private final LinkedList<AnalysisBinderProcessor> processors = new LinkedList();
    private final Map<String, Class<? extends CharFilterFactory>> charFilters = Maps.newHashMap();
    private final Map<String, Class<? extends TokenFilterFactory>> tokenFilters = Maps.newHashMap();
    private final Map<String, Class<? extends TokenizerFactory>> tokenizers = Maps.newHashMap();
    private final Map<String, Class<? extends AnalyzerProvider>> analyzers = Maps.newHashMap();

    public AnalysisModule(Settings settings, IndicesAnalysisService indicesAnalysisService) {
        Objects.requireNonNull(indicesAnalysisService);
        this.settings = settings;
        this.indicesAnalysisService = indicesAnalysisService;
        this.processors.add(new DefaultProcessor());
        try {
            this.processors.add(new ExtendedProcessor());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public AnalysisModule addProcessor(AnalysisBinderProcessor processor) {
        this.processors.addFirst(processor);
        return this;
    }

    public AnalysisModule addCharFilter(String name, Class<? extends CharFilterFactory> charFilter) {
        this.charFilters.put(name, charFilter);
        return this;
    }

    public AnalysisModule addTokenFilter(String name, Class<? extends TokenFilterFactory> tokenFilter) {
        this.tokenFilters.put(name, tokenFilter);
        return this;
    }

    public AnalysisModule addTokenizer(String name, Class<? extends TokenizerFactory> tokenizer) {
        this.tokenizers.put(name, tokenizer);
        return this;
    }

    public AnalysisModule addAnalyzer(String name, Class<? extends AnalyzerProvider> analyzer) {
        this.analyzers.put(name, analyzer);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void configure() {
        String analyzerName;
        String tokenizerName;
        String tokenFilterName;
        String charFilterName;
        MapBinder<String, CharFilterFactoryFactory> charFilterBinder = MapBinder.newMapBinder(this.binder(), String.class, CharFilterFactoryFactory.class);
        AnalysisBinderProcessor.CharFiltersBindings charFiltersBindings = new AnalysisBinderProcessor.CharFiltersBindings();
        for (AnalysisBinderProcessor processor : this.processors) {
            processor.processCharFilters(charFiltersBindings);
        }
        charFiltersBindings.charFilters.putAll(this.charFilters);
        Map<String, Settings> charFiltersSettings = this.settings.getGroups("index.analysis.char_filter");
        for (Map.Entry<String, Settings> entry : charFiltersSettings.entrySet()) {
            charFilterName = entry.getKey();
            Settings charFilterSettings = entry.getValue();
            String string = charFilterSettings.get("type");
            if (string == null) {
                throw new IllegalArgumentException("CharFilter [" + charFilterName + "] must have a type associated with it");
            }
            Class type = (Class)charFiltersBindings.charFilters.get(string);
            if (type == null) {
                throw new IllegalArgumentException("Unknown CharFilter type [" + string + "] for [" + charFilterName + "]");
            }
            charFilterBinder.addBinding(charFilterName).toProvider(FactoryProvider.newFactory(CharFilterFactoryFactory.class, type)).in(Scopes.SINGLETON);
        }
        for (Map.Entry<String, Settings> entry : charFiltersBindings.charFilters.entrySet()) {
            charFilterName = entry.getKey();
            Class clazz = (Class)((Object)entry.getValue());
            if (charFiltersSettings.containsKey(charFilterName) || clazz.getAnnotation(AnalysisSettingsRequired.class) != null || this.indicesAnalysisService.hasCharFilter(charFilterName)) continue;
            charFilterBinder.addBinding(charFilterName).toProvider(FactoryProvider.newFactory(CharFilterFactoryFactory.class, clazz)).in(Scopes.SINGLETON);
        }
        MapBinder<String, TokenFilterFactoryFactory> tokenFilterBinder = MapBinder.newMapBinder(this.binder(), String.class, TokenFilterFactoryFactory.class);
        AnalysisBinderProcessor.TokenFiltersBindings tokenFiltersBindings = new AnalysisBinderProcessor.TokenFiltersBindings();
        for (AnalysisBinderProcessor processor : this.processors) {
            processor.processTokenFilters(tokenFiltersBindings);
        }
        tokenFiltersBindings.tokenFilters.putAll(this.tokenFilters);
        Map<String, Settings> tokenFiltersSettings = this.settings.getGroups("index.analysis.filter");
        for (Map.Entry<String, Settings> entry : tokenFiltersSettings.entrySet()) {
            tokenFilterName = entry.getKey();
            Settings tokenFilterSettings = entry.getValue();
            String string = tokenFilterSettings.get("type");
            if (string == null) {
                throw new IllegalArgumentException("TokenFilter [" + tokenFilterName + "] must have a type associated with it");
            }
            Class type = (Class)tokenFiltersBindings.tokenFilters.get(string);
            if (type == null) {
                throw new IllegalArgumentException("Unknown TokenFilter type [" + string + "] for [" + tokenFilterName + "]");
            }
            tokenFilterBinder.addBinding(tokenFilterName).toProvider(FactoryProvider.newFactory(TokenFilterFactoryFactory.class, type)).in(Scopes.SINGLETON);
        }
        for (Map.Entry<String, Settings> entry : tokenFiltersBindings.tokenFilters.entrySet()) {
            tokenFilterName = entry.getKey();
            Class clazz = (Class)((Object)entry.getValue());
            if (tokenFiltersSettings.containsKey(tokenFilterName) || clazz.getAnnotation(AnalysisSettingsRequired.class) != null || this.indicesAnalysisService.hasTokenFilter(tokenFilterName)) continue;
            tokenFilterBinder.addBinding(tokenFilterName).toProvider(FactoryProvider.newFactory(TokenFilterFactoryFactory.class, clazz)).in(Scopes.SINGLETON);
        }
        MapBinder<String, TokenizerFactoryFactory> tokenizerBinder = MapBinder.newMapBinder(this.binder(), String.class, TokenizerFactoryFactory.class);
        AnalysisBinderProcessor.TokenizersBindings tokenizersBindings = new AnalysisBinderProcessor.TokenizersBindings();
        for (AnalysisBinderProcessor processor : this.processors) {
            processor.processTokenizers(tokenizersBindings);
        }
        tokenizersBindings.tokenizers.putAll(this.tokenizers);
        Map<String, Settings> tokenizersSettings = this.settings.getGroups("index.analysis.tokenizer");
        for (Map.Entry<String, Settings> entry : tokenizersSettings.entrySet()) {
            tokenizerName = entry.getKey();
            Settings tokenizerSettings = entry.getValue();
            String string = tokenizerSettings.get("type");
            if (string == null) {
                throw new IllegalArgumentException("Tokenizer [" + tokenizerName + "] must have a type associated with it");
            }
            Class type = (Class)tokenizersBindings.tokenizers.get(string);
            if (type == null) {
                throw new IllegalArgumentException("Unknown Tokenizer type [" + string + "] for [" + tokenizerName + "]");
            }
            tokenizerBinder.addBinding(tokenizerName).toProvider(FactoryProvider.newFactory(TokenizerFactoryFactory.class, type)).in(Scopes.SINGLETON);
        }
        for (Map.Entry<String, Settings> entry : tokenizersBindings.tokenizers.entrySet()) {
            tokenizerName = entry.getKey();
            Class clazz = (Class)((Object)entry.getValue());
            if (tokenizersSettings.containsKey(tokenizerName) || clazz.getAnnotation(AnalysisSettingsRequired.class) != null || this.indicesAnalysisService.hasTokenizer(tokenizerName)) continue;
            tokenizerBinder.addBinding(tokenizerName).toProvider(FactoryProvider.newFactory(TokenizerFactoryFactory.class, clazz)).in(Scopes.SINGLETON);
        }
        MapBinder<String, AnalyzerProviderFactory> analyzerBinder = MapBinder.newMapBinder(this.binder(), String.class, AnalyzerProviderFactory.class);
        AnalysisBinderProcessor.AnalyzersBindings analyzersBindings = new AnalysisBinderProcessor.AnalyzersBindings();
        for (AnalysisBinderProcessor processor : this.processors) {
            processor.processAnalyzers(analyzersBindings);
        }
        analyzersBindings.analyzers.putAll(this.analyzers);
        Map<String, Settings> analyzersSettings = this.settings.getGroups("index.analysis.analyzer");
        for (Map.Entry<String, Settings> entry : analyzersSettings.entrySet()) {
            Class type;
            analyzerName = entry.getKey();
            Settings analyzerSettings = entry.getValue();
            String typeName = analyzerSettings.get("type");
            if (typeName == null) {
                if (analyzerSettings.get("tokenizer") == null) throw new IllegalArgumentException("Analyzer [" + analyzerName + "] must have a type associated with it");
                type = CustomAnalyzerProvider.class;
            } else if (typeName.equals("custom")) {
                type = CustomAnalyzerProvider.class;
            } else {
                type = (Class)analyzersBindings.analyzers.get(typeName);
                if (type == null) {
                    throw new IllegalArgumentException("Unknown Analyzer type [" + typeName + "] for [" + analyzerName + "]");
                }
            }
            analyzerBinder.addBinding(analyzerName).toProvider(FactoryProvider.newFactory(AnalyzerProviderFactory.class, type)).in(Scopes.SINGLETON);
        }
        for (Map.Entry<String, Settings> entry : analyzersBindings.analyzers.entrySet()) {
            analyzerName = entry.getKey();
            Class clazz = (Class)((Object)entry.getValue());
            if (analyzersSettings.containsKey(analyzerName) || clazz.getAnnotation(AnalysisSettingsRequired.class) != null || this.indicesAnalysisService.hasAnalyzer(analyzerName)) continue;
            analyzerBinder.addBinding(analyzerName).toProvider(FactoryProvider.newFactory(AnalyzerProviderFactory.class, clazz)).in(Scopes.SINGLETON);
        }
        this.bind(AnalysisService.class).in(Scopes.SINGLETON);
    }

    private static class ExtendedProcessor
    extends AnalysisBinderProcessor {
        private ExtendedProcessor() {
        }

        @Override
        public void processCharFilters(AnalysisBinderProcessor.CharFiltersBindings charFiltersBindings) {
            charFiltersBindings.processCharFilter("mapping", MappingCharFilterFactory.class);
        }

        @Override
        public void processTokenFilters(AnalysisBinderProcessor.TokenFiltersBindings tokenFiltersBindings) {
            tokenFiltersBindings.processTokenFilter("snowball", SnowballTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("stemmer", StemmerTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("word_delimiter", WordDelimiterTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("delimited_payload_filter", DelimitedPayloadTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("synonym", SynonymTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("elision", ElisionTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("keep", KeepWordFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("keep_types", KeepTypesFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("pattern_capture", PatternCaptureGroupTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("pattern_replace", PatternReplaceTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("dictionary_decompounder", DictionaryCompoundWordTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("hyphenation_decompounder", HyphenationCompoundWordTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("arabic_stem", ArabicStemTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("brazilian_stem", BrazilianStemTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("czech_stem", CzechStemTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("dutch_stem", DutchStemTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("french_stem", FrenchStemTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("german_stem", GermanStemTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("russian_stem", RussianStemTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("keyword_marker", KeywordMarkerTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("stemmer_override", StemmerOverrideTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("arabic_normalization", ArabicNormalizationFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("german_normalization", GermanNormalizationFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("hindi_normalization", HindiNormalizationFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("indic_normalization", IndicNormalizationFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("sorani_normalization", SoraniNormalizationFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("persian_normalization", PersianNormalizationFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("scandinavian_normalization", ScandinavianNormalizationFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("scandinavian_folding", ScandinavianFoldingFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("serbian_normalization", SerbianNormalizationFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("hunspell", HunspellTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("cjk_bigram", CJKBigramFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("cjk_width", CJKWidthFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("apostrophe", ApostropheFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("classic", ClassicFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("decimal_digit", DecimalDigitFilterFactory.class);
        }

        @Override
        public void processTokenizers(AnalysisBinderProcessor.TokenizersBindings tokenizersBindings) {
            tokenizersBindings.processTokenizer("pattern", PatternTokenizerFactory.class);
            tokenizersBindings.processTokenizer("classic", ClassicTokenizerFactory.class);
            tokenizersBindings.processTokenizer("thai", ThaiTokenizerFactory.class);
        }

        @Override
        public void processAnalyzers(AnalysisBinderProcessor.AnalyzersBindings analyzersBindings) {
            analyzersBindings.processAnalyzer("pattern", PatternAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("snowball", SnowballAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("arabic", ArabicAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("armenian", ArmenianAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("basque", BasqueAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("brazilian", BrazilianAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("bulgarian", BulgarianAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("catalan", CatalanAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("chinese", ChineseAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("cjk", CjkAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("czech", CzechAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("danish", DanishAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("dutch", DutchAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("english", EnglishAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("finnish", FinnishAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("french", FrenchAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("galician", GalicianAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("german", GermanAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("greek", GreekAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("hindi", HindiAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("hungarian", HungarianAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("indonesian", IndonesianAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("irish", IrishAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("italian", ItalianAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("latvian", LatvianAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("lithuanian", LithuanianAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("norwegian", NorwegianAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("persian", PersianAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("portuguese", PortugueseAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("romanian", RomanianAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("russian", RussianAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("sorani", SoraniAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("spanish", SpanishAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("swedish", SwedishAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("turkish", TurkishAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("thai", ThaiAnalyzerProvider.class);
        }
    }

    private static class DefaultProcessor
    extends AnalysisBinderProcessor {
        private DefaultProcessor() {
        }

        @Override
        public void processCharFilters(AnalysisBinderProcessor.CharFiltersBindings charFiltersBindings) {
            charFiltersBindings.processCharFilter("html_strip", HtmlStripCharFilterFactory.class);
            charFiltersBindings.processCharFilter("pattern_replace", PatternReplaceCharFilterFactory.class);
        }

        @Override
        public void processTokenFilters(AnalysisBinderProcessor.TokenFiltersBindings tokenFiltersBindings) {
            tokenFiltersBindings.processTokenFilter("stop", StopTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("reverse", ReverseTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("asciifolding", ASCIIFoldingTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("length", LengthTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("lowercase", LowerCaseTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("uppercase", UpperCaseTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("porter_stem", PorterStemTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("kstem", KStemTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("standard", StandardTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("nGram", NGramTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("ngram", NGramTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("edgeNGram", EdgeNGramTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("edge_ngram", EdgeNGramTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("shingle", ShingleTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("unique", UniqueTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("truncate", TruncateTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("trim", TrimTokenFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("limit", LimitTokenCountFilterFactory.class);
            tokenFiltersBindings.processTokenFilter("common_grams", CommonGramsTokenFilterFactory.class);
        }

        @Override
        public void processTokenizers(AnalysisBinderProcessor.TokenizersBindings tokenizersBindings) {
            tokenizersBindings.processTokenizer("standard", StandardTokenizerFactory.class);
            tokenizersBindings.processTokenizer("uax_url_email", UAX29URLEmailTokenizerFactory.class);
            tokenizersBindings.processTokenizer("path_hierarchy", PathHierarchyTokenizerFactory.class);
            tokenizersBindings.processTokenizer("PathHierarchy", PathHierarchyTokenizerFactory.class);
            tokenizersBindings.processTokenizer("keyword", KeywordTokenizerFactory.class);
            tokenizersBindings.processTokenizer("letter", LetterTokenizerFactory.class);
            tokenizersBindings.processTokenizer("lowercase", LowerCaseTokenizerFactory.class);
            tokenizersBindings.processTokenizer("whitespace", WhitespaceTokenizerFactory.class);
            tokenizersBindings.processTokenizer("nGram", NGramTokenizerFactory.class);
            tokenizersBindings.processTokenizer("ngram", NGramTokenizerFactory.class);
            tokenizersBindings.processTokenizer("edgeNGram", EdgeNGramTokenizerFactory.class);
            tokenizersBindings.processTokenizer("edge_ngram", EdgeNGramTokenizerFactory.class);
        }

        @Override
        public void processAnalyzers(AnalysisBinderProcessor.AnalyzersBindings analyzersBindings) {
            analyzersBindings.processAnalyzer("default", StandardAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("standard", StandardAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("standard_html_strip", StandardHtmlStripAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("simple", SimpleAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("stop", StopAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("whitespace", WhitespaceAnalyzerProvider.class);
            analyzersBindings.processAnalyzer("keyword", KeywordAnalyzerProvider.class);
        }
    }

    public static class AnalysisBinderProcessor {
        public void processCharFilters(CharFiltersBindings charFiltersBindings) {
        }

        public void processTokenFilters(TokenFiltersBindings tokenFiltersBindings) {
        }

        public void processTokenizers(TokenizersBindings tokenizersBindings) {
        }

        public void processAnalyzers(AnalyzersBindings analyzersBindings) {
        }

        public static class AnalyzersBindings {
            private final Map<String, Class<? extends AnalyzerProvider>> analyzers = Maps.newHashMap();

            public void processAnalyzer(String name, Class<? extends AnalyzerProvider> analyzerProvider) {
                this.analyzers.put(name, analyzerProvider);
            }
        }

        public static class TokenizersBindings {
            private final Map<String, Class<? extends TokenizerFactory>> tokenizers = Maps.newHashMap();

            public void processTokenizer(String name, Class<? extends TokenizerFactory> tokenizerFactory) {
                this.tokenizers.put(name, tokenizerFactory);
            }
        }

        public static class TokenFiltersBindings {
            private final Map<String, Class<? extends TokenFilterFactory>> tokenFilters = Maps.newHashMap();

            public void processTokenFilter(String name, Class<? extends TokenFilterFactory> tokenFilterFactory) {
                this.tokenFilters.put(name, tokenFilterFactory);
            }
        }

        public static class CharFiltersBindings {
            private final Map<String, Class<? extends CharFilterFactory>> charFilters = Maps.newHashMap();

            public void processCharFilter(String name, Class<? extends CharFilterFactory> charFilterFactory) {
                this.charFilters.put(name, charFilterFactory);
            }
        }
    }
}

