/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.ast;

import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.NodeVisitor;

public class ConditionalExpression
extends AstNode {
    private AstNode testExpression;
    private AstNode trueExpression;
    private AstNode falseExpression;
    private int questionMarkPosition = -1;
    private int colonPosition = -1;

    public ConditionalExpression() {
        this.type = 102;
    }

    public ConditionalExpression(int n) {
        super(n);
        this.type = 102;
    }

    public ConditionalExpression(int n, int n2) {
        super(n, n2);
        this.type = 102;
    }

    public AstNode getTestExpression() {
        return this.testExpression;
    }

    public void setTestExpression(AstNode astNode) {
        this.assertNotNull(astNode);
        this.testExpression = astNode;
        astNode.setParent(this);
    }

    public AstNode getTrueExpression() {
        return this.trueExpression;
    }

    public void setTrueExpression(AstNode astNode) {
        this.assertNotNull(astNode);
        this.trueExpression = astNode;
        astNode.setParent(this);
    }

    public AstNode getFalseExpression() {
        return this.falseExpression;
    }

    public void setFalseExpression(AstNode astNode) {
        this.assertNotNull(astNode);
        this.falseExpression = astNode;
        astNode.setParent(this);
    }

    public int getQuestionMarkPosition() {
        return this.questionMarkPosition;
    }

    public void setQuestionMarkPosition(int n) {
        this.questionMarkPosition = n;
    }

    public int getColonPosition() {
        return this.colonPosition;
    }

    public void setColonPosition(int n) {
        this.colonPosition = n;
    }

    @Override
    public boolean hasSideEffects() {
        if (this.testExpression == null || this.trueExpression == null || this.falseExpression == null) {
            ConditionalExpression.codeBug();
        }
        return this.trueExpression.hasSideEffects() && this.falseExpression.hasSideEffects();
    }

    @Override
    public String toSource(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.makeIndent(n));
        stringBuilder.append(this.testExpression.toSource(n));
        stringBuilder.append(" ? ");
        stringBuilder.append(this.trueExpression.toSource(0));
        stringBuilder.append(" : ");
        stringBuilder.append(this.falseExpression.toSource(0));
        return stringBuilder.toString();
    }

    @Override
    public void visit(NodeVisitor nodeVisitor) {
        if (nodeVisitor.visit(this)) {
            this.testExpression.visit(nodeVisitor);
            this.trueExpression.visit(nodeVisitor);
            this.falseExpression.visit(nodeVisitor);
        }
    }
}

