/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.treemodel;

import jadx.api.ResourceFile;
import jadx.api.ResourceType;
import jadx.core.codegen.CodeWriter;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.utils.OverlayIcon;
import jadx.gui.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class JResource
extends JNode
implements Comparable<JResource> {
    private static final long serialVersionUID = -201018424302612434L;
    private static final ImageIcon ROOT_ICON = Utils.openIcon("cf_obj");
    private static final ImageIcon FOLDER_ICON = Utils.openIcon("folder");
    private static final ImageIcon FILE_ICON = Utils.openIcon("file_obj");
    private static final ImageIcon MANIFEST_ICON = Utils.openIcon("template_obj");
    private static final ImageIcon JAVA_ICON = Utils.openIcon("java_ovr");
    private static final ImageIcon ERROR_ICON = Utils.openIcon("error_co");
    private final String name;
    private final List<JResource> files = new ArrayList<JResource>(1);
    private final JResType type;
    private final ResourceFile resFile;
    private boolean loaded;
    private String content;
    private Map<Integer, Integer> lineMapping;

    public JResource(ResourceFile resFile, String name, JResType type) {
        this.resFile = resFile;
        this.name = name;
        this.type = type;
    }

    public final void update() {
        this.removeAllChildren();
        for (JResource res : this.files) {
            res.update();
            this.add(res);
        }
    }

    public String getName() {
        return this.name;
    }

    public List<JResource> getFiles() {
        return this.files;
    }

    @Override
    public String getContent() {
        if (!this.loaded && this.resFile != null && this.type == JResType.FILE) {
            CodeWriter cw;
            this.loaded = true;
            if (this.isSupportedForView(this.resFile.getType()) && (cw = this.resFile.getContent()) != null) {
                this.lineMapping = cw.getLineMapping();
                this.content = cw.toString();
            }
        }
        return this.content;
    }

    @Override
    public Integer getSourceLine(int line) {
        if (this.lineMapping == null) {
            return null;
        }
        return this.lineMapping.get(line);
    }

    @Override
    public String getSyntaxName() {
        switch (this.resFile.getType()) {
            case CODE: {
                return super.getSyntaxName();
            }
            case MANIFEST: 
            case XML: {
                return "text/xml";
            }
        }
        String syntax = this.getSyntaxByExtension(this.resFile.getName());
        if (syntax != null) {
            return syntax;
        }
        return super.getSyntaxName();
    }

    private String getSyntaxByExtension(String name) {
        int dot = name.lastIndexOf(46);
        if (dot == -1) {
            return null;
        }
        String ext = name.substring(dot + 1);
        if (ext.equals("js")) {
            return "text/javascript";
        }
        if (ext.equals("css")) {
            return "text/css";
        }
        if (ext.equals("html")) {
            return "text/html";
        }
        return null;
    }

    @Override
    public Icon getIcon() {
        switch (this.type) {
            case ROOT: {
                return ROOT_ICON;
            }
            case DIR: {
                return FOLDER_ICON;
            }
            case FILE: {
                ResourceType resType = this.resFile.getType();
                if (resType == ResourceType.MANIFEST) {
                    return MANIFEST_ICON;
                }
                if (resType == ResourceType.CODE) {
                    return new OverlayIcon(FILE_ICON, ERROR_ICON, JAVA_ICON);
                }
                if (!this.isSupportedForView(resType)) {
                    return new OverlayIcon(FILE_ICON, ERROR_ICON);
                }
                return FILE_ICON;
            }
        }
        return FILE_ICON;
    }

    private boolean isSupportedForView(ResourceType type) {
        switch (type) {
            case CODE: 
            case FONT: 
            case IMG: 
            case LIB: {
                return false;
            }
            case MANIFEST: 
            case XML: 
            case ARSC: 
            case UNKNOWN: {
                return true;
            }
        }
        return true;
    }

    @Override
    public JClass getJParent() {
        return null;
    }

    @Override
    public int compareTo(JResource o) {
        return this.name.compareTo(o.name);
    }

    @Override
    public String makeString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.name.equals(((JResource)o).name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static enum JResType {
        ROOT,
        DIR,
        FILE;

    }
}

