/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.geodesic;

import javajs.util.AU;
import javajs.util.M3;
import javajs.util.P3;
import javajs.util.V3;
import org.jmol.api.AtomIndexIterator;
import org.jmol.api.JmolEnvCalc;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.atomdata.RadiusData;
import org.jmol.java.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Geodesic;
import org.jmol.util.Normix;

public final class EnvelopeCalculation
implements JmolEnvCalc {
    private BS geodesicMap;
    private BS mapT;
    private short[] mads;
    private AtomData atomData = new AtomData();
    private AtomDataServer vwr;
    private int ac;
    private static BS EMPTY_SET;
    private float maxRadius = 0.0f;
    private boolean modelZeroBased;
    private boolean disregardNeighbors = false;
    private BS bsMySelected;
    private BS[] dotsConvexMaps;
    private int dotsConvexMax;
    private int geodesicCount;
    private BS bsSurface;
    private float radiusP;
    private float diameterP;
    private BS bsTemp;
    private BS bsIgnore;
    private boolean onlySelectedDots;
    private boolean isSurface;
    private boolean multiModel;
    private P3[] currentPoints;
    private int indexI;
    private P3 centerI;
    private float radiusI;
    private float radiiIP2;
    private final P3 pointT = new P3();
    private P3 centerT;
    private final P3[] vertexTest = new P3[12];
    private static int[] power4;
    private int neighborCount;
    private int[] neighborIndices;
    private P3[] neighborCenters;
    private float[] neighborPlusProbeRadii2;
    private float[] neighborRadii2;

    public EnvelopeCalculation() {
        for (int i = 0; i < 12; ++i) {
            this.vertexTest[i] = new P3();
        }
        this.neighborIndices = new int[16];
        this.neighborCenters = new P3[16];
        this.neighborPlusProbeRadii2 = new float[16];
        this.neighborRadii2 = new float[16];
    }

    @Override
    public EnvelopeCalculation set(AtomDataServer vwr, int ac, short[] mads) {
        this.vwr = vwr;
        this.ac = ac;
        this.mads = mads;
        this.geodesicCount = Geodesic.getVertexCount(3);
        this.geodesicMap = BS.newN(this.geodesicCount);
        this.mapT = BS.newN(this.geodesicCount);
        EMPTY_SET = BSUtil.emptySet;
        return this;
    }

    public BS[] getDotsConvexMaps() {
        return this.dotsConvexMaps;
    }

    public int getDotsConvexMax() {
        return this.dotsConvexMax;
    }

    public void allocDotsConvexMaps(int max) {
        if (this.dotsConvexMax >= max) {
            return;
        }
        this.dotsConvexMax = max;
        this.dotsConvexMaps = new BS[max];
    }

    @Override
    public BS getBsSurfaceClone() {
        return BSUtil.copy(this.bsSurface);
    }

    public void setMads(short[] mads) {
        this.mads = mads;
    }

    public void setFromBits(int index, BS bs) {
        this.geodesicMap.setBits(0, this.geodesicCount);
        int iDot = this.geodesicCount;
        while (--iDot >= 0) {
            if (bs.get(iDot)) continue;
            this.geodesicMap.clear(iDot);
        }
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMaps = new BS[this.ac];
        }
        BS map = this.geodesicMap.isEmpty() ? EMPTY_SET : BSUtil.copy(this.geodesicMap);
        if (index >= this.dotsConvexMaps.length) {
            return;
        }
        this.dotsConvexMaps[index] = map;
        this.dotsConvexMax = Math.max(this.dotsConvexMax, index);
    }

    public void newSet() {
        this.dotsConvexMax = 0;
        this.dotsConvexMaps = null;
        this.diameterP = 0.0f;
        this.radiusP = 0.0f;
        this.mads = null;
    }

    public void reCalculate(BS bs, M3 m) {
        if (this.atomData.radiusData != null) {
            this.calculate(null, this.maxRadius, bs, this.bsIgnore, this.disregardNeighbors, this.onlySelectedDots, this.isSurface, this.multiModel);
            return;
        }
        if (this.dotsConvexMaps == null || this.dotsConvexMax == 0) {
            return;
        }
        V3 pt = new V3();
        if (this.bsTemp == null) {
            this.bsTemp = Normix.newVertexBitSet();
        }
        int i = bs.nextSetBit(0);
        while (i >= 0) {
            if (i >= this.dotsConvexMax) {
                return;
            }
            BS map = this.dotsConvexMaps[i];
            if (map != null && !map.isEmpty()) {
                BS bsNew = new BS();
                int j = map.nextSetBit(0);
                while (j >= 0) {
                    pt.setT(Geodesic.getVertexVector(j));
                    m.rotate(pt);
                    bsNew.set(Normix.getNormixV(pt, this.bsTemp));
                    j = map.nextSetBit(j + 1);
                }
                this.dotsConvexMaps[i] = bsNew;
            }
            i = bs.nextSetBit(i + 1);
        }
    }

    @Override
    public void calculate(RadiusData rd, float maxRadius, BS bsSelected, BS bsIgnore, boolean disregardNeighbors, boolean onlySelectedDots, boolean isSurface, boolean multiModel) {
        int i0;
        if (rd == null) {
            rd = this.atomData.radiusData;
            if (rd == null) {
                return;
            }
        } else {
            this.atomData.radiusData = rd;
            this.bsIgnore = bsIgnore;
            this.onlySelectedDots = onlySelectedDots;
            this.multiModel = multiModel;
            this.isSurface = isSurface;
        }
        if (rd.value == Float.MAX_VALUE) {
            rd.value = 3.0f;
        }
        this.atomData.modelIndex = multiModel ? -1 : 0;
        this.modelZeroBased = !multiModel;
        this.vwr.fillAtomData(this.atomData, 1 | (this.mads == null ? 2 : 0));
        this.ac = this.atomData.ac;
        if (this.mads != null) {
            for (int i = 0; i < this.ac; ++i) {
                this.atomData.atomRadius[i] = (float)this.mads[i] / 1000.0f;
            }
        }
        this.bsMySelected = onlySelectedDots && bsSelected != null ? BSUtil.copy(bsSelected) : (bsIgnore != null ? BSUtil.setAll(this.ac) : null);
        BSUtil.andNot(this.bsMySelected, bsIgnore);
        this.disregardNeighbors = disregardNeighbors;
        this.maxRadius = maxRadius;
        this.bsSurface = new BS();
        boolean isAll = bsSelected == null;
        AtomIndexIterator iter = this.vwr.getSelectedAtomIterator(this.bsMySelected, false, this.modelZeroBased, false);
        this.checkNewDotsArray();
        int i = i0 = isAll ? this.ac - 1 : bsSelected.nextSetBit(0);
        while (i >= 0) {
            if (bsIgnore == null || !bsIgnore.get(i)) {
                this.setAtomI(i);
                this.getNeighbors(iter);
                this.calcConvexMap(isSurface);
            }
            i = isAll ? i - 1 : bsSelected.nextSetBit(i + 1);
        }
        iter.release();
        this.currentPoints = null;
        this.setDotsConvexMax();
    }

    public float getRadius(int atomIndex) {
        return this.atomData.atomRadius[atomIndex];
    }

    @Override
    public P3[] getPoints() {
        if (this.dotsConvexMaps == null) {
            this.calculate(new RadiusData(null, 3.0f, RadiusData.EnumType.ABSOLUTE, null), Float.MAX_VALUE, this.bsMySelected, null, false, false, false, false);
        }
        if (this.currentPoints != null) {
            return this.currentPoints;
        }
        int nPoints = 0;
        int dotCount = 42;
        int i = this.dotsConvexMax;
        while (--i >= 0) {
            if (this.dotsConvexMaps[i] == null) continue;
            nPoints += this.dotsConvexMaps[i].cardinalityN(dotCount);
        }
        P3[] points = new P3[nPoints];
        if (nPoints == 0) {
            return points;
        }
        nPoints = 0;
        int i2 = this.dotsConvexMax;
        while (--i2 >= 0) {
            if (this.dotsConvexMaps[i2] == null) continue;
            int iDot = this.dotsConvexMaps[i2].size();
            if (iDot > dotCount) {
                iDot = dotCount;
            }
            while (--iDot >= 0) {
                if (!this.dotsConvexMaps[i2].get(iDot)) continue;
                P3 pt = new P3();
                pt.scaleAdd2(this.atomData.atomRadius[i2], Geodesic.getVertexVector(iDot), this.atomData.xyz[i2]);
                points[nPoints++] = pt;
            }
        }
        this.currentPoints = points;
        return points;
    }

    private void setDotsConvexMax() {
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMax = 0;
        } else {
            int i = this.ac;
            while (--i >= 0 && this.dotsConvexMaps[i] == null) {
            }
            this.dotsConvexMax = i + 1;
        }
    }

    public float getAppropriateRadius(int atomIndex) {
        return this.mads != null ? (atomIndex >= this.mads.length ? 0.0f : (float)this.mads[atomIndex] / 1000.0f) : this.atomData.atomRadius[atomIndex];
    }

    private void setAtomI(int indexI) {
        this.indexI = indexI;
        this.centerI = this.atomData.xyz[indexI];
        this.radiusI = this.atomData.atomRadius[indexI];
        this.radiiIP2 = this.radiusI + this.radiusP;
        this.radiiIP2 *= this.radiiIP2;
    }

    private void calcConvexMap(boolean isSurface) {
        BS map;
        this.calcConvexBits();
        if (this.geodesicMap.isEmpty()) {
            map = EMPTY_SET;
        } else {
            this.bsSurface.set(this.indexI);
            if (isSurface) {
                this.addIncompleteFaces(this.geodesicMap);
                this.addIncompleteFaces(this.geodesicMap);
            }
            map = BSUtil.copy(this.geodesicMap);
        }
        this.dotsConvexMaps[this.indexI] = map;
    }

    private void addIncompleteFaces(BS points) {
        this.mapT.clearAll();
        short[] faces = Geodesic.getFaceVertexes(3);
        int len = faces.length;
        short maxPt = -1;
        int f = 0;
        while (f < len) {
            short p1 = faces[f++];
            short p2 = faces[f++];
            short p3 = faces[f++];
            boolean ok1 = points.get(p1);
            boolean ok2 = points.get(p2);
            boolean ok3 = points.get(p3);
            if (!ok1 && !ok2 && !ok3 || ok1 && ok2 && ok3) continue;
            if (!ok1) {
                this.mapT.set(p1);
                if (maxPt < p1) {
                    maxPt = p1;
                }
            }
            if (!ok2) {
                this.mapT.set(p2);
                if (maxPt < p2) {
                    maxPt = p2;
                }
            }
            if (ok3) continue;
            this.mapT.set(p3);
            if (maxPt >= p3) continue;
            maxPt = p3;
        }
        for (short i = 0; i <= maxPt; ++i) {
            if (!this.mapT.get(i)) continue;
            points.set(i);
        }
    }

    private void calcConvexBits() {
        this.geodesicMap.setBits(0, this.geodesicCount);
        float combinedRadii = this.radiusI + this.radiusP;
        if (this.neighborCount == 0) {
            return;
        }
        short[] faces = Geodesic.getFaceVertexes(3);
        int p4 = power4[2];
        this.mapT.clearAll();
        for (int i = 0; i < 12; ++i) {
            this.vertexTest[i].scaleAdd2(combinedRadii, Geodesic.getVertexVector(i), this.centerI);
        }
        for (int f = 0; f < 20; ++f) {
            int faceTest = 0;
            short p1 = faces[3 * p4 * (4 * f + 0)];
            short p2 = faces[3 * p4 * (4 * f + 1)];
            short p3 = faces[3 * p4 * (4 * f + 2)];
            for (int j = 0; j < this.neighborCount; ++j) {
                boolean ok3;
                float maxDist = this.neighborPlusProbeRadii2[j];
                this.centerT = this.neighborCenters[j];
                boolean ok1 = this.vertexTest[p1].distanceSquared(this.centerT) >= maxDist;
                boolean ok2 = this.vertexTest[p2].distanceSquared(this.centerT) >= maxDist;
                boolean bl = ok3 = this.vertexTest[p3].distanceSquared(this.centerT) >= maxDist;
                if (!ok1) {
                    this.geodesicMap.clear(p1);
                }
                if (!ok2) {
                    this.geodesicMap.clear(p2);
                }
                if (!ok3) {
                    this.geodesicMap.clear(p3);
                }
                if (ok1 || ok2 || ok3) continue;
                faceTest = -1;
                break;
            }
            int kFirst = f * 12 * p4;
            int kLast = kFirst + 12 * p4;
            for (int k = kFirst; k < kLast; ++k) {
                short vect = faces[k];
                if (this.mapT.get(vect) || !this.geodesicMap.get(vect)) continue;
                switch (faceTest) {
                    case -1: {
                        this.geodesicMap.clear(vect);
                        break;
                    }
                    case 0: {
                        for (int j = 0; j < this.neighborCount; ++j) {
                            float maxDist = this.neighborPlusProbeRadii2[j];
                            this.centerT = this.neighborCenters[j];
                            this.pointT.scaleAdd2(combinedRadii, Geodesic.getVertexVector(vect), this.centerI);
                            if (!(this.pointT.distanceSquared(this.centerT) < maxDist)) continue;
                            this.geodesicMap.clear(vect);
                        }
                        break;
                    }
                }
                this.mapT.set(vect);
            }
        }
    }

    private void checkNewDotsArray() {
        if (this.dotsConvexMaps == null) {
            this.dotsConvexMaps = new BS[this.ac];
        } else if (this.dotsConvexMaps.length != this.ac) {
            BS[] a = new BS[this.ac];
            for (int i = 0; i < this.ac && i < this.dotsConvexMaps.length; ++i) {
                a[i] = this.dotsConvexMaps[i];
            }
            this.dotsConvexMaps = a;
        }
    }

    private AtomIndexIterator getNeighbors(AtomIndexIterator iter) {
        this.neighborCount = 0;
        if (this.disregardNeighbors) {
            return null;
        }
        this.vwr.setIteratorForAtom(iter, this.indexI, this.radiusI + this.diameterP + this.maxRadius);
        while (iter.hasNext()) {
            int indexN = iter.next();
            float neighborRadius = this.atomData.atomRadius[indexN];
            if (this.centerI.distance(this.atomData.xyz[indexN]) > this.radiusI + this.radiusP + this.radiusP + neighborRadius) continue;
            if (this.neighborCount == this.neighborIndices.length) {
                this.neighborIndices = AU.doubleLengthI(this.neighborIndices);
                this.neighborCenters = (P3[])AU.doubleLength(this.neighborCenters);
                this.neighborPlusProbeRadii2 = AU.doubleLengthF(this.neighborPlusProbeRadii2);
                this.neighborRadii2 = AU.doubleLengthF(this.neighborRadii2);
            }
            this.neighborCenters[this.neighborCount] = this.atomData.xyz[indexN];
            this.neighborIndices[this.neighborCount] = indexN;
            float r = neighborRadius + this.radiusP;
            this.neighborPlusProbeRadii2[this.neighborCount] = r * r;
            this.neighborRadii2[this.neighborCount] = neighborRadius * neighborRadius;
            ++this.neighborCount;
        }
        return iter;
    }

    public void deleteAtoms(int firstAtomDeleted, int nAtomsDeleted) {
        this.dotsConvexMaps = (BS[])AU.deleteElements(this.dotsConvexMaps, firstAtomDeleted, nAtomsDeleted);
        this.dotsConvexMax = this.dotsConvexMaps.length;
        if (this.mads != null) {
            this.mads = (short[])AU.deleteElements(this.mads, firstAtomDeleted, nAtomsDeleted);
        }
        this.atomData.atomRadius = (float[])AU.deleteElements(this.atomData.atomRadius, firstAtomDeleted, nAtomsDeleted);
        this.atomData.xyz = (P3[])AU.deleteElements(this.atomData.xyz, firstAtomDeleted, nAtomsDeleted);
        this.atomData.ac -= nAtomsDeleted;
        this.ac = this.atomData.ac;
    }

    static {
        power4 = new int[]{1, 4, 16, 64, 256};
    }
}

