/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.pack;

import com.oracle.truffle.api.nodes.Node;
import java.nio.ByteOrder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatEncoding;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.LiteralFormatNode;
import org.jruby.truffle.core.format.SharedTreeBuilder;
import org.jruby.truffle.core.format.control.AdvanceSourcePositionNode;
import org.jruby.truffle.core.format.control.ReverseOutputPositionNode;
import org.jruby.truffle.core.format.control.SequenceNode;
import org.jruby.truffle.core.format.control.SetOutputPositionNode;
import org.jruby.truffle.core.format.convert.Integer16BigToBytesNodeGen;
import org.jruby.truffle.core.format.convert.Integer16LittleToBytesNodeGen;
import org.jruby.truffle.core.format.convert.Integer32BigToBytesNodeGen;
import org.jruby.truffle.core.format.convert.Integer32LittleToBytesNodeGen;
import org.jruby.truffle.core.format.convert.Integer64BigToBytesNodeGen;
import org.jruby.truffle.core.format.convert.Integer64LittleToBytesNodeGen;
import org.jruby.truffle.core.format.convert.ReinterpretAsLongNodeGen;
import org.jruby.truffle.core.format.convert.ToFloatNodeGen;
import org.jruby.truffle.core.format.convert.ToLongNode;
import org.jruby.truffle.core.format.convert.ToLongNodeGen;
import org.jruby.truffle.core.format.pack.PackBaseListener;
import org.jruby.truffle.core.format.pack.PackParser;
import org.jruby.truffle.core.format.read.SourceNode;
import org.jruby.truffle.core.format.read.array.ReadDoubleNode;
import org.jruby.truffle.core.format.read.array.ReadDoubleNodeGen;
import org.jruby.truffle.core.format.read.array.ReadLongOrBigIntegerNodeGen;
import org.jruby.truffle.core.format.read.array.ReadStringNodeGen;
import org.jruby.truffle.core.format.read.array.ReadValueNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteBERNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteBase64StringNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteBinaryStringNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteBitStringNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteByteNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteBytesNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteHexStringNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteMIMEStringNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteUTF8CharacterNodeGen;
import org.jruby.truffle.core.format.write.bytes.WriteUUStringNodeGen;
import org.jruby.truffle.language.control.RaiseException;

public class PackTreeBuilder
extends PackBaseListener {
    private final RubyContext context;
    private final Node currentNode;
    private final SharedTreeBuilder sharedTreeBuilder;
    private FormatEncoding encoding = FormatEncoding.DEFAULT;
    private final Deque<List<FormatNode>> sequenceStack = new ArrayDeque<List<FormatNode>>();

    public PackTreeBuilder(RubyContext context, Node currentNode) {
        this.context = context;
        this.currentNode = currentNode;
        this.sharedTreeBuilder = new SharedTreeBuilder(context);
        this.pushSequence();
    }

    @Override
    public void enterSequence(PackParser.SequenceContext ctx) {
        this.pushSequence();
    }

    @Override
    public void exitSequence(PackParser.SequenceContext ctx) {
        List<FormatNode> sequence = this.sequenceStack.pop();
        this.appendNode(new SequenceNode(this.context, sequence.toArray(new FormatNode[sequence.size()])));
    }

    @Override
    public void exitInt8(PackParser.Int8Context ctx) {
        this.appendIntegerNode(8, null, ctx.count());
    }

    @Override
    public void exitUint8(PackParser.Uint8Context ctx) {
        this.appendIntegerNode(8, null, ctx.count());
    }

    @Override
    public void exitInt16Little(PackParser.Int16LittleContext ctx) {
        this.appendIntegerNode(16, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitInt16Big(PackParser.Int16BigContext ctx) {
        this.appendIntegerNode(16, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitInt16Native(PackParser.Int16NativeContext ctx) {
        this.appendIntegerNode(16, ByteOrder.nativeOrder(), ctx.count());
    }

    @Override
    public void exitUint16Little(PackParser.Uint16LittleContext ctx) {
        this.appendIntegerNode(16, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitUint16Big(PackParser.Uint16BigContext ctx) {
        this.appendIntegerNode(16, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitUint16Native(PackParser.Uint16NativeContext ctx) {
        this.appendIntegerNode(16, ByteOrder.nativeOrder(), ctx.count());
    }

    @Override
    public void exitInt32Little(PackParser.Int32LittleContext ctx) {
        this.appendIntegerNode(32, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitInt32Big(PackParser.Int32BigContext ctx) {
        this.appendIntegerNode(32, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitInt32Native(PackParser.Int32NativeContext ctx) {
        this.appendIntegerNode(32, ByteOrder.nativeOrder(), ctx.count());
    }

    @Override
    public void exitUint32Little(PackParser.Uint32LittleContext ctx) {
        this.appendIntegerNode(32, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitUint32Big(PackParser.Uint32BigContext ctx) {
        this.appendIntegerNode(32, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitUint32Native(PackParser.Uint32NativeContext ctx) {
        this.appendIntegerNode(32, ByteOrder.nativeOrder(), ctx.count());
    }

    @Override
    public void exitInt64Little(PackParser.Int64LittleContext ctx) {
        this.appendIntegerNode(64, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitInt64Big(PackParser.Int64BigContext ctx) {
        this.appendIntegerNode(64, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitInt64Native(PackParser.Int64NativeContext ctx) {
        this.appendIntegerNode(64, ByteOrder.nativeOrder(), ctx.count());
    }

    @Override
    public void exitUint64Little(PackParser.Uint64LittleContext ctx) {
        this.appendIntegerNode(64, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitUint64Big(PackParser.Uint64BigContext ctx) {
        this.appendIntegerNode(64, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitUint64Native(PackParser.Uint64NativeContext ctx) {
        this.appendIntegerNode(64, ByteOrder.nativeOrder(), ctx.count());
    }

    @Override
    public void exitUtf8Character(PackParser.Utf8CharacterContext ctx) {
        this.unify(FormatEncoding.UTF_8);
        this.appendNode(this.sharedTreeBuilder.applyCount(ctx.count(), WriteUTF8CharacterNodeGen.create(this.context, ToLongNodeGen.create(this.context, false, ReadValueNodeGen.create(this.context, new SourceNode())))));
    }

    @Override
    public void exitBerInteger(PackParser.BerIntegerContext ctx) {
        this.appendNode(this.sharedTreeBuilder.applyCount(ctx.count(), WriteBERNodeGen.create(this.context, ReadLongOrBigIntegerNodeGen.create(this.context, new SourceNode()))));
    }

    @Override
    public void exitF64Native(PackParser.F64NativeContext ctx) {
        this.appendFloatNode(64, ByteOrder.nativeOrder(), ctx.count());
    }

    @Override
    public void exitF32Native(PackParser.F32NativeContext ctx) {
        this.appendFloatNode(32, ByteOrder.nativeOrder(), ctx.count());
    }

    @Override
    public void exitF64Little(PackParser.F64LittleContext ctx) {
        this.appendFloatNode(64, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitF32Little(PackParser.F32LittleContext ctx) {
        this.appendFloatNode(32, ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitF64Big(PackParser.F64BigContext ctx) {
        this.appendFloatNode(64, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitF32Big(PackParser.F32BigContext ctx) {
        this.appendFloatNode(32, ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitBinaryStringSpacePadded(PackParser.BinaryStringSpacePaddedContext ctx) {
        this.binaryString((byte)32, true, false, ctx.count());
    }

    @Override
    public void exitBinaryStringNullPadded(PackParser.BinaryStringNullPaddedContext ctx) {
        this.binaryString((byte)0, true, false, ctx.count());
    }

    @Override
    public void exitBinaryStringNullStar(PackParser.BinaryStringNullStarContext ctx) {
        this.binaryString((byte)0, true, ctx.count() != null && ctx.count().INT() == null, ctx.count());
    }

    @Override
    public void exitBitStringMSBFirst(PackParser.BitStringMSBFirstContext ctx) {
        this.bitString(ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitBitStringMSBLast(PackParser.BitStringMSBLastContext ctx) {
        this.bitString(ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitHexStringHighFirst(PackParser.HexStringHighFirstContext ctx) {
        this.hexString(ByteOrder.BIG_ENDIAN, ctx.count());
    }

    @Override
    public void exitHexStringLowFirst(PackParser.HexStringLowFirstContext ctx) {
        this.hexString(ByteOrder.LITTLE_ENDIAN, ctx.count());
    }

    @Override
    public void exitUuString(PackParser.UuStringContext ctx) {
        this.unify(FormatEncoding.US_ASCII);
        SharedTreeBuilder.StarLength starLength = this.sharedTreeBuilder.parseCountContext(ctx.count());
        this.appendNode(WriteUUStringNodeGen.create(this.context, starLength.getLength(), starLength.isStar(), ReadStringNodeGen.create(this.context, false, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    @Override
    public void exitMimeString(PackParser.MimeStringContext ctx) {
        int length;
        this.unify(FormatEncoding.US_ASCII);
        if (ctx.count() == null || ctx.count().INT() == null) {
            length = 72;
        } else {
            length = Integer.parseInt(ctx.count().INT().getText());
            if (length <= 1) {
                length = 72;
            }
        }
        this.appendNode(WriteMIMEStringNodeGen.create(this.context, length, ReadStringNodeGen.create(this.context, true, "to_s", true, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    @Override
    public void exitBase64String(PackParser.Base64StringContext ctx) {
        this.unify(FormatEncoding.US_ASCII);
        SharedTreeBuilder.StarLength starLength = this.sharedTreeBuilder.parseCountContext(ctx.count());
        this.appendNode(WriteBase64StringNodeGen.create(this.context, starLength.getLength(), starLength.isStar(), ReadStringNodeGen.create(this.context, false, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    @Override
    public void exitPointer(PackParser.PointerContext ctx) {
        this.appendNode(new SequenceNode(this.context, new FormatNode[]{new AdvanceSourcePositionNode(this.context, false), this.writeInteger(64, ByteOrder.nativeOrder(), new LiteralFormatNode(this.context, 0L))}));
    }

    @Override
    public void exitAt(PackParser.AtContext ctx) {
        int position;
        if (ctx.count() == null) {
            position = 1;
        } else {
            if (ctx.count() != null && ctx.count().INT() == null) {
                throw new UnsupportedOperationException();
            }
            position = Integer.parseInt(ctx.count().INT().getText());
        }
        this.appendNode(new SetOutputPositionNode(this.context, position));
    }

    @Override
    public void exitBack(PackParser.BackContext ctx) {
        if (ctx.count() == null || ctx.count().INT() != null) {
            this.appendNode(this.sharedTreeBuilder.applyCount(ctx.count(), new ReverseOutputPositionNode(this.context)));
        }
    }

    @Override
    public void exitNullByte(PackParser.NullByteContext ctx) {
        this.appendNode(this.sharedTreeBuilder.applyCount(ctx.count(), WriteByteNodeGen.create(this.context, new LiteralFormatNode(this.context, (byte)0))));
    }

    @Override
    public void enterSubSequence(PackParser.SubSequenceContext ctx) {
        this.pushSequence();
    }

    @Override
    public void exitSubSequence(PackParser.SubSequenceContext ctx) {
        this.appendNode(this.sharedTreeBuilder.finishSubSequence(this.sequenceStack, ctx));
    }

    @Override
    public void exitErrorDisallowedNative(PackParser.ErrorDisallowedNativeContext ctx) {
        throw new RaiseException(this.context.getCoreExceptions().argumentError("'" + ctx.NATIVE().getText() + "' allowed only after types sSiIlLqQ", this.currentNode));
    }

    public FormatNode getNode() {
        return this.sequenceStack.peek().get(0);
    }

    public FormatEncoding getEncoding() {
        return this.encoding;
    }

    private void pushSequence() {
        this.sequenceStack.push(new ArrayList());
    }

    private void appendNode(FormatNode node) {
        this.sequenceStack.peek().add(node);
    }

    private void appendIntegerNode(int size, ByteOrder byteOrder, PackParser.CountContext count) {
        this.appendNode(this.sharedTreeBuilder.applyCount(count, this.writeInteger(size, byteOrder)));
    }

    private void appendFloatNode(int size, ByteOrder byteOrder, PackParser.CountContext count) {
        FormatNode typeNode;
        ReadDoubleNode readNode = ReadDoubleNodeGen.create(this.context, new SourceNode());
        switch (size) {
            case 32: {
                typeNode = ToFloatNodeGen.create(this.context, readNode);
                break;
            }
            case 64: {
                typeNode = readNode;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.appendNode(this.sharedTreeBuilder.applyCount(count, this.writeInteger(size, byteOrder, ReinterpretAsLongNodeGen.create(this.context, typeNode))));
    }

    private FormatNode writeInteger(int size, ByteOrder byteOrder) {
        ToLongNode readNode = ToLongNodeGen.create(this.context, false, ReadValueNodeGen.create(this.context, new SourceNode()));
        return this.writeInteger(size, byteOrder, readNode);
    }

    private FormatNode writeInteger(int size, ByteOrder byteOrder, FormatNode readNode) {
        FormatNode convertNode;
        switch (size) {
            case 8: {
                return WriteByteNodeGen.create(this.context, readNode);
            }
            case 16: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    convertNode = Integer16LittleToBytesNodeGen.create(this.context, readNode);
                    break;
                }
                convertNode = Integer16BigToBytesNodeGen.create(this.context, readNode);
                break;
            }
            case 32: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    convertNode = Integer32LittleToBytesNodeGen.create(this.context, readNode);
                    break;
                }
                convertNode = Integer32BigToBytesNodeGen.create(this.context, readNode);
                break;
            }
            case 64: {
                if (byteOrder == ByteOrder.LITTLE_ENDIAN) {
                    convertNode = Integer64LittleToBytesNodeGen.create(this.context, readNode);
                    break;
                }
                convertNode = Integer64BigToBytesNodeGen.create(this.context, readNode);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return WriteBytesNodeGen.create(this.context, convertNode);
    }

    private void binaryString(byte padding, boolean padOnNull, boolean appendNull, PackParser.CountContext count) {
        int width;
        boolean pad;
        this.unify(FormatEncoding.ASCII_8BIT);
        if (count != null && count.INT() != null) {
            pad = true;
            width = Integer.parseInt(count.INT().getText());
        } else {
            pad = false;
            if (count != null && count.INT() == null) {
                padOnNull = false;
            }
            width = 1;
        }
        boolean takeAll = count != null && count.INT() == null;
        this.appendNode(WriteBinaryStringNodeGen.create(this.context, pad, padOnNull, width, padding, takeAll, appendNull, ReadStringNodeGen.create(this.context, true, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    private void bitString(ByteOrder byteOrder, PackParser.CountContext ctx) {
        SharedTreeBuilder.StarLength starLength = this.sharedTreeBuilder.parseCountContext(ctx);
        this.appendNode(WriteBitStringNodeGen.create(this.context, byteOrder, starLength.isStar(), starLength.getLength(), ReadStringNodeGen.create(this.context, true, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    private void hexString(ByteOrder byteOrder, PackParser.CountContext ctx) {
        int length = ctx == null ? 1 : (ctx.INT() == null ? -1 : Integer.parseInt(ctx.INT().getText()));
        this.appendNode(WriteHexStringNodeGen.create(this.context, byteOrder, length, ReadStringNodeGen.create(this.context, true, "to_str", false, this.context.getCoreLibrary().getNilObject(), new SourceNode())));
    }

    private void unify(FormatEncoding other) {
        this.encoding = this.encoding.unifyWith(other);
    }
}

