/*
 * Decompiled with CFR 0.152.
 */
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.Scanner;
import javax.imageio.ImageIO;
import org.libjpegturbo.turbojpeg.TJ;
import org.libjpegturbo.turbojpeg.TJCompressor;
import org.libjpegturbo.turbojpeg.TJDecompressor;
import org.libjpegturbo.turbojpeg.TJScalingFactor;
import org.libjpegturbo.turbojpeg.TJTransform;
import org.libjpegturbo.turbojpeg.TJTransformer;
import org.libjpegturbo.turbojpeg.YUVImage;

class TJBench {
    static int flags = 0;
    static int quiet = 0;
    static int pf = 1;
    static int yuvpad = 1;
    static int warmup = 1;
    static boolean compOnly;
    static boolean decompOnly;
    static boolean doTile;
    static boolean doYUV;
    static boolean write;
    static final String[] pixFormatStr;
    static final String[] subNameLong;
    static final String[] subName;
    static final String[] csName;
    static TJScalingFactor sf;
    static int xformOp;
    static int xformOpt;
    static double benchTime;

    TJBench() {
    }

    static final double getTime() {
        return (double)System.nanoTime() / 1.0E9;
    }

    static String formatName(int n, int n2) {
        if (n2 == 1) {
            return subNameLong[n];
        }
        if (n2 == 4) {
            return csName[n2] + " " + subNameLong[n];
        }
        return csName[n2];
    }

    static String sigFig(double d, int n) {
        int n2 = n - (int)Math.ceil(Math.log10(Math.abs(d)));
        String string = n2 < 1 ? new String("%.0f") : new String("%." + n2 + "f");
        return String.format(string, d);
    }

    static byte[] loadImage(String string, int[] nArray, int[] nArray2, int n) throws Exception {
        BufferedImage bufferedImage = ImageIO.read(new File(string));
        if (bufferedImage == null) {
            throw new Exception("Could not read " + string);
        }
        nArray[0] = bufferedImage.getWidth();
        nArray2[0] = bufferedImage.getHeight();
        int[] nArray3 = bufferedImage.getRGB(0, 0, nArray[0], nArray2[0], null, 0, nArray[0]);
        int n2 = TJ.getPixelSize(n);
        int n3 = TJ.getRedOffset(n);
        int n4 = TJ.getGreenOffset(n);
        int n5 = TJ.getBlueOffset(n);
        byte[] byArray = new byte[nArray[0] * nArray2[0] * n2];
        int n6 = nArray[0] * nArray2[0];
        int n7 = 0;
        int n8 = 0;
        while (n6-- > 0) {
            byArray[n7 + n3] = (byte)(nArray3[n8] >> 16 & 0xFF);
            byArray[n7 + n4] = (byte)(nArray3[n8] >> 8 & 0xFF);
            byArray[n7 + n5] = (byte)(nArray3[n8] & 0xFF);
            n7 += n2;
            ++n8;
        }
        return byArray;
    }

    static void saveImage(String string, byte[] byArray, int n, int n2, int n3) throws Exception {
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        int n4 = n * n2;
        int n5 = 0;
        int n6 = TJ.getPixelSize(n3);
        int n7 = TJ.getRedOffset(n3);
        int n8 = TJ.getGreenOffset(n3);
        int n9 = TJ.getBlueOffset(n3);
        for (int i = 0; i < n2; ++i) {
            int n10 = 0;
            while (n10 < n) {
                int n11 = (byArray[n5 + n7] & 0xFF) << 16 | (byArray[n5 + n8] & 0xFF) << 8 | byArray[n5 + n9] & 0xFF;
                bufferedImage.setRGB(n10, i, n11);
                ++n10;
                n5 += n6;
            }
        }
        ImageIO.write((RenderedImage)bufferedImage, "bmp", new File(string));
    }

    static void decomp(byte[] byArray, byte[][] byArray2, int[] nArray, byte[] byArray3, int n, int n2, int n3, int n4, String string, int n5, int n6) throws Exception {
        int n7;
        int n8;
        int n9;
        int n10;
        double d;
        int n11;
        String string2 = new String("");
        int n12 = TJ.getPixelSize(pf);
        int n13 = 0;
        int n14 = sf.getScaled(n);
        int n15 = sf.getScaled(n2);
        int n16 = n14 * n12;
        YUVImage yUVImage = null;
        if (n4 > 0) {
            string2 = new String("_Q" + n4);
        }
        TJDecompressor tJDecompressor = new TJDecompressor();
        if (byArray3 == null) {
            byArray3 = new byte[n16 * n15];
        }
        Arrays.fill(byArray3, (byte)127);
        if (doYUV) {
            n11 = doTile ? n5 : n14;
            int n17 = doTile ? n6 : n15;
            yUVImage = new YUVImage(n11, yuvpad, n17, n3);
            Arrays.fill(yUVImage.getBuf(), (byte)127);
        }
        n13 -= warmup;
        double d2 = 0.0;
        double d3 = 0.0;
        do {
            n11 = 0;
            d = TJBench.getTime();
            for (n10 = 0; n10 < n2; n10 += n6) {
                n9 = 0;
                while (n9 < n) {
                    n8 = doTile ? Math.min(n5, n - n9) : n14;
                    n7 = doTile ? Math.min(n6, n2 - n10) : n15;
                    tJDecompressor.setSourceImage(byArray2[n11], nArray[n11]);
                    if (doYUV) {
                        yUVImage.setBuf(yUVImage.getBuf(), n8, yuvpad, n7, n3);
                        tJDecompressor.decompressToYUV(yUVImage, flags);
                        double d4 = TJBench.getTime();
                        tJDecompressor.setSourceImage(yUVImage);
                        tJDecompressor.decompress(byArray3, n9, n10, n8, n16, n7, pf, flags);
                        if (n13 >= 0) {
                            d2 += TJBench.getTime() - d4;
                        }
                    } else {
                        tJDecompressor.decompress(byArray3, n9, n10, n8, n16, n7, pf, flags);
                    }
                    n9 += n5;
                    ++n11;
                }
            }
        } while (++n13 < 1 || !((d3 += TJBench.getTime() - d) >= benchTime));
        if (doYUV) {
            d3 -= d2;
        }
        tJDecompressor = null;
        for (int i = 0; i < byArray2.length; ++i) {
            byArray2[i] = null;
        }
        byArray2 = null;
        nArray = null;
        System.gc();
        if (quiet != 0) {
            System.out.format("%-6s%s", TJBench.sigFig((double)(n * n2) / 1000000.0 * (double)n13 / d3, 4), quiet == 2 ? "\n" : "  ");
            if (doYUV) {
                System.out.format("%s\n", TJBench.sigFig((double)(n * n2) / 1000000.0 * (double)n13 / d2, 4));
            } else if (quiet != 2) {
                System.out.print("\n");
            }
        } else {
            System.out.format("%s --> Frame rate:         %f fps\n", doYUV ? "Decomp to YUV" : "Decompress   ", (double)n13 / d3);
            System.out.format("                  Throughput:         %f Megapixels/sec\n", (double)(n * n2) / 1000000.0 * (double)n13 / d3);
            if (doYUV) {
                System.out.format("YUV Decode    --> Frame rate:         %f fps\n", (double)n13 / d2);
                System.out.format("                  Throughput:         %f Megapixels/sec\n", (double)(n * n2) / 1000000.0 * (double)n13 / d2);
            }
        }
        if (!write) {
            return;
        }
        String string3 = sf.getNum() != 1 || sf.getDenom() != 1 ? new String(sf.getNum() + "_" + sf.getDenom()) : (n5 != n || n6 != n2 ? new String(n5 + "x" + n6) : new String("full"));
        String string4 = decompOnly ? new String(string + "_" + string3 + ".bmp") : new String(string + "_" + subName[n3] + string2 + "_" + string3 + ".bmp");
        TJBench.saveImage(string4, byArray3, n14, n15, pf);
        n11 = string4.lastIndexOf(46);
        string4 = new String(string4.substring(0, n11) + "-err.bmp");
        if (byArray != null && sf.getNum() == 1 && sf.getDenom() == 1) {
            if (quiet == 0) {
                System.out.println("Compression error written to " + string4 + ".");
            }
            if (n3 == 3) {
                int n18 = 0;
                int n19 = 0;
                while (n18 < n2) {
                    n10 = 0;
                    n9 = n19;
                    while (n10 < n) {
                        int n20;
                        n8 = n9 + TJ.getRedOffset(pf);
                        int n21 = (int)((double)(byArray[n8] & 0xFF) * 0.299 + (double)(byArray[n7 = n9 + TJ.getGreenOffset(pf)] & 0xFF) * 0.587 + (double)(byArray[n20 = n9 + TJ.getBlueOffset(pf)] & 0xFF) * 0.114 + 0.5);
                        if (n21 > 255) {
                            n21 = 255;
                        }
                        if (n21 < 0) {
                            n21 = 0;
                        }
                        byArray3[n8] = (byte)Math.abs((byArray3[n8] & 0xFF) - n21);
                        byArray3[n7] = (byte)Math.abs((byArray3[n7] & 0xFF) - n21);
                        byArray3[n20] = (byte)Math.abs((byArray3[n20] & 0xFF) - n21);
                        ++n10;
                        n9 += n12;
                    }
                    ++n18;
                    n19 += n16;
                }
            } else {
                for (int i = 0; i < n2; ++i) {
                    for (int j = 0; j < n * n12; ++j) {
                        byArray3[n16 * i + j] = (byte)Math.abs((byArray3[n16 * i + j] & 0xFF) - (byArray[n16 * i + j] & 0xFF));
                    }
                }
            }
            TJBench.saveImage(string4, byArray3, n, n2, pf);
        }
    }

    static void fullTest(byte[] byArray, int n, int n2, int n3, int n4, String string) throws Exception {
        int n5;
        int n6 = 0;
        int n7 = TJ.getPixelSize(pf);
        int n8 = 1;
        int n9 = 1;
        int n10 = n * n7;
        String string2 = pixFormatStr[pf];
        YUVImage yUVImage = null;
        byte[] byArray2 = new byte[n10 * n2];
        if (quiet == 0) {
            System.out.format(">>>>>  %s (%s) <--> JPEG %s Q%d  <<<<<\n", string2, (flags & 2) != 0 ? "Bottom-up" : "Top-down", subNameLong[n3], n4);
        }
        TJCompressor tJCompressor = new TJCompressor();
        int n11 = doTile ? 8 : n;
        int n12 = n5 = doTile ? 8 : n2;
        while (true) {
            double d;
            if (n11 > n) {
                n11 = n;
            }
            if (n5 > n2) {
                n5 = n2;
            }
            n8 = (n + n11 - 1) / n11;
            n9 = (n2 + n5 - 1) / n5;
            byte[][] byArray3 = new byte[n8 * n9][TJ.bufSize(n11, n5, n3)];
            int[] nArray = new int[n8 * n9];
            if (quiet == 1) {
                System.out.format("%-4s (%s)  %-5s    %-3d   ", string2, (flags & 2) != 0 ? "BU" : "TD", subNameLong[n3], n4);
            }
            for (int i = 0; i < n2; ++i) {
                System.arraycopy(byArray, n * n7 * i, byArray2, n10 * i, n * n7);
            }
            tJCompressor.setJPEGQuality(n4);
            tJCompressor.setSubsamp(n3);
            if (doYUV) {
                yUVImage = new YUVImage(n11, yuvpad, n5, n3);
                Arrays.fill(yUVImage.getBuf(), (byte)127);
            }
            int n13 = -warmup;
            double d2 = 0.0;
            double d3 = 0.0;
            do {
                int n14 = 0;
                n6 = 0;
                d = TJBench.getTime();
                for (int i = 0; i < n2; i += n5) {
                    int n15 = 0;
                    while (n15 < n) {
                        int n16 = Math.min(n11, n - n15);
                        int n17 = Math.min(n5, n2 - i);
                        tJCompressor.setSourceImage(byArray, n15, i, n16, n10, n17, pf);
                        if (doYUV) {
                            double d4 = TJBench.getTime();
                            yUVImage.setBuf(yUVImage.getBuf(), n16, yuvpad, n17, n3);
                            tJCompressor.encodeYUV(yUVImage, flags);
                            if (n13 >= 0) {
                                d2 += TJBench.getTime() - d4;
                            }
                            tJCompressor.setSourceImage(yUVImage);
                        }
                        tJCompressor.compress(byArray3[n14], flags);
                        nArray[n14] = tJCompressor.getCompressedSize();
                        n6 += nArray[n14];
                        n15 += n11;
                        ++n14;
                    }
                }
            } while (++n13 < 1 || !((d3 += TJBench.getTime() - d) >= benchTime));
            if (doYUV) {
                d3 -= d2;
            }
            if (quiet == 1) {
                System.out.format("%-5d  %-5d   ", n11, n5);
            }
            if (quiet != 0) {
                if (doYUV) {
                    System.out.format("%-6s%s", TJBench.sigFig((double)(n * n2) / 1000000.0 * (double)n13 / d2, 4), quiet == 2 ? "\n" : "  ");
                }
                System.out.format("%-6s%s", TJBench.sigFig((double)(n * n2) / 1000000.0 * (double)n13 / d3, 4), quiet == 2 ? "\n" : "  ");
                System.out.format("%-6s%s", TJBench.sigFig((double)(n * n2 * n7) / (double)n6, 4), quiet == 2 ? "\n" : "  ");
            } else {
                System.out.format("\n%s size: %d x %d\n", doTile ? "Tile" : "Image", n11, n5);
                if (doYUV) {
                    System.out.format("Encode YUV    --> Frame rate:         %f fps\n", (double)n13 / d2);
                    System.out.format("                  Output image size:  %d bytes\n", yUVImage.getSize());
                    System.out.format("                  Compression ratio:  %f:1\n", (double)(n * n2 * n7) / (double)yUVImage.getSize());
                    System.out.format("                  Throughput:         %f Megapixels/sec\n", (double)(n * n2) / 1000000.0 * (double)n13 / d2);
                    System.out.format("                  Output bit stream:  %f Megabits/sec\n", (double)yUVImage.getSize() * 8.0 / 1000000.0 * (double)n13 / d2);
                }
                System.out.format("%s --> Frame rate:         %f fps\n", doYUV ? "Comp from YUV" : "Compress     ", (double)n13 / d3);
                System.out.format("                  Output image size:  %d bytes\n", n6);
                System.out.format("                  Compression ratio:  %f:1\n", (double)(n * n2 * n7) / (double)n6);
                System.out.format("                  Throughput:         %f Megapixels/sec\n", (double)(n * n2) / 1000000.0 * (double)n13 / d3);
                System.out.format("                  Output bit stream:  %f Megabits/sec\n", (double)n6 * 8.0 / 1000000.0 * (double)n13 / d3);
            }
            if (n11 == n && n5 == n2 && write) {
                String string3 = string + "_" + subName[n3] + "_" + "Q" + n4 + ".jpg";
                FileOutputStream fileOutputStream = new FileOutputStream(string3);
                fileOutputStream.write(byArray3[0], 0, nArray[0]);
                fileOutputStream.close();
                if (quiet == 0) {
                    System.out.println("Reference image written to " + string3);
                }
            }
            if (!compOnly) {
                TJBench.decomp(byArray, byArray3, nArray, byArray2, n, n2, n3, n4, string, n11, n5);
            }
            if (n11 == n && n5 == n2) break;
            n11 *= 2;
            n5 *= 2;
        }
    }

    static void decompTest(String string) throws Exception {
        int n;
        byte[][] byArray = null;
        int[] nArray = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = -1;
        int n6 = 1;
        int n7 = 1;
        int n8 = TJ.getPixelSize(pf);
        FileInputStream fileInputStream = new FileInputStream(string);
        int n9 = (int)fileInputStream.getChannel().size();
        byte[] byArray2 = new byte[n9];
        fileInputStream.read(byArray2, 0, n9);
        fileInputStream.close();
        int n10 = string.lastIndexOf(46);
        if (n10 >= 0) {
            string = new String(string.substring(0, n10));
        }
        TJTransformer tJTransformer = new TJTransformer();
        tJTransformer.setSourceImage(byArray2, n9);
        n2 = tJTransformer.getWidth();
        n3 = tJTransformer.getHeight();
        n4 = tJTransformer.getSubsamp();
        n5 = tJTransformer.getColorspace();
        if (quiet == 1) {
            System.out.println("All performance values in Mpixels/sec\n");
            System.out.format("Bitmap     JPEG   JPEG     %s  %s   Xform   Comp    Decomp  ", doTile ? "Tile " : "Image", doTile ? "Tile " : "Image");
            if (doYUV) {
                System.out.print("Decode");
            }
            System.out.print("\n");
            System.out.print("Format     CS     Subsamp  Width  Height  Perf    Ratio   Perf    ");
            if (doYUV) {
                System.out.print("Perf");
            }
            System.out.println("\n");
        } else if (quiet == 0) {
            System.out.format(">>>>>  JPEG %s --> %s (%s)  <<<<<\n", TJBench.formatName(n4, n5), pixFormatStr[pf], (flags & 2) != 0 ? "Bottom-up" : "Top-down");
        }
        int n11 = doTile ? 16 : n2;
        int n12 = n = doTile ? 16 : n3;
        while (true) {
            if (n11 > n2) {
                n11 = n2;
            }
            if (n > n3) {
                n = n3;
            }
            n6 = (n2 + n11 - 1) / n11;
            n7 = (n3 + n - 1) / n;
            int n13 = n2;
            int n14 = n3;
            int n15 = n11;
            int n16 = n;
            if (quiet == 0) {
                System.out.format("\n%s size: %d x %d", doTile ? "Tile" : "Image", n15, n16);
                if (sf.getNum() != 1 || sf.getDenom() != 1) {
                    System.out.format(" --> %d x %d", sf.getScaled(n13), sf.getScaled(n14));
                }
                System.out.println("");
            } else if (quiet == 1) {
                System.out.format("%-4s (%s)  %-5s  %-5s    ", pixFormatStr[pf], (flags & 2) != 0 ? "BU" : "TD", csName[n5], subNameLong[n4]);
                System.out.format("%-5d  %-5d   ", n11, n);
            }
            int n17 = n4;
            if (doTile || xformOp != 0 || xformOpt != 0) {
                double d;
                if (xformOp == 3 || xformOp == 4 || xformOp == 5 || xformOp == 7) {
                    n13 = n3;
                    n14 = n2;
                    n15 = n;
                    n16 = n11;
                }
                if ((xformOpt & 8) != 0) {
                    n17 = 3;
                }
                if (xformOp == 1 || xformOp == 6) {
                    n13 -= n13 % TJ.getMCUWidth(n17);
                }
                if (xformOp == 2 || xformOp == 6) {
                    n14 -= n14 % TJ.getMCUHeight(n17);
                }
                if (xformOp == 4 || xformOp == 5) {
                    n13 -= n13 % TJ.getMCUHeight(n17);
                }
                if (xformOp == 4 || xformOp == 7) {
                    n14 -= n14 % TJ.getMCUWidth(n17);
                }
                int n18 = (n13 + n15 - 1) / n15;
                int n19 = (n14 + n16 - 1) / n16;
                if (xformOp == 3 || xformOp == 4 || xformOp == 5 || xformOp == 7) {
                    if (n17 == 1) {
                        n17 = 4;
                    } else if (n17 == 4) {
                        n17 = 1;
                    }
                }
                TJTransform[] tJTransformArray = new TJTransform[n18 * n19];
                byArray = new byte[n18 * n19][TJ.bufSize(n15, n16, n4)];
                int n20 = 0;
                for (int i = 0; i < n14; i += n16) {
                    int n21 = 0;
                    while (n21 < n13) {
                        tJTransformArray[n20] = new TJTransform();
                        tJTransformArray[n20].width = Math.min(n15, n13 - n21);
                        tJTransformArray[n20].height = Math.min(n16, n14 - i);
                        tJTransformArray[n20].x = n21;
                        tJTransformArray[n20].y = i;
                        tJTransformArray[n20].op = xformOp;
                        tJTransformArray[n20].options = xformOpt | 2;
                        if ((tJTransformArray[n20].options & 0x10) != 0 && byArray[n20] != null) {
                            byArray[n20] = null;
                        }
                        n21 += n15;
                        ++n20;
                    }
                }
                int n22 = -warmup;
                double d2 = 0.0;
                do {
                    d = TJBench.getTime();
                    tJTransformer.transform(byArray, tJTransformArray, flags);
                    nArray = tJTransformer.getTransformedSizes();
                } while (++n22 < 1 || !((d2 += TJBench.getTime() - d) >= benchTime));
                tJTransformArray = null;
                int n23 = 0;
                for (n20 = 0; n20 < n18 * n19; ++n20) {
                    n23 += nArray[n20];
                }
                if (quiet != 0) {
                    System.out.format("%-6s%s%-6s%s", TJBench.sigFig((double)(n2 * n3) / 1000000.0 / d2, 4), quiet == 2 ? "\n" : "  ", TJBench.sigFig((double)(n2 * n3 * n8) / (double)n23, 4), quiet == 2 ? "\n" : "  ");
                } else if (quiet == 0) {
                    System.out.format("Transform     --> Frame rate:         %f fps\n", 1.0 / d2);
                    System.out.format("                  Output image size:  %d bytes\n", n23);
                    System.out.format("                  Compression ratio:  %f:1\n", (double)(n2 * n3 * n8) / (double)n23);
                    System.out.format("                  Throughput:         %f Megapixels/sec\n", (double)(n2 * n3) / 1000000.0 / d2);
                    System.out.format("                  Output bit stream:  %f Megabits/sec\n", (double)n23 * 8.0 / 1000000.0 / d2);
                }
            } else {
                if (quiet == 1) {
                    System.out.print("N/A     N/A     ");
                }
                byArray = new byte[1][TJ.bufSize(n15, n16, n4)];
                nArray = new int[]{n9};
                System.arraycopy(byArray2, 0, byArray[0], 0, n9);
            }
            if (n2 == n11) {
                n15 = n13;
            }
            if (n3 == n) {
                n16 = n14;
            }
            if ((xformOpt & 0x10) == 0) {
                TJBench.decomp(null, byArray, nArray, null, n13, n14, n17, 0, string, n15, n16);
            } else if (quiet == 1) {
                System.out.println("N/A");
            }
            byArray = null;
            nArray = null;
            if (n11 == n2 && n == n3) break;
            n11 *= 2;
            n *= 2;
        }
    }

    static void usage() throws Exception {
        TJScalingFactor[] tJScalingFactorArray = TJ.getScalingFactors();
        int n = tJScalingFactorArray.length;
        String string = new TJBench().getClass().getName();
        System.out.println("\nUSAGE: java " + string);
        System.out.println("       <Inputfile (BMP)> <Quality> [options]\n");
        System.out.println("       java " + string);
        System.out.println("       <Inputfile (JPG)> [options]\n");
        System.out.println("Options:\n");
        System.out.println("-alloc = Dynamically allocate JPEG image buffers");
        System.out.println("-bottomup = Test bottom-up compression/decompression");
        System.out.println("-tile = Test performance of the codec when the image is encoded as separate");
        System.out.println("     tiles of varying sizes.");
        System.out.println("-rgb, -bgr, -rgbx, -bgrx, -xbgr, -xrgb =");
        System.out.println("     Test the specified color conversion path in the codec (default = BGR)");
        System.out.println("-fastupsample = Use the fastest chrominance upsampling algorithm available in");
        System.out.println("     the underlying codec");
        System.out.println("-fastdct = Use the fastest DCT/IDCT algorithms available in the underlying");
        System.out.println("     codec");
        System.out.println("-accuratedct = Use the most accurate DCT/IDCT algorithms available in the");
        System.out.println("     underlying codec");
        System.out.println("-subsamp <s> = When testing JPEG compression, this option specifies the level");
        System.out.println("     of chrominance subsampling to use (<s> = 444, 422, 440, 420, 411, or");
        System.out.println("     GRAY).  The default is to test Grayscale, 4:2:0, 4:2:2, and 4:4:4 in");
        System.out.println("     sequence.");
        System.out.println("-quiet = Output results in tabular rather than verbose format");
        System.out.println("-yuv = Test YUV encoding/decoding functions");
        System.out.println("-yuvpad <p> = If testing YUV encoding/decoding, this specifies the number of");
        System.out.println("     bytes to which each row of each plane in the intermediate YUV image is");
        System.out.println("     padded (default = 1)");
        System.out.println("-scale M/N = Scale down the width/height of the decompressed JPEG image by a");
        System.out.print("     factor of M/N (M/N = ");
        for (int i = 0; i < n; ++i) {
            System.out.format("%d/%d", tJScalingFactorArray[i].getNum(), tJScalingFactorArray[i].getDenom());
            if (n == 2 && i != n - 1) {
                System.out.print(" or ");
            } else if (n > 2) {
                if (i != n - 1) {
                    System.out.print(", ");
                }
                if (i == n - 2) {
                    System.out.print("or ");
                }
            }
            if (i % 8 != 0 || i == 0) continue;
            System.out.print("\n     ");
        }
        System.out.println(")");
        System.out.println("-hflip, -vflip, -transpose, -transverse, -rot90, -rot180, -rot270 =");
        System.out.println("     Perform the corresponding lossless transform prior to");
        System.out.println("     decompression (these options are mutually exclusive)");
        System.out.println("-grayscale = Perform lossless grayscale conversion prior to decompression");
        System.out.println("     test (can be combined with the other transforms above)");
        System.out.println("-benchtime <t> = Run each benchmark for at least <t> seconds (default = 5.0)");
        System.out.println("-warmup <w> = Execute each benchmark <w> times to prime the cache before");
        System.out.println("     taking performance measurements (default = 1)");
        System.out.println("-componly = Stop after running compression tests.  Do not test decompression.");
        System.out.println("-nowrite = Do not write reference or output images (improves consistency");
        System.out.println("     of performance measurements.)\n");
        System.out.println("NOTE:  If the quality is specified as a range (e.g. 90-100), a separate");
        System.out.println("test will be performed for all quality values in the range.\n");
        System.exit(1);
    }

    public static void main(String[] stringArray) {
        byte[] byArray = null;
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        int n5 = 1;
        int n6 = 0;
        int n7 = -1;
        try {
            int n8;
            String string;
            if (stringArray.length < n5) {
                TJBench.usage();
            }
            if ((string = stringArray[0].toLowerCase()).endsWith(".jpg") || string.endsWith(".jpeg")) {
                decompOnly = true;
            }
            System.out.println("");
            if (!decompOnly) {
                n5 = 2;
                if (stringArray.length < n5) {
                    TJBench.usage();
                }
                try {
                    n3 = Integer.parseInt(stringArray[1]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (n3 < 1 || n3 > 100) {
                    throw new Exception("Quality must be between 1 and 100.");
                }
                n8 = stringArray[1].indexOf(45);
                if (n8 > 0 && stringArray[1].length() > n8 + 1) {
                    try {
                        n4 = Integer.parseInt(stringArray[1].substring(n8 + 1));
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (n4 < 1 || n4 > 100) {
                    n4 = n3;
                }
            }
            if (stringArray.length > n5) {
                for (n8 = n5; n8 < stringArray.length; ++n8) {
                    if (stringArray[n8].equalsIgnoreCase("-tile")) {
                        doTile = true;
                        xformOpt |= 4;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-fastupsample")) {
                        System.out.println("Using fast upsampling code\n");
                        flags |= 0x100;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-fastdct")) {
                        System.out.println("Using fastest DCT/IDCT algorithm\n");
                        flags |= 0x800;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-accuratedct")) {
                        System.out.println("Using most accurate DCT/IDCT algorithm\n");
                        flags |= 0x1000;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-rgb")) {
                        pf = 0;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-rgbx")) {
                        pf = 2;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-bgr")) {
                        pf = 1;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-bgrx")) {
                        pf = 3;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-xbgr")) {
                        pf = 4;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-xrgb")) {
                        pf = 5;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-bottomup")) {
                        flags |= 2;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-quiet")) {
                        quiet = 1;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-qq")) {
                        quiet = 2;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-scale") && n8 < stringArray.length - 1) {
                        int n9 = 0;
                        int n10 = 0;
                        boolean bl = false;
                        boolean bl2 = true;
                        Scanner scanner = new Scanner(stringArray[++n8]).useDelimiter("/");
                        try {
                            n9 = scanner.nextInt();
                            n10 = scanner.nextInt();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (n10 <= 0) {
                            n10 = 1;
                        }
                        if (n9 > 0) {
                            TJScalingFactor[] tJScalingFactorArray = TJ.getScalingFactors();
                            for (int i = 0; i < tJScalingFactorArray.length; ++i) {
                                if ((double)n9 / (double)n10 != (double)tJScalingFactorArray[i].getNum() / (double)tJScalingFactorArray[i].getDenom()) continue;
                                sf = tJScalingFactorArray[i];
                                bl = true;
                                break;
                            }
                            if (!bl) {
                                TJBench.usage();
                            }
                        } else {
                            TJBench.usage();
                        }
                    }
                    if (stringArray[n8].equalsIgnoreCase("-hflip")) {
                        xformOp = 1;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-vflip")) {
                        xformOp = 2;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-transpose")) {
                        xformOp = 3;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-transverse")) {
                        xformOp = 4;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-rot90")) {
                        xformOp = 5;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-rot180")) {
                        xformOp = 6;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-rot270")) {
                        xformOp = 7;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-grayscale")) {
                        xformOpt |= 8;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-nooutput")) {
                        xformOpt |= 0x10;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-benchtime") && n8 < stringArray.length - 1) {
                        double d = -1.0;
                        try {
                            d = Double.parseDouble(stringArray[++n8]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (d > 0.0) {
                            benchTime = d;
                        } else {
                            TJBench.usage();
                        }
                    }
                    if (stringArray[n8].equalsIgnoreCase("-yuv")) {
                        System.out.println("Testing YUV planar encoding/decoding\n");
                        doYUV = true;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-yuvpad") && n8 < stringArray.length - 1) {
                        int n11 = 0;
                        try {
                            n11 = Integer.parseInt(stringArray[++n8]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n11 >= 1) {
                            yuvpad = n11;
                        }
                    }
                    if (stringArray[n8].equalsIgnoreCase("-subsamp") && n8 < stringArray.length - 1) {
                        if (stringArray[++n8].toUpperCase().startsWith("G")) {
                            n7 = 3;
                        } else if (stringArray[n8].equals("444")) {
                            n7 = 0;
                        } else if (stringArray[n8].equals("422")) {
                            n7 = 1;
                        } else if (stringArray[n8].equals("440")) {
                            n7 = 4;
                        } else if (stringArray[n8].equals("420")) {
                            n7 = 2;
                        } else if (stringArray[n8].equals("411")) {
                            n7 = 5;
                        }
                    }
                    if (stringArray[n8].equalsIgnoreCase("-componly")) {
                        compOnly = true;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-nowrite")) {
                        write = false;
                    }
                    if (stringArray[n8].equalsIgnoreCase("-warmup") && n8 < stringArray.length - 1) {
                        int n12 = -1;
                        try {
                            n12 = Integer.parseInt(stringArray[++n8]);
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        if (n12 >= 0) {
                            warmup = n12;
                            System.out.format("Warmup runs = %d\n\n", warmup);
                        }
                    }
                    if (!stringArray[n8].equalsIgnoreCase("-?")) continue;
                    TJBench.usage();
                }
            }
            if (sf == null) {
                sf = new TJScalingFactor(1, 1);
            }
            if ((sf.getNum() != 1 || sf.getDenom() != 1) && doTile) {
                System.out.println("Disabling tiled compression/decompression tests, because those tests do not");
                System.out.println("work when scaled decompression is enabled.");
                doTile = false;
            }
            if (!decompOnly) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                byArray = TJBench.loadImage(stringArray[0], nArray, nArray2, pf);
                n = nArray[0];
                n2 = nArray2[0];
                int n13 = -1;
                n13 = stringArray[0].lastIndexOf(46);
                if (n13 >= 0) {
                    stringArray[0] = stringArray[0].substring(0, n13);
                }
            }
            if (quiet == 1 && !decompOnly) {
                System.out.println("All performance values in Mpixels/sec\n");
                System.out.format("Bitmap     JPEG     JPEG  %s  %s   ", doTile ? "Tile " : "Image", doTile ? "Tile " : "Image");
                if (doYUV) {
                    System.out.print("Encode  ");
                }
                System.out.print("Comp    Comp    Decomp  ");
                if (doYUV) {
                    System.out.print("Decode");
                }
                System.out.print("\n");
                System.out.print("Format     Subsamp  Qual  Width  Height  ");
                if (doYUV) {
                    System.out.print("Perf    ");
                }
                System.out.print("Perf    Ratio   Perf    ");
                if (doYUV) {
                    System.out.print("Perf");
                }
                System.out.println("\n");
            }
            if (decompOnly) {
                TJBench.decompTest(stringArray[0]);
                System.out.println("");
                System.exit(n6);
            }
            System.gc();
            if (n7 >= 0 && n7 < 6) {
                for (int i = n4; i >= n3; --i) {
                    TJBench.fullTest(byArray, n, n2, n7, i, stringArray[0]);
                }
                System.out.println("");
            } else {
                int n14;
                for (n14 = n4; n14 >= n3; --n14) {
                    TJBench.fullTest(byArray, n, n2, 3, n14, stringArray[0]);
                }
                System.out.println("");
                System.gc();
                for (n14 = n4; n14 >= n3; --n14) {
                    TJBench.fullTest(byArray, n, n2, 2, n14, stringArray[0]);
                }
                System.out.println("");
                System.gc();
                for (n14 = n4; n14 >= n3; --n14) {
                    TJBench.fullTest(byArray, n, n2, 1, n14, stringArray[0]);
                }
                System.out.println("");
                System.gc();
                for (n14 = n4; n14 >= n3; --n14) {
                    TJBench.fullTest(byArray, n, n2, 0, n14, stringArray[0]);
                }
                System.out.println("");
            }
        }
        catch (Exception exception) {
            System.out.println("ERROR: " + exception.getMessage());
            exception.printStackTrace();
            n6 = -1;
        }
        System.exit(n6);
    }

    static {
        pixFormatStr = new String[]{"RGB", "BGR", "RGBX", "BGRX", "XBGR", "XRGB", "GRAY"};
        subNameLong = new String[]{"4:4:4", "4:2:2", "4:2:0", "GRAY", "4:4:0", "4:1:1"};
        subName = new String[]{"444", "422", "420", "GRAY", "440", "411"};
        csName = new String[]{"RGB", "YCbCr", "GRAY", "CMYK", "YCCK"};
        xformOp = 0;
        xformOpt = 0;
        benchTime = 5.0;
    }
}

