/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyCodeSource;
import groovy.lang.Script;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.codehaus.groovy.ast.ClassCodeExpressionTransformer;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.classgen.GeneratorContext;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilePhase;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.hash.MessageDigests;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.script.ClassPermission;
import org.elasticsearch.script.CompiledScript;
import org.elasticsearch.script.ExecutableScript;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.script.ScoreAccessor;
import org.elasticsearch.script.ScriptEngineService;
import org.elasticsearch.script.ScriptException;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.lookup.LeafSearchLookup;
import org.elasticsearch.search.lookup.SearchLookup;

public class GroovyScriptEngineService
extends AbstractComponent
implements ScriptEngineService {
    public static final String NAME = "groovy";
    public static final String GROOVY_INDY_SETTING_NAME = "indy";
    private final ClassLoader loader;

    @Inject
    public GroovyScriptEngineService(Settings settings) {
        super(settings);
        final SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        this.loader = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                final AccessControlContext context = AccessController.getContext();
                return new ClassLoader(this.getClass().getClassLoader()){

                    @Override
                    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
                        if (sm != null) {
                            try {
                                context.checkPermission((Permission)new ClassPermission(name));
                            }
                            catch (SecurityException e) {
                                throw new ClassNotFoundException(name, e);
                            }
                        }
                        return super.loadClass(name, resolve);
                    }
                };
            }
        });
    }

    public void close() throws IOException {
    }

    public String[] types() {
        return new String[]{NAME};
    }

    public String[] extensions() {
        return new String[]{NAME};
    }

    public boolean sandboxed() {
        return false;
    }

    public Object compile(final String scriptSource, Map<String, String> params) {
        final String className = MessageDigests.toHexString((byte[])MessageDigests.sha1().digest(scriptSource.getBytes(StandardCharsets.UTF_8)));
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        return AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Class<?> run() {
                try {
                    GroovyCodeSource codeSource = new GroovyCodeSource(scriptSource, className, "/untrusted");
                    codeSource.setCachable(false);
                    CompilerConfiguration configuration = new CompilerConfiguration().addCompilationCustomizers(new CompilationCustomizer[]{new ImportCustomizer().addStarImports(new String[]{"org.joda.time"}).addStaticStars(new String[]{"java.lang.Math"})}).addCompilationCustomizers(new CompilationCustomizer[]{new GroovyBigDecimalTransformer(CompilePhase.CONVERSION)});
                    configuration.getOptimizationOptions().put(GroovyScriptEngineService.GROOVY_INDY_SETTING_NAME, true);
                    GroovyClassLoader groovyClassLoader = new GroovyClassLoader(GroovyScriptEngineService.this.loader, configuration);
                    return groovyClassLoader.parseClass(codeSource);
                }
                catch (Throwable e) {
                    if (GroovyScriptEngineService.this.logger.isTraceEnabled()) {
                        GroovyScriptEngineService.this.logger.trace("Exception compiling Groovy script:", e, new Object[0]);
                    }
                    throw new ScriptException("Error compiling script " + className, e);
                }
            }
        });
    }

    private Script createScript(Object compiledScript, Map<String, Object> vars) throws InstantiationException, IllegalAccessException {
        Class scriptClass = (Class)compiledScript;
        Script scriptObject = (Script)scriptClass.newInstance();
        Binding binding = new Binding();
        binding.getVariables().putAll(vars);
        scriptObject.setBinding(binding);
        return scriptObject;
    }

    public ExecutableScript executable(CompiledScript compiledScript, Map<String, Object> vars) {
        try {
            HashMap<String, Object> allVars = new HashMap<String, Object>();
            if (vars != null) {
                allVars.putAll(vars);
            }
            return new GroovyScript(compiledScript, this.createScript(compiledScript.compiled(), allVars), this.logger);
        }
        catch (Exception e) {
            throw new ScriptException("failed to build executable " + compiledScript, (Throwable)e);
        }
    }

    public SearchScript search(final CompiledScript compiledScript, final SearchLookup lookup, final @Nullable Map<String, Object> vars) {
        return new SearchScript(){

            public LeafSearchScript getLeafSearchScript(LeafReaderContext context) throws IOException {
                Script scriptObject;
                LeafSearchLookup leafLookup = lookup.getLeafSearchLookup(context);
                HashMap allVars = new HashMap();
                allVars.putAll(leafLookup.asMap());
                if (vars != null) {
                    allVars.putAll(vars);
                }
                try {
                    scriptObject = GroovyScriptEngineService.this.createScript(compiledScript.compiled(), allVars);
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new ScriptException("failed to build search " + compiledScript, (Throwable)e);
                }
                return new GroovyScript(compiledScript, scriptObject, leafLookup, GroovyScriptEngineService.this.logger);
            }

            public boolean needsScores() {
                return true;
            }
        };
    }

    private class BigDecimalExpressionTransformer
    extends ClassCodeExpressionTransformer {
        private final SourceUnit source;

        private BigDecimalExpressionTransformer(SourceUnit source) {
            this.source = source;
        }

        protected SourceUnit getSourceUnit() {
            return this.source;
        }

        public Expression transform(Expression expr) {
            ConstantExpression constExpr;
            Object val;
            Expression newExpr = expr;
            if (expr instanceof ConstantExpression && (val = (constExpr = (ConstantExpression)expr).getValue()) != null && val instanceof BigDecimal) {
                newExpr = new ConstantExpression((Object)((BigDecimal)val).doubleValue());
            }
            return super.transform(newExpr);
        }
    }

    private class GroovyBigDecimalTransformer
    extends CompilationCustomizer {
        private GroovyBigDecimalTransformer(CompilePhase phase) {
            super(phase);
        }

        public void call(SourceUnit source, GeneratorContext context, ClassNode classNode) throws CompilationFailedException {
            new BigDecimalExpressionTransformer(source).visitClass(classNode);
        }
    }

    public static final class GroovyScript
    implements ExecutableScript,
    LeafSearchScript {
        private final CompiledScript compiledScript;
        private final Script script;
        private final LeafSearchLookup lookup;
        private final Map<String, Object> variables;
        private final ESLogger logger;

        public GroovyScript(CompiledScript compiledScript, Script script, ESLogger logger) {
            this(compiledScript, script, null, logger);
        }

        public GroovyScript(CompiledScript compiledScript, Script script, @Nullable LeafSearchLookup lookup, ESLogger logger) {
            this.compiledScript = compiledScript;
            this.script = script;
            this.lookup = lookup;
            this.logger = logger;
            this.variables = script.getBinding().getVariables();
        }

        public void setScorer(Scorer scorer) {
            this.variables.put("_score", new ScoreAccessor(scorer));
        }

        public void setDocument(int doc) {
            if (this.lookup != null) {
                this.lookup.setDocument(doc);
            }
        }

        public void setNextVar(String name, Object value) {
            this.variables.put(name, value);
        }

        public void setSource(Map<String, Object> source) {
            if (this.lookup != null) {
                this.lookup.source().setSource(source);
            }
        }

        public Object run() {
            try {
                return AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        return GroovyScript.this.script.run();
                    }
                });
            }
            catch (Throwable e) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("failed to run " + this.compiledScript, e, new Object[0]);
                }
                throw new ScriptException("failed to run " + this.compiledScript, e);
            }
        }

        public float runAsFloat() {
            return ((Number)this.run()).floatValue();
        }

        public long runAsLong() {
            return ((Number)this.run()).longValue();
        }

        public double runAsDouble() {
            return ((Number)this.run()).doubleValue();
        }

        public Object unwrap(Object value) {
            return value;
        }
    }
}

