/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.reindex;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.WriteConsistencyLevel;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.reindex.BulkByScrollTask;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.tasks.Task;

public abstract class AbstractBulkByScrollRequest<Self extends AbstractBulkByScrollRequest<Self>>
extends ActionRequest<Self> {
    public static final int SIZE_ALL_MATCHES = -1;
    private static final TimeValue DEFAULT_SCROLL_TIMEOUT = TimeValue.timeValueMinutes((long)5L);
    private static final int DEFAULT_SCROLL_SIZE = 1000;
    private static final BytesReference DEFAULT_SOURCE = new SearchSourceBuilder().version(Boolean.valueOf(true)).size(1000).sort((SortBuilder)SortBuilders.fieldSort((String)"_doc")).buildAsBytes();
    private SearchRequest searchRequest;
    private int size = -1;
    private boolean abortOnVersionConflict = true;
    private boolean refresh = false;
    private TimeValue timeout = ReplicationRequest.DEFAULT_TIMEOUT;
    private WriteConsistencyLevel consistency = WriteConsistencyLevel.DEFAULT;
    private TimeValue retryBackoffInitialTime = TimeValue.timeValueMillis((long)500L);
    private int maxRetries = 11;
    private float requestsPerSecond = Float.POSITIVE_INFINITY;

    public AbstractBulkByScrollRequest() {
    }

    public AbstractBulkByScrollRequest(SearchRequest source) {
        this.searchRequest = source;
        source.scroll(DEFAULT_SCROLL_TIMEOUT);
    }

    protected abstract Self self();

    void applyDefaults() {
        if (this.searchRequest.source() == null) {
            this.searchRequest.source(DEFAULT_SOURCE);
        }
        try {
            Map newSource = (Map)XContentHelper.convertToMap((BytesReference)DEFAULT_SOURCE, (boolean)true).v2();
            Tuple sourceAndContent = XContentHelper.convertToMap((BytesReference)this.searchRequest.source(), (boolean)true);
            XContentHelper.update((Map)newSource, (Map)((Map)sourceAndContent.v2()), (boolean)false);
            XContentBuilder builder = XContentFactory.contentBuilder((XContentType)((XContentType)sourceAndContent.v1()));
            builder.map(newSource);
            this.searchRequest.source(builder.bytes());
        }
        catch (IOException e) {
            throw new ElasticsearchException("Strange IOException while apply default source", (Throwable)e, new Object[0]);
        }
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException e = this.searchRequest.validate();
        if (this.maxRetries < 0) {
            e = ValidateActions.addValidationError((String)"retries cannnot be negative", (ActionRequestValidationException)e);
        }
        if (!(this.size == -1 || this.size > 0)) {
            e = ValidateActions.addValidationError((String)("size should be greater than 0 if the request is limited to some number of documents or -1 if it isn't but it was [" + this.size + "]"), (ActionRequestValidationException)e);
        }
        return e;
    }

    public int getSize() {
        return this.size;
    }

    public Self setSize(int size) {
        this.size = size;
        return this.self();
    }

    public boolean isAbortOnVersionConflict() {
        return this.abortOnVersionConflict;
    }

    public Self setAbortOnVersionConflict(boolean abortOnVersionConflict) {
        this.abortOnVersionConflict = abortOnVersionConflict;
        return this.self();
    }

    public void setConflicts(String conflicts) {
        switch (conflicts) {
            case "proceed": {
                this.setAbortOnVersionConflict(false);
                return;
            }
            case "abort": {
                this.setAbortOnVersionConflict(true);
                return;
            }
        }
        throw new IllegalArgumentException("conflicts may only be \"proceed\" or \"abort\" but was [" + conflicts + "]");
    }

    public SearchRequest getSearchRequest() {
        return this.searchRequest;
    }

    public boolean isRefresh() {
        return this.refresh;
    }

    public Self setRefresh(boolean refresh) {
        this.refresh = refresh;
        return this.self();
    }

    public TimeValue getTimeout() {
        return this.timeout;
    }

    public Self setTimeout(TimeValue timeout) {
        this.timeout = timeout;
        return this.self();
    }

    public WriteConsistencyLevel getConsistency() {
        return this.consistency;
    }

    public Self setConsistency(WriteConsistencyLevel consistency) {
        this.consistency = consistency;
        return this.self();
    }

    public TimeValue getRetryBackoffInitialTime() {
        return this.retryBackoffInitialTime;
    }

    public Self setRetryBackoffInitialTime(TimeValue retryBackoffInitialTime) {
        this.retryBackoffInitialTime = retryBackoffInitialTime;
        return this.self();
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public Self setMaxRetries(int maxRetries) {
        this.maxRetries = maxRetries;
        return this.self();
    }

    public float getRequestsPerSecond() {
        return this.requestsPerSecond;
    }

    public Self setRequestsPerSecond(float requestsPerSecond) {
        if (requestsPerSecond <= 0.0f) {
            throw new IllegalArgumentException("[requests_per_second] must be greater than 0. Use Float.POSITIVE_INFINITY to disable throttling.");
        }
        this.requestsPerSecond = requestsPerSecond;
        return this.self();
    }

    public Task createTask(long id, String type, String action) {
        return new BulkByScrollTask(id, type, action, this.getDescription(), this.requestsPerSecond);
    }

    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.searchRequest = new SearchRequest();
        this.searchRequest.readFrom(in);
        this.abortOnVersionConflict = in.readBoolean();
        this.size = in.readVInt();
        this.refresh = in.readBoolean();
        this.timeout = TimeValue.readTimeValue((StreamInput)in);
        this.consistency = WriteConsistencyLevel.fromId((byte)in.readByte());
        this.retryBackoffInitialTime = TimeValue.readTimeValue((StreamInput)in);
        this.maxRetries = in.readVInt();
        if (in.getVersion().onOrAfter(Version.V_2_4_0)) {
            this.requestsPerSecond = in.readFloat();
        }
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        this.searchRequest.writeTo(out);
        out.writeBoolean(this.abortOnVersionConflict);
        out.writeVInt(this.size);
        out.writeBoolean(this.refresh);
        this.timeout.writeTo(out);
        out.writeByte(this.consistency.id());
        this.retryBackoffInitialTime.writeTo(out);
        out.writeVInt(this.maxRetries);
        if (out.getVersion().onOrAfter(Version.V_2_4_0)) {
            out.writeFloat(this.requestsPerSecond);
        }
    }

    protected void searchToString(StringBuilder b) {
        if (this.searchRequest.indices() != null && this.searchRequest.indices().length != 0) {
            b.append(Arrays.toString(this.searchRequest.indices()));
        } else {
            b.append("[all indices]");
        }
        if (this.searchRequest.types() != null && this.searchRequest.types().length != 0) {
            b.append(Arrays.toString(this.searchRequest.types()));
        }
    }
}

