/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.hash;

import java.math.BigInteger;
import org.gradle.impldep.com.google.common.base.Strings;

public class HashValue {
    private final BigInteger digest;

    public HashValue(byte[] digest) {
        this.digest = new BigInteger(1, digest);
    }

    public HashValue(String hexString) {
        this.digest = new BigInteger(hexString, 16);
    }

    public static HashValue parse(String inputString) {
        if (inputString == null || inputString.length() == 0) {
            return null;
        }
        return new HashValue(HashValue.parseInput(inputString));
    }

    private static String parseInput(String inputString) {
        if (inputString == null) {
            return null;
        }
        String cleaned = inputString.trim().toLowerCase();
        int spaceIndex = cleaned.indexOf(32);
        if (spaceIndex != -1) {
            String firstPart = cleaned.substring(0, spaceIndex);
            cleaned = firstPart.startsWith("md") || firstPart.startsWith("sha") ? cleaned.substring(cleaned.lastIndexOf(32) + 1) : (firstPart.endsWith(":") ? cleaned.substring(spaceIndex + 1).replace(" ", "") : cleaned.substring(0, spaceIndex));
        }
        return cleaned;
    }

    public String asCompactString() {
        return this.digest.toString(36);
    }

    public String asHexString() {
        return this.digest.toString(16);
    }

    public byte[] asByteArray() {
        return this.digest.toByteArray();
    }

    public BigInteger asBigInteger() {
        return this.digest;
    }

    public String asZeroPaddedHexString(int expectedLength) {
        return Strings.padStart(this.asHexString(), expectedLength, '0');
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HashValue)) {
            return false;
        }
        HashValue otherHashValue = (HashValue)other;
        return this.digest.equals(otherHashValue.digest);
    }

    public int hashCode() {
        return this.digest.hashCode();
    }
}

