/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.objects;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.objects.ShapeCachingGuards;

@ImportStatic(value={ShapeCachingGuards.class})
@NodeChild(value="object", type=RubyNode.class)
public abstract class LogicalClassNode
extends RubyNode {
    public LogicalClassNode(RubyContext context, SourceSection sourceSection) {
        super(context, sourceSection);
    }

    public abstract DynamicObject executeLogicalClass(Object var1);

    @Specialization(guards={"value"})
    protected DynamicObject logicalClassTrue(boolean value) {
        return this.coreLibrary().getTrueClass();
    }

    @Specialization(guards={"!value"})
    protected DynamicObject logicalClassFalse(boolean value) {
        return this.coreLibrary().getFalseClass();
    }

    @Specialization
    protected DynamicObject logicalClassInt(int value) {
        return this.coreLibrary().getFixnumClass();
    }

    @Specialization
    protected DynamicObject logicalClassLong(long value) {
        return this.coreLibrary().getFixnumClass();
    }

    @Specialization
    protected DynamicObject logicalClassDouble(double value) {
        return this.coreLibrary().getFloatClass();
    }

    @Specialization(guards={"object.getShape() == cachedShape"}, assumptions={"cachedShape.getValidAssumption()"}, limit="getCacheLimit()")
    protected DynamicObject logicalClassCached(DynamicObject object, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="getLogicalClass(cachedShape)") DynamicObject logicalClass) {
        return logicalClass;
    }

    @Specialization(guards={"updateShape(object)"})
    protected DynamicObject updateShapeAndLogicalClass(DynamicObject object) {
        return this.executeLogicalClass(object);
    }

    @Specialization(contains={"logicalClassCached", "updateShapeAndLogicalClass"})
    protected DynamicObject logicalClassUncached(DynamicObject object) {
        return Layouts.BASIC_OBJECT.getLogicalClass(object);
    }

    protected static DynamicObject getLogicalClass(Shape shape) {
        return Layouts.BASIC_OBJECT.getLogicalClass(shape.getObjectType());
    }

    protected int getCacheLimit() {
        return this.getContext().getOptions().CLASS_CACHE;
    }
}

