/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xmlb;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.BasePrimitiveBinding;
import com.intellij.util.xmlb.Binding;
import com.intellij.util.xmlb.MutableAccessor;
import com.intellij.util.xmlb.XmlSerializerImpl;
import com.intellij.util.xmlb.annotations.OptionTag;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OptionTagBinding
extends BasePrimitiveBinding {
    private final String myTagName;
    private final String myNameAttribute;
    private final String myValueAttribute;

    public OptionTagBinding(@NotNull MutableAccessor accessor, @Nullable OptionTag optionTag) {
        if (accessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessor", "com/intellij/util/xmlb/OptionTagBinding", "<init>"));
        }
        super(accessor, optionTag == null ? null : optionTag.value(), optionTag == null ? null : optionTag.converter());
        if (optionTag == null) {
            this.myTagName = "option";
            this.myNameAttribute = "name";
            this.myValueAttribute = "value";
        } else {
            this.myNameAttribute = optionTag.nameAttribute();
            this.myValueAttribute = optionTag.valueAttribute();
            String tagName = optionTag.tag();
            if (StringUtil.isEmpty(this.myNameAttribute) && "option".equals(tagName)) {
                tagName = this.myAccessor.getName();
            }
            this.myTagName = tagName;
        }
    }

    @Override
    public Object deserialize(Object context, @NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/OptionTagBinding", "deserialize"));
        }
        Attribute valueAttribute = element.getAttribute(this.myValueAttribute);
        if (valueAttribute == null) {
            if (this.myValueAttribute.isEmpty()) {
                assert (this.myBinding != null);
                this.myAccessor.set(context, this.myBinding.deserialize(context, element));
            } else {
                List<Element> children = element.getChildren();
                if (children.isEmpty()) {
                    this.myAccessor.set(context, null);
                } else {
                    assert (this.myBinding != null);
                    this.myAccessor.set(context, Binding.deserializeList(this.myBinding, this.myAccessor.read(context), children));
                }
            }
        } else if (this.myConverter == null) {
            XmlSerializerImpl.doSet(context, valueAttribute.getValue(), this.myAccessor, XmlSerializerImpl.typeToClass(this.myAccessor.getGenericType()));
        } else {
            this.myAccessor.set(context, this.myConverter.fromString(valueAttribute.getValue()));
        }
        return context;
    }

    @Override
    public boolean isBoundTo(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/util/xmlb/OptionTagBinding", "isBoundTo"));
        }
        if (!element.getName().equals(this.myTagName)) {
            return false;
        }
        String name = element.getAttributeValue(this.myNameAttribute);
        if (StringUtil.isEmpty(this.myNameAttribute)) {
            return name == null || name.equals(this.myName);
        }
        return name != null && name.equals(this.myName);
    }

    @NonNls
    public String toString() {
        return "OptionTagBinding[" + this.myName + ", binding=" + this.myBinding + "]";
    }
}

