/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.table;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.HistoryReference;
import org.zaproxy.zap.view.table.AbstractHistoryReferencesTableEntry;
import org.zaproxy.zap.view.table.AlertRiskTableCellItem;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;

public class DefaultHistoryReferencesTableEntry
extends AbstractHistoryReferencesTableEntry {
    private static final String VALUES_SEPARATOR = Constant.messages.getString("generic.value.text.separator.comma");
    private final Integer historyId;
    private final Integer historyType;
    private final Long sessionId;
    private final String method;
    private final String uri;
    private final Integer statusCode;
    private final String reason;
    private final Date timeSentMillis;
    private final Date timeReceivedMillis;
    private final Integer rtt;
    private final Long messageSize;
    private final Integer requestHeaderSize;
    private final Integer requestBodySize;
    private final Integer responseHeaderSize;
    private final Integer responseBodySize;
    private AlertRiskTableCellItem alertRiskCellItem;
    private final boolean highestAlertColumn;
    private Boolean note;
    private final boolean noteColumn;
    private String tags;
    private final boolean tagsColumn;

    public DefaultHistoryReferencesTableEntry(HistoryReference historyReference, HistoryReferencesTableModel.Column[] columnArray) {
        super(historyReference);
        HistoryReferencesTableModel.Column[] columnArray2 = Arrays.copyOf(columnArray, columnArray.length);
        Arrays.sort((Object[])columnArray2);
        this.historyId = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.HREF_ID) ? Integer.valueOf(historyReference.getHistoryId()) : null;
        this.historyType = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.HREF_TYPE) ? Integer.valueOf(historyReference.getHistoryType()) : null;
        this.sessionId = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.SESSION_ID) ? Long.valueOf(historyReference.getSessionId()) : null;
        this.method = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.METHOD) ? historyReference.getMethod() : null;
        this.statusCode = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.STATUS_CODE) ? Integer.valueOf(historyReference.getStatusCode()) : null;
        this.reason = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.STATUS_REASON) ? historyReference.getReason() : null;
        this.rtt = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.RTT) ? Integer.valueOf(historyReference.getRtt()) : null;
        this.uri = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.URL) ? historyReference.getURI().toString() : null;
        this.timeSentMillis = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.REQUEST_TIMESTAMP) ? new Date(historyReference.getTimeSentMillis()) : null;
        this.timeReceivedMillis = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.RESPONSE_TIMESTAMP) ? new Date(historyReference.getTimeReceivedMillis()) : null;
        this.requestHeaderSize = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.SIZE_REQUEST_HEADER) ? Integer.valueOf(historyReference.getRequestHeaderLength()) : null;
        this.requestBodySize = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.SIZE_REQUEST_BODY) ? Integer.valueOf(historyReference.getRequestBodyLength()) : null;
        this.responseHeaderSize = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.SIZE_RESPONSE_HEADER) ? Integer.valueOf(historyReference.getResponseHeaderLength()) : null;
        this.responseBodySize = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.SIZE_RESPONSE_BODY) ? Integer.valueOf(historyReference.getResponseBodyLength()) : null;
        this.messageSize = this.extractMessageSize(historyReference, DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.SIZE_MESSAGE));
        this.highestAlertColumn = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.HIGHEST_ALERT);
        this.noteColumn = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.NOTE);
        this.tagsColumn = DefaultHistoryReferencesTableEntry.hasColumn(columnArray2, HistoryReferencesTableModel.Column.TAGS);
        this.alertRiskCellItem = super.getHighestAlert();
        this.refreshCachedValues();
    }

    private Long extractMessageSize(HistoryReference historyReference, boolean bl) {
        if (!bl) {
            return 0L;
        }
        return historyReference.getRequestHeaderLength() + historyReference.getRequestBodyLength() + historyReference.getResponseHeaderLength() + historyReference.getResponseBodyLength();
    }

    private static boolean hasColumn(HistoryReferencesTableModel.Column[] columnArray, HistoryReferencesTableModel.Column column) {
        for (int i = 0; i < columnArray.length; ++i) {
            if (column != columnArray[i]) continue;
            return true;
        }
        return false;
    }

    @Override
    public Integer getHistoryId() {
        return this.historyId;
    }

    @Override
    public Integer getHistoryType() {
        return this.historyType;
    }

    @Override
    public Long getSessionId() {
        return this.sessionId;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    @Override
    public Integer getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getReason() {
        return this.reason;
    }

    @Override
    public Date getRequestTimestamp() {
        return this.timeSentMillis;
    }

    @Override
    public Date getResponseTimestamp() {
        return this.timeReceivedMillis;
    }

    @Override
    public Integer getRtt() {
        return this.rtt;
    }

    @Override
    public Long getMessageSize() {
        return this.messageSize;
    }

    @Override
    public Integer getRequestHeaderSize() {
        return this.requestHeaderSize;
    }

    @Override
    public Integer getRequestBodySize() {
        return this.requestBodySize;
    }

    @Override
    public Integer getResponseHeaderSize() {
        return this.responseHeaderSize;
    }

    @Override
    public Integer getResponseBodySize() {
        return this.responseBodySize;
    }

    @Override
    public AlertRiskTableCellItem getHighestAlert() {
        return this.alertRiskCellItem;
    }

    @Override
    public Boolean hasNote() {
        return this.note;
    }

    @Override
    public String getTags() {
        return this.tags;
    }

    public void refreshCachedValues() {
        if (this.noteColumn) {
            this.note = this.getHistoryReference().hasNote();
        }
        if (this.tagsColumn) {
            this.tags = DefaultHistoryReferencesTableEntry.listToCsv(this.getHistoryReference().getTags());
        }
        if (this.highestAlertColumn) {
            this.alertRiskCellItem = AlertRiskTableCellItem.getItemForRisk(this.getHistoryReference().getHighestAlert());
        }
    }

    private static String listToCsv(List<String> list) {
        if (list == null || list.size() == 0) {
            return "";
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        if (list.size() == 2) {
            return MessageFormat.format(VALUES_SEPARATOR, list.get(0), list.get(1));
        }
        String string = VALUES_SEPARATOR;
        int n = list.size() - 2;
        for (int i = 0; i < n; ++i) {
            string = MessageFormat.format(string, list.get(i), VALUES_SEPARATOR);
        }
        string = MessageFormat.format(string, list.get(n), list.get(list.size() - 1));
        return string;
    }
}

