/*
 * Decompiled with CFR 0.152.
 */
package net.adaptivebox.knowledge;

import net.adaptivebox.encode.IEncodeEngine;
import net.adaptivebox.space.BasicPoint;

public class SearchPoint
extends BasicPoint
implements IEncodeEngine {
    private final double[] encodeInfo = new double[2];
    private double objectiveValue;

    public SearchPoint(int dim) {
        super(dim);
        for (int i = 0; i < this.encodeInfo.length; ++i) {
            this.encodeInfo[i] = 1.0E308;
        }
    }

    public double[] getEncodeInfo() {
        return this.encodeInfo;
    }

    private void importEncodeInfo(double[] info) {
        System.arraycopy(info, 0, this.encodeInfo, 0, this.encodeInfo.length);
    }

    private void importEncodeInfo(IEncodeEngine point) {
        this.importEncodeInfo(point.getEncodeInfo());
    }

    public void importPoint(SearchPoint point) {
        this.importLocation(point);
        this.importEncodeInfo(point);
        this.setObjectiveValue(point.getObjectiveValue());
    }

    public double getObjectiveValue() {
        return this.objectiveValue;
    }

    public void setObjectiveValue(double objectiveValue) {
        this.objectiveValue = objectiveValue;
    }

    public boolean isFeasible() {
        return this.encodeInfo[0] == 0.0;
    }
}

