/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wiki;

import com.sun.star.awt.MessageBoxType;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XDialog;
import com.sun.star.awt.XMessageBox;
import com.sun.star.awt.XMessageBoxFactory;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.NamedValue;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XContainerQuery;
import com.sun.star.container.XEnumeration;
import com.sun.star.container.XNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.document.XDocumentProperties;
import com.sun.star.document.XDocumentPropertiesSupplier;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XModuleManager;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.system.XSystemShellExecute;
import com.sun.star.task.UrlRecord;
import com.sun.star.task.XInteractionHandler;
import com.sun.star.task.XMasterPasswordHandling;
import com.sun.star.task.XPasswordContainer;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.util.XChangesBatch;
import com.sun.star.wiki.EditPageParser;
import com.sun.star.wiki.MainThreadDialogExecutor;
import com.sun.star.wiki.WikiCancelException;
import com.sun.star.wiki.WikiProtocolSocketFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.swing.text.html.HTMLEditorKit;

public class Helper {
    public static final int GENERALSEND_ERROR = 0;
    public static final int NOWIKIFILTER_ERROR = 1;
    public static final int NOURLCONNECTION_ERROR = 2;
    public static final int WRONGLOGIN_ERROR = 3;
    public static final int INVALIDURL_ERROR = 4;
    public static final int NOURL_ERROR = 5;
    public static final int DLG_SENDTITLE = 6;
    public static final int DLG_WIKIARTICLE = 7;
    public static final int DLG_OK = 9;
    public static final int DLG_ADDBUTTON = 12;
    public static final int DLG_EDITBUTTON = 13;
    public static final int DLG_SENDBUTTON = 14;
    public static final int DLG_REMOVEBUTTON = 15;
    public static final int DLG_EDITSETTING_URLLABEL = 16;
    public static final int DLG_EDITSETTING_USERNAMELABEL = 17;
    public static final int DLG_EDITSETTING_PASSWORDLABEL = 18;
    public static final int DLG_SENDTOMEDIAWIKI_LABEL1 = 20;
    public static final int DLG_SENDTOMEDIAWIKI_LABEL2 = 21;
    public static final int DLG_SENDTOMEDIAWIKI_LABEL3 = 22;
    public static final int DLG_SENDTOMEDIAWIKI_MINORCHECK = 23;
    public static final int DLG_SENDTOMEDIAWIKI_BROWSERCHECK = 24;
    public static final int UNKNOWNCERT_ERROR = 25;
    public static final int DLG_MEDIAWIKI_TITLE = 26;
    public static final int DLG_EDITSETTING_ACCOUNTLINE = 27;
    public static final int DLG_EDITSETTING_WIKILINE = 28;
    public static final int DLG_EDITSETTING_SAVEBOX = 29;
    public static final int CANCELSENDING_ERROR = 30;
    public static final int DLG_MEDIAWIKIEXTENSION_STRING = 31;
    public static final int DLG_WIKIPAGEEXISTS_LABEL1 = 32;
    private static final int STRINGS_NUM = 33;
    private static final String[] m_pEntryNames = new String[]{"GeneralSendError", "NoWikiFilter", "NoConnectionToURL", "WrongLogin", "InvalidURL", "NoURL", "Dlg_SendTitle", "Dlg_WikiArticle", "Dlg_No", "Dlg_OK", "Dlg_Yes", null, "Dlg_AddButton", "Dlg_EditButton", "Dlg_SendButton", "Dlg_RemoveButton", "Dlg_EditSetting_UrlLabel", "Dlg_EditSetting_UsernameLabel", "Dlg_EditSetting_PasswordLabel", "Dlg_NewWikiPage_Label1", "Dlg_SendToMediaWiki_Label1", "Dlg_SendToMediaWiki_Label2", "Dlg_SendToMediaWiki_Label3", "Dlg_SendToMediaWiki_MinorCheck", "Dlg_SendToMediaWiki_BrowserCheck", "UnknownCert", "Dlg_MediaWiki_Title", "Dlg_EditSetting_AccountLine", "Dlg_EditSetting_WikiLine", "Dlg_EditSetting_SaveBox", "CancelSending", "Dlg_MediaWiki_Extension_String", "Dlg_WikiPageExists_Label1"};
    private static String[] m_pConfigStrings;
    private static boolean m_bAllowConnection;
    private static Boolean m_bShowInBrowser;
    private static XPasswordContainer m_xPasswordContainer;
    private static XInteractionHandler m_xInteractionHandler;

    protected static synchronized String GetLocalizedString(XComponentContext xContext, int nID) throws com.sun.star.uno.Exception {
        if (nID >= 33) {
            throw new RuntimeException();
        }
        if (m_pConfigStrings == null) {
            XNameAccess xNameAccess = Helper.GetConfigNameAccess(xContext, "org.openoffice.Office.Custom.WikiExtension/Strings");
            String[] pStrings = new String[33];
            for (int nInd = 0; nInd < 33; ++nInd) {
                pStrings[nInd] = m_pEntryNames[nInd] != null ? AnyConverter.toString((Object)xNameAccess.getByName(m_pEntryNames[nInd])) : "";
            }
            m_pConfigStrings = pStrings;
        }
        return m_pConfigStrings[nID];
    }

    protected static synchronized void AllowConnection(boolean bAllow) {
        m_bAllowConnection = bAllow;
    }

    protected static synchronized boolean IsConnectionAllowed() {
        return m_bAllowConnection;
    }

    protected static synchronized boolean GetShowInBrowserByDefault(XComponentContext xContext) {
        if (m_bShowInBrowser == null) {
            try {
                XNameAccess xAccess = Helper.GetConfigNameAccess(xContext, "org.openoffice.Office.Custom.WikiExtension/Settings");
                m_bShowInBrowser = AnyConverter.toBoolean((Object)xAccess.getByName("PreselectShowBrowser"));
            }
            catch (com.sun.star.uno.Exception e) {
                e.printStackTrace();
            }
        }
        return m_bShowInBrowser;
    }

    protected static synchronized void SetShowInBrowserByDefault(XComponentContext xContext, boolean bValue) {
        try {
            m_bShowInBrowser = bValue;
            XPropertySet xProps = Helper.GetConfigProps(xContext, "org.openoffice.Office.Custom.WikiExtension/Settings");
            xProps.setPropertyValue("PreselectShowBrowser", (Object)bValue);
            XChangesBatch xBatch = (XChangesBatch)UnoRuntime.queryInterface(XChangesBatch.class, (Object)xProps);
            if (xBatch != null) {
                xBatch.commitChanges();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static synchronized XPasswordContainer GetPasswordContainer(XComponentContext xContext) throws com.sun.star.uno.Exception {
        XMultiComponentFactory xFactory;
        if (m_xPasswordContainer == null && xContext != null && (xFactory = xContext.getServiceManager()) != null) {
            m_xPasswordContainer = (XPasswordContainer)UnoRuntime.queryInterface(XPasswordContainer.class, (Object)xFactory.createInstanceWithContext("com.sun.star.task.PasswordContainer", xContext));
        }
        if (m_xPasswordContainer == null) {
            throw new RuntimeException();
        }
        return m_xPasswordContainer;
    }

    protected static synchronized XInteractionHandler GetInteractionHandler(XComponentContext xContext) throws com.sun.star.uno.Exception {
        XMultiComponentFactory xFactory;
        if (m_xInteractionHandler == null && xContext != null && (xFactory = xContext.getServiceManager()) != null) {
            m_xInteractionHandler = (XInteractionHandler)UnoRuntime.queryInterface(XInteractionHandler.class, (Object)xFactory.createInstanceWithContext("com.sun.star.task.InteractionHandler", xContext));
        }
        if (m_xInteractionHandler == null) {
            throw new RuntimeException();
        }
        return m_xInteractionHandler;
    }

    protected static String GetMainURL(String sWebPage, String sVURL) {
        int nIndex;
        String sResultURL = "";
        try {
            StringReader aReader = new StringReader(sWebPage);
            HTMLEditorKit.Parser aParser = Helper.GetHTMLParser();
            EditPageParser aCallback = new EditPageParser();
            aParser.parse(aReader, aCallback, true);
            sResultURL = aCallback.m_sMainURL;
            if (!sResultURL.startsWith("http")) {
                URL aURL = new URL(sVURL);
                sResultURL = aURL.getProtocol() + "://" + aURL.getHost() + sResultURL;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (sResultURL.length() == 0 && (nIndex = sVURL.indexOf("index.php")) >= 0) {
            sResultURL = sVURL.substring(0, nIndex);
        }
        return sResultURL;
    }

    protected static String GetRedirectURL(String sWebPage, String sURL) {
        int nEndURL;
        int nURL;
        int nInd = sWebPage.indexOf("http-equiv=\"refresh\"");
        if (nInd == -1) {
            return "";
        }
        String sResultURL = "";
        int nContent = sWebPage.indexOf("content=", nInd);
        if (nContent > 0 && (nURL = sWebPage.indexOf("URL=", nContent)) > 0 && (nEndURL = sWebPage.indexOf(34, nURL)) > 0) {
            sResultURL = sWebPage.substring(nURL + 4, nEndURL);
        }
        try {
            URL aURL = new URL(sURL);
            if (!sResultURL.startsWith(aURL.getProtocol())) {
                sResultURL = sResultURL.startsWith("/") ? aURL.getProtocol() + "://" + aURL.getHost() + sResultURL : aURL.getProtocol() + "://" + aURL.getHost() + aURL.getPath() + sResultURL;
            }
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
        }
        return sResultURL;
    }

    protected static String CreateTempFile(XComponentContext xContext) {
        String sURL = "";
        try {
            Object oTempFile = xContext.getServiceManager().createInstanceWithContext("com.sun.star.io.TempFile", xContext);
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)oTempFile);
            xPropertySet.setPropertyValue("RemoveFile", (Object)Boolean.FALSE);
            sURL = (String)xPropertySet.getPropertyValue("Uri");
            XInputStream xInputStream = (XInputStream)UnoRuntime.queryInterface(XInputStream.class, (Object)oTempFile);
            xInputStream.closeInput();
            XOutputStream xOutputStream = (XOutputStream)UnoRuntime.queryInterface(XOutputStream.class, (Object)oTempFile);
            xOutputStream.closeOutput();
        }
        catch (com.sun.star.uno.Exception ex) {
            ex.printStackTrace();
        }
        return sURL;
    }

    protected static String EachLine(String sURL) {
        String sText = "";
        try {
            URL aURL = new URL(sURL);
            File aFile = new File(aURL.getFile());
            InputStreamReader aInputReader = new InputStreamReader((InputStream)new FileInputStream(aFile), "UTF-8");
            BufferedReader aBufReader = new BufferedReader(aInputReader);
            StringBuffer aBuf = new StringBuffer();
            String sEachLine = aBufReader.readLine();
            while (sEachLine != null) {
                aBuf.append(sEachLine);
                aBuf.append("\n");
                sEachLine = aBufReader.readLine();
            }
            sText = aBuf.toString();
            aBufReader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sText;
    }

    protected static String GetDocTitle(XModel xDoc) {
        XDocumentPropertiesSupplier xDocPropSup = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)xDoc);
        XDocumentProperties xDocProps = xDocPropSup.getDocumentProperties();
        return xDocProps.getTitle();
    }

    protected static void SetDocTitle(XModel xDoc, String sTitle) {
        XDocumentPropertiesSupplier xDocPropSup = (XDocumentPropertiesSupplier)UnoRuntime.queryInterface(XDocumentPropertiesSupplier.class, (Object)xDoc);
        XDocumentProperties xDocProps = xDocPropSup.getDocumentProperties();
        xDocProps.setTitle(sTitle);
    }

    protected static String GetDocServiceName(XComponentContext xContext, XModel xModel) {
        String aDocServiceName = "";
        if (xModel != null && xContext != null) {
            try {
                XMultiComponentFactory xFactory = xContext.getServiceManager();
                if (xFactory == null) {
                    throw new RuntimeException();
                }
                Object oModuleManager = xFactory.createInstanceWithContext("com.sun.star.frame.ModuleManager", xContext);
                XModuleManager xModuleManager = (XModuleManager)UnoRuntime.queryInterface(XModuleManager.class, (Object)oModuleManager);
                if (xModuleManager != null) {
                    aDocServiceName = xModuleManager.identify((Object)xModel);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return aDocServiceName;
    }

    protected static String GetFilterName(XComponentContext xContext, String aTypeName, String aDocServiceName) {
        if (xContext == null || aTypeName == null || aTypeName.length() == 0 || aDocServiceName == null || aDocServiceName.length() == 0) {
            return "";
        }
        String aFilterName = "";
        try {
            NamedValue[] aRequest;
            XEnumeration xSet;
            Object oFilterFactory = xContext.getServiceManager().createInstanceWithContext("com.sun.star.document.FilterFactory", xContext);
            XContainerQuery xQuery = (XContainerQuery)UnoRuntime.queryInterface(XContainerQuery.class, (Object)oFilterFactory);
            if (xQuery != null && (xSet = xQuery.createSubSetEnumerationByProperties(aRequest = new NamedValue[]{new NamedValue("Type", (Object)aTypeName), new NamedValue("DocumentService", (Object)aDocServiceName)})) != null) {
                boolean bAcceptable = false;
                while (xSet.hasMoreElements() && !bAcceptable) {
                    PropertyValue[] pFilterProps = (PropertyValue[])AnyConverter.toArray((Object)xSet.nextElement());
                    if (pFilterProps == null) continue;
                    int nLen = pFilterProps.length;
                    String aTmpFilter = null;
                    for (int nInd = 0; nInd < nLen; ++nInd) {
                        if (pFilterProps[nInd].Name.equals("Name")) {
                            aTmpFilter = AnyConverter.toString((Object)pFilterProps[nInd].Value);
                            continue;
                        }
                        if (!pFilterProps[nInd].Name.equals("Flags")) continue;
                        bAcceptable = (AnyConverter.toInt((Object)pFilterProps[nInd].Value) & 2) == 2;
                    }
                    if (!bAcceptable) continue;
                    aFilterName = aTmpFilter;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aFilterName;
    }

    private static XMultiServiceFactory GetConfigurationProvider(XComponentContext xContext) throws com.sun.star.uno.Exception {
        XMultiServiceFactory xConfigurationProvider = null;
        if (xContext != null) {
            XMultiComponentFactory xFactory = xContext.getServiceManager();
            Object oConfigProvider = xFactory.createInstanceWithContext("com.sun.star.configuration.ConfigurationProvider", xContext);
            xConfigurationProvider = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)oConfigProvider);
        }
        if (xConfigurationProvider == null) {
            throw new RuntimeException();
        }
        return xConfigurationProvider;
    }

    private static Object GetConfig(XComponentContext xContext, String sNodepath, boolean bWriteAccess) throws com.sun.star.uno.Exception {
        if (xContext == null || sNodepath == null) {
            throw new RuntimeException();
        }
        PropertyValue aVal = new PropertyValue();
        aVal.Name = "nodepath";
        aVal.Value = sNodepath;
        Object[] aArgs = new Object[]{aVal};
        return Helper.GetConfigurationProvider(xContext).createInstanceWithArguments(bWriteAccess ? "com.sun.star.configuration.ConfigurationUpdateAccess" : "com.sun.star.configuration.ConfigurationAccess", aArgs);
    }

    private static XPropertySet GetConfigProps(XComponentContext xContext, String sNodepath) throws com.sun.star.uno.Exception {
        XPropertySet xProps = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)Helper.GetConfig(xContext, sNodepath, true));
        if (xProps == null) {
            throw new RuntimeException();
        }
        return xProps;
    }

    protected static XNameContainer GetConfigNameContainer(XComponentContext xContext, String sNodepath) throws com.sun.star.uno.Exception {
        XNameContainer xContainer = (XNameContainer)UnoRuntime.queryInterface(XNameContainer.class, (Object)Helper.GetConfig(xContext, sNodepath, true));
        if (xContainer == null) {
            throw new RuntimeException();
        }
        return xContainer;
    }

    protected static XNameAccess GetConfigNameAccess(XComponentContext xContext, String sNodepath) throws com.sun.star.uno.Exception {
        XNameAccess xNameAccess = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)Helper.GetConfig(xContext, sNodepath, false));
        if (xNameAccess == null) {
            throw new RuntimeException();
        }
        return xNameAccess;
    }

    private static Proxy GetConfigurationProxy(URI uri, XComponentContext xContext) {
        assert (uri != null);
        assert (xContext != null);
        try {
            XNameAccess xNameAccess = Helper.GetConfigNameAccess(xContext, "org.openoffice.Inet/Settings");
            int nProxyType = AnyConverter.toInt((Object)xNameAccess.getByName("ooInetProxyType"));
            if (nProxyType == 0) {
                return Proxy.NO_PROXY;
            }
            if (nProxyType == 1) {
                return null;
            }
            if (nProxyType == 2) {
                String aProxyNameProp = "ooInetHTTPProxyName";
                String aProxyPortProp = "ooInetHTTPProxyPort";
                if (uri.getScheme().equals("https")) {
                    aProxyNameProp = "ooInetHTTPSProxyName";
                    aProxyPortProp = "ooInetHTTPSProxyPort";
                }
                String aProxyName = AnyConverter.toString((Object)xNameAccess.getByName(aProxyNameProp));
                int nProxyPort = 80;
                Object aPortNo = xNameAccess.getByName(aProxyPortProp);
                if (!AnyConverter.isVoid((Object)aPortNo)) {
                    nProxyPort = AnyConverter.toInt((Object)aPortNo);
                }
                if (nProxyPort == -1) {
                    nProxyPort = 80;
                }
                InetSocketAddress address = new InetSocketAddress(aProxyName, nProxyPort);
                return new Proxy(Proxy.Type.HTTP, address);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected static void ShowURLInBrowser(XComponentContext xContext, String sURL) {
        if (xContext != null && sURL != null && sURL.length() > 0) {
            try {
                Object oSystemShell = xContext.getServiceManager().createInstanceWithContext("com.sun.star.system.SystemShellExecute", xContext);
                XSystemShellExecute xSystemShell = (XSystemShellExecute)UnoRuntime.queryInterface(XSystemShellExecute.class, (Object)oSystemShell);
                if (xSystemShell != null) {
                    xSystemShell.execute(sURL, "", 2);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static HttpURLConnection PrepareMethod(String method, URI uri, XComponentContext xContext) throws WikiCancelException, IOException, SSLException {
        assert (method != null);
        assert (uri != null);
        assert (xContext != null);
        if (!Helper.IsConnectionAllowed()) {
            throw new WikiCancelException();
        }
        if (CookieHandler.getDefault() == null) {
            CookieHandler.setDefault(new CookieManager());
        }
        Proxy proxy = Helper.GetConfigurationProxy(uri, xContext);
        HttpURLConnection conn = null;
        conn = proxy != null ? (HttpURLConnection)uri.toURL().openConnection(proxy) : (HttpURLConnection)uri.toURL().openConnection();
        if (uri.getScheme().equals("https") && Helper.AllowUnknownCert(xContext, uri.getHost())) {
            ((HttpsURLConnection)conn).setSSLSocketFactory(new WikiProtocolSocketFactory());
        }
        conn.setRequestMethod(method);
        conn.setRequestProperty("User-Agent", "LibreOffice Wiki Publisher 1.2.0");
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static String ReadResponseBody(HttpURLConnection conn) throws IOException {
        String ret = null;
        InputStream stream = conn.getInputStream();
        try {
            String line;
            String type = conn.getContentType();
            String charset = "ISO-8859-1";
            for (String param : type.split(";")) {
                if (!param.trim().toLowerCase().startsWith("charset=")) continue;
                charset = param.trim().substring("charset=".length());
                break;
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(stream, charset));
            StringBuilder buf = new StringBuilder();
            while ((line = br.readLine()) != null) {
                buf.append(line);
            }
            ret = buf.toString();
        }
        finally {
            stream.close();
        }
        return ret;
    }

    protected static HTMLEditorKit.Parser GetHTMLParser() {
        return new HTMLParse().getParser();
    }

    private static boolean LoginReportsError(String sRespond) {
        boolean bResult = true;
        if (sRespond != null) {
            try {
                StringReader aReader = new StringReader(sRespond);
                HTMLEditorKit.Parser aParser = Helper.GetHTMLParser();
                EditPageParser aCallback = new EditPageParser();
                aParser.parse(aReader, aCallback, true);
                bResult = aCallback.m_nErrorInd >= 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return bResult;
    }

    private static String GetLoginToken(String sLoginPage) {
        String sResult = "";
        if (sLoginPage != null && sLoginPage.length() > 0) {
            try {
                StringReader aReader = new StringReader(sLoginPage);
                HTMLEditorKit.Parser aParser = Helper.GetHTMLParser();
                EditPageParser aCallbacks = new EditPageParser();
                aParser.parse(aReader, aCallbacks, true);
                sResult = aCallbacks.m_sLoginToken;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sResult;
    }

    protected static boolean Login(URI aMainURL, String sWikiUser, String sWikiPass, XComponentContext xContext) throws IOException, WikiCancelException, URISyntaxException {
        boolean success = false;
        if (sWikiUser != null && sWikiPass != null && xContext != null) {
            String sLoginPage = null;
            URI aURI = new URI(aMainURL.toString() + "index.php?title=Special:Userlogin");
            HttpURLConnection connGet = Helper.PrepareMethod("GET", aURI, xContext);
            connGet.setInstanceFollowRedirects(true);
            connGet.connect();
            int nResultCode = connGet.getResponseCode();
            if (nResultCode == 200) {
                sLoginPage = Helper.ReadResponseBody(connGet);
            }
            if (sLoginPage != null) {
                String sResult;
                String[][] pArgs;
                String sLoginToken = Helper.GetLoginToken(sLoginPage);
                URI aPostURI = new URI(aMainURL.toString() + "index.php?title=Special:Userlogin&action=submitlogin");
                HttpURLConnection connPost = Helper.PrepareMethod("POST", aPostURI, xContext);
                connPost.setInstanceFollowRedirects(true);
                connPost.setDoInput(true);
                connPost.setDoOutput(true);
                connPost.connect();
                OutputStreamWriter post = new OutputStreamWriter(connPost.getOutputStream(), "UTF-8");
                post.write("wpName=");
                post.write(URLEncoder.encode(sWikiUser, "UTF-8"));
                post.write("&wpRemember=1");
                post.write("&wpPassword=");
                post.write(URLEncoder.encode(sWikiPass, "UTF-8"));
                if (sLoginToken.length() > 0) {
                    post.write("&wpLoginToken=");
                    post.write(URLEncoder.encode(sLoginToken, "UTF-8"));
                }
                if ((pArgs = Helper.GetSpecialArgs(xContext, aMainURL.getHost())) != null) {
                    for (int nArgInd = 0; nArgInd < pArgs.length; ++nArgInd) {
                        if (pArgs[nArgInd].length != 2 || pArgs[nArgInd][0] == null || pArgs[nArgInd][1] == null) continue;
                        post.write("&");
                        post.write(URLEncoder.encode(pArgs[nArgInd][0], "UTF-8"));
                        post.write("=");
                        post.write(URLEncoder.encode(pArgs[nArgInd][0], "UTF-8"));
                    }
                }
                post.flush();
                post.close();
                nResultCode = connPost.getResponseCode();
                if (nResultCode == 200 && !Helper.LoginReportsError(sResult = Helper.ReadResponseBody(connPost))) {
                    success = true;
                }
            }
        }
        return success;
    }

    protected static String[] GetPasswordsForURLAndUser(XComponentContext xContext, String sURL, String sUserName) {
        String[] aResult = null;
        try {
            UrlRecord aRec;
            if (xContext != null && sURL != null && sURL.length() > 0 && sUserName != null && sUserName.length() > 0 && (aRec = Helper.GetPasswordContainer(xContext).findForName(sURL, sUserName, Helper.GetInteractionHandler(xContext))) != null && aRec.UserList != null && aRec.UserList.length > 0 && aRec.UserList[0].UserName.equals(sUserName)) {
                aResult = aRec.UserList[0].Passwords;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aResult;
    }

    protected static boolean PasswordStoringIsAllowed(XComponentContext xContext) {
        boolean bResult = false;
        try {
            XMasterPasswordHandling xMasterHdl = (XMasterPasswordHandling)UnoRuntime.queryInterface(XMasterPasswordHandling.class, (Object)Helper.GetPasswordContainer(xContext));
            if (xMasterHdl != null) {
                bResult = xMasterHdl.isPersistentStoringAllowed();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return bResult;
    }

    protected static void ShowError(XComponentContext xContext, XDialog xDialog, int nTitleID, int nErrorID, String sArg, boolean bQuery) {
        XWindowPeer xPeer = null;
        XControl xControl = (XControl)UnoRuntime.queryInterface(XControl.class, (Object)xDialog);
        if (xControl != null) {
            xPeer = xControl.getPeer();
        }
        Helper.ShowError(xContext, xPeer, nTitleID, nErrorID, sArg, bQuery);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean ShowError(XComponentContext xContext, XWindowPeer xParentPeer, int nTitleID, int nErrorID, String sArg, boolean bQuery) {
        boolean bResult = false;
        if (xContext != null && nErrorID >= 0 && nErrorID < 33) {
            String sError = null;
            String sTitle = "";
            try {
                sError = Helper.GetLocalizedString(xContext, nErrorID);
                if (sError != null && sArg != null) {
                    sError = sError.replaceAll("\\$ARG1", sArg);
                }
                sTitle = Helper.GetLocalizedString(xContext, nTitleID);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (sError == null) {
                sError = "Error: " + nErrorID;
            }
            if (xParentPeer != null) {
                XMessageBoxFactory xMBFactory = null;
                XMessageBox xMB = null;
                try {
                    XMultiComponentFactory xFactory = xContext.getServiceManager();
                    if (xFactory != null) {
                        xMBFactory = (XMessageBoxFactory)UnoRuntime.queryInterface(XMessageBoxFactory.class, (Object)xFactory.createInstanceWithContext("com.sun.star.awt.Toolkit", xContext));
                    }
                    if (xMBFactory != null && (xMB = bQuery ? xMBFactory.createMessageBox(xParentPeer, MessageBoxType.QUERYBOX, 327683, sTitle, sError) : xMBFactory.createMessageBox(xParentPeer, MessageBoxType.ERRORBOX, 1, sTitle, sError)) != null) {
                        bResult = MainThreadDialogExecutor.Execute(xContext, xMB);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (xMB != null) {
                        Helper.Dispose(xMB);
                    }
                }
            }
        }
        return bResult;
    }

    private static boolean AllowUnknownCert(XComponentContext xContext, String aURL) {
        try {
            XNameAccess xEntry;
            XNameAccess xNameAccess = Helper.GetConfigNameAccess(xContext, "org.openoffice.Office.Custom.WikiExtension/SpecialData");
            if (xNameAccess.hasByName(aURL) && (xEntry = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xNameAccess.getByName(aURL))) != null && xEntry.hasByName("AllowUnknownCertificate")) {
                return AnyConverter.toBoolean((Object)xEntry.getByName("AllowUnknownCertificate"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static String[][] GetSpecialArgs(XComponentContext xContext, String aURL) {
        try {
            String[] pNames;
            XNameAccess xArgs;
            XNameAccess xEntry;
            XNameAccess xNameAccess = Helper.GetConfigNameAccess(xContext, "org.openoffice.Office.Custom.WikiExtension/SpecialData");
            if (xNameAccess.hasByName(aURL) && (xEntry = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xNameAccess.getByName(aURL))) != null && (xArgs = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xEntry.getByName("AdditionalLoginArguments"))) != null && (pNames = xArgs.getElementNames()) != null && pNames.length > 0) {
                String[][] pResult = new String[pNames.length][2];
                for (int nInd = 0; nInd < pNames.length; ++nInd) {
                    XNameAccess xArgument = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)xArgs.getByName(pNames[nInd]));
                    if (xArgument == null) {
                        throw new RuntimeException();
                    }
                    pResult[nInd][0] = pNames[nInd];
                    pResult[nInd][1] = AnyConverter.toString((Object)xArgument.getByName("Value"));
                }
                return pResult;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected static boolean AllowThreadUsage(XComponentContext xContext) {
        if (xContext != null) {
            try {
                XMultiComponentFactory xFactory = xContext.getServiceManager();
                if (xFactory == null) {
                    throw new RuntimeException();
                }
                Object oCheckCallback = xFactory.createInstanceWithContext("com.sun.star.awt.AsyncCallback", xContext);
                return oCheckCallback != null;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static void Dispose(Object oObject) {
        if (oObject != null) {
            try {
                XComponent xComp = (XComponent)UnoRuntime.queryInterface(XComponent.class, (Object)oObject);
                if (xComp != null) {
                    xComp.dispose();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    static {
        m_bAllowConnection = true;
        m_bShowInBrowser = null;
    }

    private static class HTMLParse
    extends HTMLEditorKit {
        private HTMLParse() {
        }

        public HTMLEditorKit.Parser getParser() {
            return super.getParser();
        }
    }
}

