/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11.upgrade;

import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.CompletionHandler;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.coyote.http11.upgrade.AbstractServletInputStream;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.Nio2Channel;
import org.apache.tomcat.util.net.Nio2Endpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Nio2ServletInputStream
extends AbstractServletInputStream {
    private final AbstractEndpoint<Nio2Channel> endpoint;
    private final SocketWrapper<Nio2Channel> wrapper;
    private final Nio2Channel channel;
    private final CompletionHandler<Integer, SocketWrapper<Nio2Channel>> completionHandler;
    private boolean flipped = false;
    private volatile boolean readPending = false;
    private volatile boolean interest = true;
    private volatile boolean closed = false;

    public Nio2ServletInputStream(SocketWrapper<Nio2Channel> wrapper, AbstractEndpoint<Nio2Channel> endpoint0) {
        this.endpoint = endpoint0;
        this.wrapper = wrapper;
        this.channel = wrapper.getSocket();
        this.completionHandler = new CompletionHandler<Integer, SocketWrapper<Nio2Channel>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void completed(Integer nBytes, SocketWrapper<Nio2Channel> attachment) {
                boolean notify = false;
                CompletionHandler completionHandler = Nio2ServletInputStream.this.completionHandler;
                synchronized (completionHandler) {
                    if (nBytes < 0) {
                        if (Nio2ServletInputStream.this.closed) {
                            Nio2ServletInputStream.this.readPending = false;
                        } else {
                            this.failed((Throwable)new EOFException(), attachment);
                        }
                    } else {
                        Nio2ServletInputStream.this.readPending = false;
                        if (Nio2ServletInputStream.this.interest && !Nio2Endpoint.isInline()) {
                            Nio2ServletInputStream.this.interest = false;
                            notify = true;
                        }
                    }
                }
                if (notify) {
                    Nio2ServletInputStream.this.endpoint.processSocket(attachment, SocketStatus.OPEN_READ, false);
                }
            }

            @Override
            public void failed(Throwable exc, SocketWrapper<Nio2Channel> attachment) {
                attachment.setError(true);
                Nio2ServletInputStream.this.readPending = false;
                if (exc instanceof AsynchronousCloseException) {
                    return;
                }
                Nio2ServletInputStream.this.onError(exc);
                Nio2ServletInputStream.this.endpoint.processSocket(attachment, SocketStatus.ERROR, true);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean doIsReady() throws IOException {
        CompletionHandler<Integer, SocketWrapper<Nio2Channel>> completionHandler = this.completionHandler;
        synchronized (completionHandler) {
            boolean isReady;
            if (this.readPending) {
                this.interest = true;
                return false;
            }
            ByteBuffer readBuffer = this.channel.getBufHandler().getReadBuffer();
            if (!this.flipped) {
                readBuffer.flip();
                this.flipped = true;
            }
            if (readBuffer.remaining() > 0) {
                return true;
            }
            readBuffer.clear();
            this.flipped = false;
            int nRead = this.fillReadBuffer(false);
            boolean bl = isReady = nRead > 0;
            if (isReady) {
                if (!this.flipped) {
                    readBuffer.flip();
                    this.flipped = true;
                }
            } else {
                this.interest = true;
            }
            return isReady;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int doRead(boolean block, byte[] b, int off, int len) throws IOException {
        CompletionHandler<Integer, SocketWrapper<Nio2Channel>> completionHandler = this.completionHandler;
        synchronized (completionHandler) {
            int remaining;
            if (this.readPending) {
                return 0;
            }
            ByteBuffer readBuffer = this.channel.getBufHandler().getReadBuffer();
            if (!this.flipped) {
                readBuffer.flip();
                this.flipped = true;
            }
            if ((remaining = readBuffer.remaining()) >= len) {
                readBuffer.get(b, off, len);
                return len;
            }
            int leftToWrite = len;
            int newOffset = off;
            if (remaining > 0) {
                readBuffer.get(b, off, remaining);
                leftToWrite -= remaining;
                newOffset += remaining;
            }
            readBuffer.clear();
            this.flipped = false;
            int nRead = this.fillReadBuffer(block);
            if (nRead > 0) {
                if (!this.flipped) {
                    readBuffer.flip();
                    this.flipped = true;
                }
                if (nRead > leftToWrite) {
                    readBuffer.get(b, newOffset, leftToWrite);
                    leftToWrite = 0;
                } else {
                    readBuffer.get(b, newOffset, nRead);
                    leftToWrite -= nRead;
                }
            } else if (nRead == 0) {
                if (block && !this.flipped) {
                    readBuffer.flip();
                    this.flipped = true;
                }
            } else if (nRead == -1) {
                throw new EOFException();
            }
            return len - leftToWrite;
        }
    }

    @Override
    protected void doClose() throws IOException {
        this.closed = true;
        this.channel.close();
    }

    private int fillReadBuffer(boolean block) throws IOException {
        ByteBuffer readBuffer = this.channel.getBufHandler().getReadBuffer();
        int nRead = 0;
        if (block) {
            this.readPending = true;
            readBuffer.clear();
            this.flipped = false;
            Future<Integer> future = null;
            try {
                future = this.channel.read(readBuffer);
                nRead = future.get(this.wrapper.getTimeout(), TimeUnit.MILLISECONDS);
                this.readPending = false;
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof IOException) {
                    this.onError(e.getCause());
                    throw (IOException)e.getCause();
                }
                this.onError(e);
                throw new IOException(e);
            }
            catch (InterruptedException e) {
                this.onError(e);
                throw new IOException(e);
            }
            catch (TimeoutException e) {
                future.cancel(true);
                SocketTimeoutException ex = new SocketTimeoutException();
                this.onError(ex);
                throw ex;
            }
        } else {
            this.readPending = true;
            readBuffer.clear();
            this.flipped = false;
            Nio2Endpoint.startInline();
            this.channel.read(readBuffer, this.wrapper.getTimeout(), TimeUnit.MILLISECONDS, this.wrapper, this.completionHandler);
            Nio2Endpoint.endInline();
            if (!this.readPending) {
                nRead = readBuffer.position();
            }
        }
        return nRead;
    }
}

