/*
 * Decompiled with CFR 0.152.
 */
package de.foltin;

public final class StringEncoder {
    private static final String HEXDIGITS = "0123456789abcdef";

    private StringEncoder() {
    }

    public static String encode(String value) {
        if (value == null) {
            return value;
        }
        StringBuilder buf = new StringBuilder(value.length() + 4);
        int limit = value.length();
        for (int i = 0; i < limit; ++i) {
            char ch = value.charAt(i);
            if (ch == '\\') {
                buf.append('\\');
                buf.append('\\');
                continue;
            }
            if (StringEncoder.isValidXMLChar(ch)) {
                buf.append(ch);
                continue;
            }
            buf.append('\\');
            buf.append('u');
            for (int shift = 12; shift >= 0; shift -= 4) {
                buf.append(HEXDIGITS.charAt(ch >> shift & 0xF));
            }
        }
        return buf.toString();
    }

    public static String decode(String text) {
        if (text == null) {
            return null;
        }
        StringBuilder buf = new StringBuilder(text.length());
        int limit = text.length();
        for (int i = 0; i < limit; ++i) {
            char ch = text.charAt(i);
            if (ch != '\\') {
                buf.append(ch);
                continue;
            }
            if (++i >= limit) {
                throw new IllegalArgumentException("illegal trailing '\\' in encoded string");
            }
            ch = text.charAt(i);
            if (ch == '\\') {
                buf.append(ch);
                continue;
            }
            if (ch != 'u') {
                throw new IllegalArgumentException("illegal escape sequence '\\" + ch + "' in encoded string");
            }
            int value = 0;
            for (int j = 0; j < 4; ++j) {
                if (++i >= limit) {
                    throw new IllegalArgumentException("illegal truncated '\\u' escape sequence in encoded string");
                }
                int nibble = Character.digit(text.charAt(i), 16);
                if (nibble == -1) {
                    throw new IllegalArgumentException("illegal escape sequence '" + text.substring(i - j - 2, i - j + 4) + "' in encoded string");
                }
                value = value << 4 | nibble;
            }
            buf.append((char)value);
        }
        return buf.toString();
    }

    public static boolean isValidXMLChar(char ch) {
        return ch >= ' ' && ch <= '\ud7ff' || ch >= '\ue000' && ch <= '\ufffd';
    }
}

