/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Resources;
import freemind.main.Tools;
import freemind.view.mindmapview.MainView;
import freemind.view.mindmapview.NodeView;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;

class RootMainView
extends MainView {
    RootMainView() {
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        prefSize.width = (int)((double)prefSize.width * 1.1);
        prefSize.height *= 2;
        return prefSize;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D g = (Graphics2D)graphics;
        if (this.getNodeView().getModel() == null) {
            return;
        }
        Object renderingHint = this.getController().setEdgesRenderingHint(g);
        this.paintSelected(g);
        this.paintDragOver(g);
        g.setColor(Color.gray);
        g.setStroke(new BasicStroke(1.0f));
        g.drawOval(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        Tools.restoreAntialiasing(g, renderingHint);
        super.paint(g);
    }

    @Override
    public void paintDragOver(Graphics2D graphics) {
        int draggedOver = this.getDraggedOver();
        if (draggedOver == 1) {
            graphics.setPaint(new GradientPaint(this.getWidth() / 4, 0.0f, this.getNodeView().getMap().getBackground(), this.getWidth() * 3 / 4, 0.0f, NodeView.dragColor));
            graphics.fillRect(this.getWidth() / 4, 0, this.getWidth() - 1, this.getHeight() - 1);
        } else if (draggedOver == 3) {
            graphics.setPaint(new GradientPaint(this.getWidth() * 3 / 4, 0.0f, this.getNodeView().getMap().getBackground(), this.getWidth() / 4, 0.0f, NodeView.dragColor));
            graphics.fillRect(0, 0, this.getWidth() * 3 / 4, this.getHeight() - 1);
        }
    }

    @Override
    public void paintSelected(Graphics2D graphics) {
        if (this.getNodeView().useSelectionColors()) {
            this.paintBackground(graphics, this.getNodeView().getSelectedColor());
        } else {
            this.paintBackground(graphics, this.getNodeView().getTextBackground());
        }
    }

    @Override
    protected void paintBackground(Graphics2D graphics, Color color) {
        graphics.setColor(color);
        graphics.fillOval(1, 1, this.getWidth() - 2, this.getHeight() - 2);
    }

    @Override
    Point getLeftPoint() {
        Point in = new Point(0, this.getHeight() / 2);
        return in;
    }

    @Override
    Point getCenterPoint() {
        Point in = this.getLeftPoint();
        in.x = this.getWidth() / 2;
        return in;
    }

    @Override
    Point getRightPoint() {
        Point in = this.getLeftPoint();
        in.x = this.getWidth() - 1;
        return in;
    }

    @Override
    public void setDraggedOver(Point p) {
        this.setDraggedOver(this.dropPosition(p.getX()) ? 3 : 1);
    }

    @Override
    String getStyle() {
        return Resources.getInstance().getProperty("standardrootnodestyle");
    }

    @Override
    int getAlignment() {
        return 0;
    }

    @Override
    public int getTextWidth() {
        return super.getTextWidth() - this.getWidth() / 10;
    }

    @Override
    public int getTextX() {
        return this.getIconWidth() + this.getWidth() / 20;
    }

    @Override
    public boolean dropAsSibling(double xCoord) {
        return false;
    }

    @Override
    public boolean dropPosition(double xCoord) {
        return xCoord < (double)(this.getSize().width * 1 / 2);
    }
}

