/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.bsh;

import java.lang.reflect.Array;
import org.gjt.sp.jedit.bsh.CallStack;
import org.gjt.sp.jedit.bsh.EvalError;
import org.gjt.sp.jedit.bsh.Interpreter;
import org.gjt.sp.jedit.bsh.Primitive;
import org.gjt.sp.jedit.bsh.Reflect;
import org.gjt.sp.jedit.bsh.SimpleNode;
import org.gjt.sp.jedit.bsh.Types;
import org.gjt.sp.jedit.bsh.UtilEvalError;

class BSHArrayInitializer
extends SimpleNode {
    BSHArrayInitializer(int n) {
        super(n);
    }

    @Override
    public Object eval(CallStack callStack, Interpreter interpreter) throws EvalError {
        throw new EvalError("Array initializer has no base type.", this, callStack);
    }

    public Object eval(Class clazz, int n, CallStack callStack, Interpreter interpreter) throws EvalError {
        int n2 = this.jjtGetNumChildren();
        int[] nArray = new int[n];
        nArray[0] = n2;
        Object object = Array.newInstance(clazz, nArray);
        for (int i = 0; i < n2; ++i) {
            Object object2;
            SimpleNode simpleNode = (SimpleNode)this.jjtGetChild(i);
            if (simpleNode instanceof BSHArrayInitializer) {
                if (n < 2) {
                    throw new EvalError("Invalid Location for Intializer, position: " + i, this, callStack);
                }
                object2 = ((BSHArrayInitializer)simpleNode).eval(clazz, n - 1, callStack, interpreter);
            } else {
                object2 = simpleNode.eval(callStack, interpreter);
            }
            if (object2 == Primitive.VOID) {
                throw new EvalError("Void in array initializer, position" + i, this, callStack);
            }
            Object object3 = object2;
            if (n == 1) {
                try {
                    object3 = Types.castObject(object2, clazz, 0);
                }
                catch (UtilEvalError utilEvalError) {
                    throw utilEvalError.toEvalError("Error in array initializer", this, callStack);
                }
                object3 = Primitive.unwrap(object3);
            }
            try {
                Array.set(object, i, object3);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Interpreter.debug("illegal arg" + illegalArgumentException);
                this.throwTypeError(clazz, object2, i, callStack);
                continue;
            }
            catch (ArrayStoreException arrayStoreException) {
                Interpreter.debug("arraystore" + arrayStoreException);
                this.throwTypeError(clazz, object2, i, callStack);
            }
        }
        return object;
    }

    private void throwTypeError(Class clazz, Object object, int n, CallStack callStack) throws EvalError {
        String string = object instanceof Primitive ? ((Primitive)object).getType().getName() : Reflect.normalizeClassName(object.getClass());
        throw new EvalError("Incompatible type: " + string + " in initializer of array type: " + clazz + " at position: " + n, this, callStack);
    }
}

