/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.api.nodes;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerOptions;
import com.oracle.truffle.api.ExecutionContext;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.impl.DefaultCompilerOptions;
import com.oracle.truffle.api.nodes.LoopNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;

public abstract class RootNode
extends Node {
    final Class<? extends TruffleLanguage> language;
    private RootCallTarget callTarget;
    @CompilerDirectives.CompilationFinal
    private FrameDescriptor frameDescriptor;
    private final SourceSection sourceSection;

    protected RootNode(Class<? extends TruffleLanguage> language, SourceSection sourceSection, FrameDescriptor frameDescriptor) {
        this(language, sourceSection, frameDescriptor, true);
    }

    private RootNode(Class<? extends TruffleLanguage> language, SourceSection sourceSection, FrameDescriptor frameDescriptor, boolean checkLanguage) {
        if (checkLanguage && !TruffleLanguage.class.isAssignableFrom(language)) {
            throw new IllegalStateException();
        }
        this.sourceSection = sourceSection;
        this.language = language;
        this.frameDescriptor = frameDescriptor == null ? new FrameDescriptor() : frameDescriptor;
    }

    @Override
    public Node copy() {
        RootNode root = (RootNode)super.copy();
        root.frameDescriptor = this.frameDescriptor;
        return root;
    }

    @Override
    public SourceSection getSourceSection() {
        return this.sourceSection;
    }

    public String getName() {
        return null;
    }

    public boolean isCloningAllowed() {
        return false;
    }

    @Deprecated
    public final void reportLoopCount(int iterations) {
        LoopNode.reportLoopCount(this, iterations);
    }

    public abstract Object execute(VirtualFrame var1);

    public final RootCallTarget getCallTarget() {
        return this.callTarget;
    }

    public final FrameDescriptor getFrameDescriptor() {
        return this.frameDescriptor;
    }

    public final void setCallTarget(RootCallTarget callTarget) {
        this.callTarget = callTarget;
    }

    public ExecutionContext getExecutionContext() {
        return null;
    }

    public CompilerOptions getCompilerOptions() {
        ExecutionContext context = this.getExecutionContext();
        if (context == null) {
            return DefaultCompilerOptions.INSTANCE;
        }
        return context.getCompilerOptions();
    }

    @Deprecated
    public final void applyInstrumentation() {
        if (this.isInstrumentable()) {
            Node.ACCESSOR.probeAST(this);
        }
    }

    protected boolean isInstrumentable() {
        return true;
    }

    public static RootNode createConstantNode(Object constant) {
        return new Constant(constant);
    }

    private static final class Constant
    extends RootNode {
        private final Object value;

        Constant(Object value) {
            super(TruffleLanguage.class, null, null);
            this.value = value;
        }

        @Override
        public Object execute(VirtualFrame frame) {
            return this.value;
        }
    }
}

