/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.queue;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.queue.SizedQueueNodes;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=SizedQueueNodes.class)
public final class SizedQueueNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AllocateNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), SetMaxNodeFactory.getInstance(), MaxNodeFactory.getInstance(), PushNodeFactory.getInstance(), PopNodeFactory.getInstance(), EmptyNodeFactory.getInstance(), SizeNodeFactory.getInstance(), ClearNodeFactory.getInstance(), NumWaitingNodeFactory.getInstance());
    }

    @GeneratedBy(value=SizedQueueNodes.NumWaitingNode.class)
    public static final class NumWaitingNodeFactory
    extends NodeFactoryBase<SizedQueueNodes.NumWaitingNode> {
        private static NumWaitingNodeFactory numWaitingNodeFactoryInstance;

        private NumWaitingNodeFactory() {
            super(SizedQueueNodes.NumWaitingNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public SizedQueueNodes.NumWaitingNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return NumWaitingNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SizedQueueNodes.NumWaitingNode> getInstance() {
            if (numWaitingNodeFactoryInstance == null) {
                numWaitingNodeFactoryInstance = new NumWaitingNodeFactory();
            }
            return numWaitingNodeFactoryInstance;
        }

        public static SizedQueueNodes.NumWaitingNode create(RubyNode[] arguments) {
            return new NumWaitingNodeGen(arguments);
        }

        @GeneratedBy(value=SizedQueueNodes.NumWaitingNode.class)
        public static final class NumWaitingNodeGen
        extends SizedQueueNodes.NumWaitingNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private NumWaitingNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.num_waiting(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=SizedQueueNodes.ClearNode.class)
    public static final class ClearNodeFactory
    extends NodeFactoryBase<SizedQueueNodes.ClearNode> {
        private static ClearNodeFactory clearNodeFactoryInstance;

        private ClearNodeFactory() {
            super(SizedQueueNodes.ClearNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public SizedQueueNodes.ClearNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ClearNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SizedQueueNodes.ClearNode> getInstance() {
            if (clearNodeFactoryInstance == null) {
                clearNodeFactoryInstance = new ClearNodeFactory();
            }
            return clearNodeFactoryInstance;
        }

        public static SizedQueueNodes.ClearNode create(RubyNode[] arguments) {
            return new ClearNodeGen(arguments);
        }

        @GeneratedBy(value=SizedQueueNodes.ClearNode.class)
        public static final class ClearNodeGen
        extends SizedQueueNodes.ClearNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ClearNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.clear(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=SizedQueueNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<SizedQueueNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(SizedQueueNodes.SizeNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public SizedQueueNodes.SizeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SizeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SizedQueueNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        public static SizedQueueNodes.SizeNode create(RubyNode[] arguments) {
            return new SizeNodeGen(arguments);
        }

        @GeneratedBy(value=SizedQueueNodes.SizeNode.class)
        public static final class SizeNodeGen
        extends SizedQueueNodes.SizeNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private SizeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.size(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=SizedQueueNodes.EmptyNode.class)
    public static final class EmptyNodeFactory
    extends NodeFactoryBase<SizedQueueNodes.EmptyNode> {
        private static EmptyNodeFactory emptyNodeFactoryInstance;

        private EmptyNodeFactory() {
            super(SizedQueueNodes.EmptyNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public SizedQueueNodes.EmptyNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EmptyNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SizedQueueNodes.EmptyNode> getInstance() {
            if (emptyNodeFactoryInstance == null) {
                emptyNodeFactoryInstance = new EmptyNodeFactory();
            }
            return emptyNodeFactoryInstance;
        }

        public static SizedQueueNodes.EmptyNode create(RubyNode[] arguments) {
            return new EmptyNodeGen(arguments);
        }

        @GeneratedBy(value=SizedQueueNodes.EmptyNode.class)
        public static final class EmptyNodeGen
        extends SizedQueueNodes.EmptyNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private EmptyNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeBoolean(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeBoolean(frameValue);
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.empty(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=SizedQueueNodes.PopNode.class)
    public static final class PopNodeFactory
    extends NodeFactoryBase<SizedQueueNodes.PopNode> {
        private static PopNodeFactory popNodeFactoryInstance;

        private PopNodeFactory() {
            super(SizedQueueNodes.PopNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode.class, RubyNode.class}});
        }

        @Override
        public SizedQueueNodes.PopNode createNode(Object ... arguments) {
            if (arguments.length == 2 && (arguments[0] == null || arguments[0] instanceof RubyNode) && (arguments[1] == null || arguments[1] instanceof RubyNode)) {
                return PopNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SizedQueueNodes.PopNode> getInstance() {
            if (popNodeFactoryInstance == null) {
                popNodeFactoryInstance = new PopNodeFactory();
            }
            return popNodeFactoryInstance;
        }

        public static SizedQueueNodes.PopNode create(RubyNode queue, RubyNode nonBlocking) {
            return new PopNodeGen(queue, nonBlocking);
        }

        @GeneratedBy(value=SizedQueueNodes.PopNode.class)
        public static final class PopNodeGen
        extends SizedQueueNodes.PopNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode queue_;
            @Node.Child
            private RubyNode nonBlocking_;
            @CompilerDirectives.CompilationFinal
            private Class<?> nonBlockingType_;
            @Node.Child
            private BaseNode_ specialization_;

            private PopNodeGen(RubyNode queue, RubyNode nonBlocking) {
                this.queue_ = queue;
                this.nonBlocking_ = this.coerceToBoolean(nonBlocking);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="popNonBlock(DynamicObject, boolean, BranchProfile)", value=SizedQueueNodes.PopNode.class)
            private static final class PopNonBlockNode_
            extends BaseNode_ {
                private final BranchProfile errorProfile;

                PopNonBlockNode_(PopNodeGen root, BranchProfile errorProfile) {
                    super(root, 2);
                    this.errorProfile = errorProfile;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    boolean nonBlockingValue_;
                    DynamicObject queueValue_;
                    try {
                        queueValue_ = this.root.queue_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object nonBlockingValue = this.executeNonBlocking_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), nonBlockingValue);
                    }
                    try {
                        nonBlockingValue_ = this.root.nonBlocking_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, queueValue_, ex.getResult());
                    }
                    if (nonBlockingValue_) {
                        return this.root.popNonBlock(queueValue_, nonBlockingValue_, this.errorProfile);
                    }
                    return this.getNext().execute_(frameValue, queueValue_, nonBlockingValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object queueValue, Object nonBlockingValue) {
                    if (queueValue instanceof DynamicObject && nonBlockingValue instanceof Boolean) {
                        DynamicObject queueValue_ = (DynamicObject)queueValue;
                        boolean nonBlockingValue_ = (Boolean)nonBlockingValue;
                        if (nonBlockingValue_) {
                            return this.root.popNonBlock(queueValue_, nonBlockingValue_, this.errorProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, queueValue, nonBlockingValue);
                }

                static BaseNode_ create(PopNodeGen root, BranchProfile errorProfile) {
                    return new PopNonBlockNode_(root, errorProfile);
                }
            }

            @GeneratedBy(methodName="popBlocking(DynamicObject, boolean)", value=SizedQueueNodes.PopNode.class)
            private static final class PopBlockingNode_
            extends BaseNode_ {
                PopBlockingNode_(PopNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    boolean nonBlockingValue_;
                    DynamicObject queueValue_;
                    try {
                        queueValue_ = this.root.queue_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object nonBlockingValue = this.executeNonBlocking_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), nonBlockingValue);
                    }
                    try {
                        nonBlockingValue_ = this.root.nonBlocking_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, queueValue_, ex.getResult());
                    }
                    if (!nonBlockingValue_) {
                        return this.root.popBlocking(queueValue_, nonBlockingValue_);
                    }
                    return this.getNext().execute_(frameValue, queueValue_, nonBlockingValue_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object queueValue, Object nonBlockingValue) {
                    if (queueValue instanceof DynamicObject && nonBlockingValue instanceof Boolean) {
                        DynamicObject queueValue_ = (DynamicObject)queueValue;
                        boolean nonBlockingValue_ = (Boolean)nonBlockingValue;
                        if (!nonBlockingValue_) {
                            return this.root.popBlocking(queueValue_, nonBlockingValue_);
                        }
                    }
                    return this.getNext().execute_(frameValue, queueValue, nonBlockingValue);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PopBlockingNode_(root);
                }
            }

            @GeneratedBy(value=SizedQueueNodes.PopNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PopNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object queueValue, Object nonBlockingValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, queueValue, nonBlockingValue));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object queueValue, Object nonBlockingValue) {
                    return this.getNext().execute_(frameValue, queueValue, nonBlockingValue);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=SizedQueueNodes.PopNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PopNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object queueValue, Object nonBlockingValue) {
                    return this.uninitialized((Frame)frameValue, queueValue, nonBlockingValue);
                }

                static BaseNode_ create(PopNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=SizedQueueNodes.PopNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PopNodeGen root;

                BaseNode_(PopNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (PopNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.queue_, this.root.nonBlocking_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object queueValue, Object nonBlockingValue) {
                    return this.execute_((VirtualFrame)frameValue, queueValue, nonBlockingValue);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object queueValue_ = this.root.queue_.execute(frameValue);
                    Object nonBlockingValue_ = this.executeNonBlocking_(frameValue);
                    return this.execute_(frameValue, queueValue_, nonBlockingValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object queueValue, Object nonBlockingValue) {
                    if (queueValue instanceof DynamicObject && nonBlockingValue instanceof Boolean) {
                        boolean nonBlockingValue_ = (Boolean)nonBlockingValue;
                        if (!nonBlockingValue_) {
                            return PopBlockingNode_.create(this.root);
                        }
                        BranchProfile errorProfile2 = BranchProfile.create();
                        return PopNonBlockNode_.create(this.root, errorProfile2);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeNonBlocking_(Frame frameValue) {
                    Object object;
                    Class nonBlockingType_ = this.root.nonBlockingType_;
                    if (nonBlockingType_ == Boolean.TYPE) {
                        return this.root.nonBlocking_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (nonBlockingType_ != null) return this.root.nonBlocking_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.nonBlocking_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.nonBlockingType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.nonBlockingType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.nonBlockingType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=SizedQueueNodes.PushNode.class)
    public static final class PushNodeFactory
    extends NodeFactoryBase<SizedQueueNodes.PushNode> {
        private static PushNodeFactory pushNodeFactoryInstance;

        private PushNodeFactory() {
            super(SizedQueueNodes.PushNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode.class, RubyNode.class, RubyNode.class}});
        }

        @Override
        public SizedQueueNodes.PushNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyNode) || arguments[1] != null && !(arguments[1] instanceof RubyNode) || arguments[2] != null && !(arguments[2] instanceof RubyNode))) {
                return PushNodeFactory.create((RubyNode)arguments[0], (RubyNode)arguments[1], (RubyNode)arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SizedQueueNodes.PushNode> getInstance() {
            if (pushNodeFactoryInstance == null) {
                pushNodeFactoryInstance = new PushNodeFactory();
            }
            return pushNodeFactoryInstance;
        }

        public static SizedQueueNodes.PushNode create(RubyNode queue, RubyNode value, RubyNode nonBlocking) {
            return new PushNodeGen(queue, value, nonBlocking);
        }

        @GeneratedBy(value=SizedQueueNodes.PushNode.class)
        public static final class PushNodeGen
        extends SizedQueueNodes.PushNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode queue_;
            @Node.Child
            private RubyNode value_;
            @Node.Child
            private RubyNode nonBlocking_;
            @CompilerDirectives.CompilationFinal
            private Class<?> nonBlockingType_;
            @Node.Child
            private BaseNode_ specialization_;

            private PushNodeGen(RubyNode queue, RubyNode value, RubyNode nonBlocking) {
                this.queue_ = queue;
                this.value_ = value;
                this.nonBlocking_ = this.coerceToBoolean(nonBlocking);
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="pushNonBlock(DynamicObject, Object, boolean, BranchProfile)", value=SizedQueueNodes.PushNode.class)
            private static final class PushNonBlockNode_
            extends BaseNode_ {
                private final BranchProfile errorProfile;

                PushNonBlockNode_(PushNodeGen root, BranchProfile errorProfile) {
                    super(root, 2);
                    this.errorProfile = errorProfile;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    boolean nonBlockingValue_;
                    DynamicObject queueValue_;
                    try {
                        queueValue_ = this.root.queue_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object valueValue = this.root.value_.execute(frameValue);
                        Object nonBlockingValue = this.executeNonBlocking_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), valueValue, nonBlockingValue);
                    }
                    Object valueValue_ = this.root.value_.execute(frameValue);
                    try {
                        nonBlockingValue_ = this.root.nonBlocking_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, queueValue_, valueValue_, ex.getResult());
                    }
                    if (nonBlockingValue_) {
                        return this.root.pushNonBlock(queueValue_, valueValue_, nonBlockingValue_, this.errorProfile);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, queueValue_, valueValue_, nonBlockingValue_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object queueValue, Object valueValue, Object nonBlockingValue) {
                    if (queueValue instanceof DynamicObject && nonBlockingValue instanceof Boolean) {
                        DynamicObject queueValue_ = (DynamicObject)queueValue;
                        boolean nonBlockingValue_ = (Boolean)nonBlockingValue;
                        if (nonBlockingValue_) {
                            return this.root.pushNonBlock(queueValue_, valueValue, nonBlockingValue_, this.errorProfile);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, queueValue, valueValue, nonBlockingValue);
                }

                static BaseNode_ create(PushNodeGen root, BranchProfile errorProfile) {
                    return new PushNonBlockNode_(root, errorProfile);
                }
            }

            @GeneratedBy(methodName="pushBlocking(DynamicObject, Object, boolean)", value=SizedQueueNodes.PushNode.class)
            private static final class PushBlockingNode_
            extends BaseNode_ {
                PushBlockingNode_(PushNodeGen root) {
                    super(root, 1);
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    boolean nonBlockingValue_;
                    DynamicObject queueValue_;
                    try {
                        queueValue_ = this.root.queue_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object valueValue = this.root.value_.execute(frameValue);
                        Object nonBlockingValue = this.executeNonBlocking_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), valueValue, nonBlockingValue);
                    }
                    Object valueValue_ = this.root.value_.execute(frameValue);
                    try {
                        nonBlockingValue_ = this.root.nonBlocking_.executeBoolean(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, queueValue_, valueValue_, ex.getResult());
                    }
                    if (!nonBlockingValue_) {
                        return this.root.pushBlocking(queueValue_, valueValue_, nonBlockingValue_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, queueValue_, valueValue_, nonBlockingValue_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object queueValue, Object valueValue, Object nonBlockingValue) {
                    if (queueValue instanceof DynamicObject && nonBlockingValue instanceof Boolean) {
                        DynamicObject queueValue_ = (DynamicObject)queueValue;
                        boolean nonBlockingValue_ = (Boolean)nonBlockingValue;
                        if (!nonBlockingValue_) {
                            return this.root.pushBlocking(queueValue_, valueValue, nonBlockingValue_);
                        }
                    }
                    return this.getNext().executeDynamicObject_(frameValue, queueValue, valueValue, nonBlockingValue);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PushBlockingNode_(root);
                }
            }

            @GeneratedBy(value=SizedQueueNodes.PushNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(PushNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object queueValue, Object valueValue, Object nonBlockingValue) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, queueValue, valueValue, nonBlockingValue));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object queueValue, Object valueValue, Object nonBlockingValue) {
                    return this.getNext().executeDynamicObject_(frameValue, queueValue, valueValue, nonBlockingValue);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=SizedQueueNodes.PushNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(PushNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object queueValue, Object valueValue, Object nonBlockingValue) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, queueValue, valueValue, nonBlockingValue);
                }

                static BaseNode_ create(PushNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=SizedQueueNodes.PushNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected PushNodeGen root;

                BaseNode_(PushNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (PushNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.queue_, this.root.value_, this.root.nonBlocking_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object queueValue, Object valueValue, Object nonBlockingValue) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, queueValue, valueValue, nonBlockingValue);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object queueValue_ = this.root.queue_.execute(frameValue);
                    Object valueValue_ = this.root.value_.execute(frameValue);
                    Object nonBlockingValue_ = this.executeNonBlocking_(frameValue);
                    return this.executeDynamicObject_(frameValue, queueValue_, valueValue_, nonBlockingValue_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object queueValue, Object valueValue, Object nonBlockingValue) {
                    if (queueValue instanceof DynamicObject && nonBlockingValue instanceof Boolean) {
                        boolean nonBlockingValue_ = (Boolean)nonBlockingValue;
                        if (!nonBlockingValue_) {
                            return PushBlockingNode_.create(this.root);
                        }
                        BranchProfile errorProfile2 = BranchProfile.create();
                        return PushNonBlockNode_.create(this.root, errorProfile2);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeNonBlocking_(Frame frameValue) {
                    Object object;
                    Class nonBlockingType_ = this.root.nonBlockingType_;
                    if (nonBlockingType_ == Boolean.TYPE) {
                        return this.root.nonBlocking_.executeBoolean((VirtualFrame)frameValue);
                    }
                    if (nonBlockingType_ != null) return this.root.nonBlocking_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.nonBlocking_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Boolean ? Boolean.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.nonBlockingType_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.nonBlockingType_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.nonBlockingType_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=SizedQueueNodes.MaxNode.class)
    public static final class MaxNodeFactory
    extends NodeFactoryBase<SizedQueueNodes.MaxNode> {
        private static MaxNodeFactory maxNodeFactoryInstance;

        private MaxNodeFactory() {
            super(SizedQueueNodes.MaxNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public SizedQueueNodes.MaxNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return MaxNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SizedQueueNodes.MaxNode> getInstance() {
            if (maxNodeFactoryInstance == null) {
                maxNodeFactoryInstance = new MaxNodeFactory();
            }
            return maxNodeFactoryInstance;
        }

        public static SizedQueueNodes.MaxNode create(RubyNode[] arguments) {
            return new MaxNodeGen(arguments);
        }

        @GeneratedBy(value=SizedQueueNodes.MaxNode.class)
        public static final class MaxNodeGen
        extends SizedQueueNodes.MaxNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private MaxNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.max(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=SizedQueueNodes.SetMaxNode.class)
    public static final class SetMaxNodeFactory
    extends NodeFactoryBase<SizedQueueNodes.SetMaxNode> {
        private static SetMaxNodeFactory setMaxNodeFactoryInstance;

        private SetMaxNodeFactory() {
            super(SizedQueueNodes.SetMaxNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public SizedQueueNodes.SetMaxNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return SetMaxNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SizedQueueNodes.SetMaxNode> getInstance() {
            if (setMaxNodeFactoryInstance == null) {
                setMaxNodeFactoryInstance = new SetMaxNodeFactory();
            }
            return setMaxNodeFactoryInstance;
        }

        public static SizedQueueNodes.SetMaxNode create(RubyNode[] arguments) {
            return new SetMaxNodeGen(arguments);
        }

        @GeneratedBy(value=SizedQueueNodes.SetMaxNode.class)
        public static final class SetMaxNodeGen
        extends SizedQueueNodes.SetMaxNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private SetMaxNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                return this.specialization_.executeInt(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="setMax(DynamicObject, int)", value=SizedQueueNodes.SetMaxNode.class)
            private static final class SetMaxNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                SetMaxNode_(SetMaxNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((SetMaxNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeInt(frameValue);
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeInt_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeInt_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.setMax(arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.setMax(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SetMaxNodeGen root, Object arguments1Value) {
                    return new SetMaxNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=SizedQueueNodes.SetMaxNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(SetMaxNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public int executeInt(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.getNext().executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeInt_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SetMaxNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=SizedQueueNodes.SetMaxNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(SetMaxNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public int executeInt_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (Integer)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(SetMaxNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=SizedQueueNodes.SetMaxNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected SetMaxNodeGen root;

                BaseNode_(SetMaxNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (SetMaxNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeInt_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract int executeInt_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeInt_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public int executeInt(VirtualFrame frameValue) {
                    return (Integer)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value)) {
                        return SetMaxNode_.create(this.root, arguments1Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=SizedQueueNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<SizedQueueNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(SizedQueueNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public SizedQueueNodes.InitializeNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return InitializeNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SizedQueueNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        public static SizedQueueNodes.InitializeNode create(RubyNode[] arguments) {
            return new InitializeNodeGen(arguments);
        }

        @GeneratedBy(value=SizedQueueNodes.InitializeNode.class)
        public static final class InitializeNodeGen
        extends SizedQueueNodes.InitializeNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private InitializeNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                return this.specialization_.executeDynamicObject(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="initialize(DynamicObject, int)", value=SizedQueueNodes.InitializeNode.class)
            private static final class InitializeNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                InitializeNode_(InitializeNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((InitializeNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    return this.executeDynamicObject(frameValue);
                }

                @Override
                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().executeDynamicObject_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().executeDynamicObject_(frameValue, arguments0Value_, ex.getResult());
                    }
                    return this.root.initialize(arguments0Value_, arguments1Value_);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        return this.root.initialize(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root, Object arguments1Value) {
                    return new InitializeNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=SizedQueueNodes.InitializeNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(InitializeNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().executeDynamicObject_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=SizedQueueNodes.InitializeNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(InitializeNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public DynamicObject executeDynamicObject_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return (DynamicObject)this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(InitializeNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=SizedQueueNodes.InitializeNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected InitializeNodeGen root;

                BaseNode_(InitializeNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (InitializeNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.executeDynamicObject_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract DynamicObject executeDynamicObject_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.executeDynamicObject_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                public DynamicObject executeDynamicObject(VirtualFrame frameValue) {
                    return (DynamicObject)this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value)) {
                        return InitializeNode_.create(this.root, arguments1Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=SizedQueueNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<SizedQueueNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(SizedQueueNodes.AllocateNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public SizedQueueNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return AllocateNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<SizedQueueNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static SizedQueueNodes.AllocateNode create(RubyNode[] arguments) {
            return new AllocateNodeGen(arguments);
        }

        @GeneratedBy(value=SizedQueueNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends SizedQueueNodes.AllocateNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }
}

