/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;
import org.apache.log4j.Logger;

public abstract class PagingTableModel<T>
extends AbstractTableModel {
    private static final long serialVersionUID = -6353414328926478100L;
    private static final Logger logger = Logger.getLogger(PagingTableModel.class);
    public static final String DEFAULT_SEGMENT_LOADER_THREAD_NAME = "ZAP-PagingTableModel-SegmentLoaderThread";
    public static final int DEFAULT_MAX_PAGE_SIZE = 50;
    private int maxPageSize;
    private int dataOffset = 0;
    private List<T> data = Collections.emptyList();
    private SortedSet<Segment> pending = new TreeSet<Segment>();
    private final String segmentLoaderThreadName;

    public PagingTableModel() {
        this(DEFAULT_SEGMENT_LOADER_THREAD_NAME, 50);
    }

    public PagingTableModel(String string) {
        this(string, 50);
    }

    public PagingTableModel(int n) {
        this(DEFAULT_SEGMENT_LOADER_THREAD_NAME, n);
    }

    public PagingTableModel(String string, int n) {
        this.segmentLoaderThreadName = string;
        this.setMaxPageSizeWithoutPageChanges(n);
    }

    public int getMaxPageSize() {
        return this.maxPageSize;
    }

    public void setMaxPageSize(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Parameter maxPageSize must be greater than zero.");
        }
        if (this.maxPageSize == n) {
            return;
        }
        int n2 = this.maxPageSize;
        this.setMaxPageSizeWithoutPageChanges(n);
        int n3 = this.getRowCount();
        if (n3 > 0) {
            if (n > n2) {
                this.schedule(this.dataOffset);
            } else if (this.data.size() > n) {
                final List<T> list = this.data.subList(0, n);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PagingTableModel.this.setData(PagingTableModel.this.dataOffset, new ArrayList(list));
                    }
                });
            }
        }
    }

    public void setMaxPageSizeWithoutPageChanges(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Parameter maxPageSize must be greater than zero.");
        }
        this.maxPageSize = n;
    }

    @Override
    public void fireTableDataChanged() {
        this.clear();
        super.fireTableDataChanged();
    }

    @Override
    public abstract int getRowCount();

    protected abstract Object getRealValueAt(T var1, int var2);

    protected abstract Object getPlaceholderValueAt(int var1);

    protected abstract List<T> loadPage(int var1, int var2);

    @Override
    public final Object getValueAt(int n, int n2) {
        T t = this.getRowObject(n);
        if (t == null) {
            this.schedule(n);
            return this.getPlaceholderValueAt(n2);
        }
        return this.getRealValueAt(t, n2);
    }

    protected T getRowObject(int n) {
        int n2 = n - this.dataOffset;
        if (n2 >= 0 && n2 < this.data.size()) {
            return this.data.get(n2);
        }
        return null;
    }

    private void schedule(int n) {
        if (this.isPending(n)) {
            return;
        }
        int n2 = Math.max(0, n - this.maxPageSize / 2);
        int n3 = n + this.maxPageSize / 2 - n2;
        this.load(n2, n3);
    }

    private boolean isPending(int n) {
        int n2 = this.pending.size();
        if (n2 == 0) {
            return false;
        }
        if (n2 == 1) {
            Segment segment = this.pending.first();
            return segment.contains(n);
        }
        Segment segment = new Segment(n - this.maxPageSize, 0);
        Segment segment2 = new Segment(n + 1, 0);
        for (Segment segment3 : this.pending.subSet(segment, segment2)) {
            if (!segment3.contains(n)) continue;
            return true;
        }
        return false;
    }

    private void load(int n, int n2) {
        Segment segment = new Segment(n, n2);
        this.pending.add(segment);
        SegmentLoaderThread segmentLoaderThread = new SegmentLoaderThread(segment, this.segmentLoaderThreadName);
        segmentLoaderThread.start();
    }

    private void setData(int n, List<T> list) {
        int n2 = n + list.size() - 1;
        this.dataOffset = n;
        this.data = list;
        this.fireTableRowsUpdated(n, n2);
    }

    protected void clear() {
        this.data.clear();
        this.data = Collections.emptyList();
        this.pending.clear();
    }

    private class SegmentLoaderThread
    extends Thread {
        private final Segment segment;

        public SegmentLoaderThread(Segment segment, String string) {
            super(string);
            this.segment = segment;
        }

        @Override
        public void run() {
            List list;
            try {
                list = PagingTableModel.this.loadPage(this.segment.getBase(), this.segment.getLength());
            }
            catch (Exception exception) {
                logger.warn((Object)("error retrieving page at " + this.segment.getBase() + ": aborting"), (Throwable)exception);
                PagingTableModel.this.pending.remove(this.segment);
                return;
            }
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PagingTableModel.this.setData(SegmentLoaderThread.this.segment.getBase(), list);
                    PagingTableModel.this.pending.remove(SegmentLoaderThread.this.segment);
                }
            });
        }
    }

    static final class Segment
    implements Comparable<Segment> {
        private final int base;
        private final int length;

        public Segment(int n, int n2) {
            this.base = n;
            this.length = n2;
        }

        public int getBase() {
            return this.base;
        }

        public int getLength() {
            return this.length;
        }

        public boolean contains(int n) {
            return this.base <= n && n < this.base + this.length;
        }

        public boolean equals(Object object) {
            if (object != null && object instanceof Segment) {
                Segment segment = (Segment)object;
                boolean bl = this.base == segment.base;
                boolean bl2 = this.length == segment.length;
                return bl && bl2;
            }
            return false;
        }

        public int hashCode() {
            return 41 * (41 + this.base) + this.length;
        }

        @Override
        public int compareTo(Segment segment) {
            int n = this.base - segment.base;
            if (n != 0) {
                return n;
            }
            return this.length - segment.length;
        }
    }
}

