/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.handler;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataContentHandler;
import javax.activation.DataSource;
import javax.activation.UnsupportedDataTypeException;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;

public class Multipart
implements DataContentHandler {
    protected DataFlavor flavor;

    public Multipart() {
        this("multipart/*", "multipart");
    }

    public Multipart(String mimeType, String description) {
        this.flavor = new ActivationDataFlavor(MimeMultipart.class, mimeType, description);
    }

    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[]{this.flavor};
        return flavors;
    }

    public Object getTransferData(DataFlavor flavor, DataSource source) throws UnsupportedFlavorException, IOException {
        if (this.flavor.equals(flavor)) {
            return this.getContent(source);
        }
        return null;
    }

    public Object getContent(DataSource source) throws IOException {
        try {
            return new MimeMultipart(source);
        }
        catch (MessagingException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void writeTo(Object object, String mimeType, OutputStream out) throws IOException {
        if (object instanceof MimeMultipart) {
            try {
                ((MimeMultipart)object).writeTo(out);
            }
            catch (MessagingException e) {
                throw new IOException(e.getMessage());
            }
        } else {
            throw new UnsupportedDataTypeException();
        }
    }
}

