/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo3d;

import org.apache.lucene.geo3d.PlanetModel;
import org.apache.lucene.geo3d.StandardXYZSolid;
import org.apache.lucene.geo3d.XYZSolid;
import org.apache.lucene.geo3d.XYdZSolid;
import org.apache.lucene.geo3d.XdYZSolid;
import org.apache.lucene.geo3d.XdYdZSolid;
import org.apache.lucene.geo3d.dXYZSolid;
import org.apache.lucene.geo3d.dXYdZSolid;
import org.apache.lucene.geo3d.dXdYZSolid;
import org.apache.lucene.geo3d.dXdYdZSolid;

public class XYZSolidFactory {
    private XYZSolidFactory() {
    }

    public static XYZSolid makeXYZSolid(PlanetModel planetModel, double minX, double maxX, double minY, double maxY, double minZ, double maxZ) {
        if (Math.abs(maxX - minX) < 1.0E-12) {
            if (Math.abs(maxY - minY) < 1.0E-12) {
                if (Math.abs(maxZ - minZ) < 1.0E-12) {
                    return new dXdYdZSolid(planetModel, (minX + maxX) * 0.5, (minY + maxY) * 0.5, minZ);
                }
                return new dXdYZSolid(planetModel, (minX + maxX) * 0.5, (minY + maxY) * 0.5, minZ, maxZ);
            }
            if (Math.abs(maxZ - minZ) < 1.0E-12) {
                return new dXYdZSolid(planetModel, (minX + maxX) * 0.5, minY, maxY, (minZ + maxZ) * 0.5);
            }
            return new dXYZSolid(planetModel, (minX + maxX) * 0.5, minY, maxY, minZ, maxZ);
        }
        if (Math.abs(maxY - minY) < 1.0E-12) {
            if (Math.abs(maxZ - minZ) < 1.0E-12) {
                return new XdYdZSolid(planetModel, minX, maxX, (minY + maxY) * 0.5, (minZ + maxZ) * 0.5);
            }
            return new XdYZSolid(planetModel, minX, maxX, (minY + maxY) * 0.5, minZ, maxZ);
        }
        if (Math.abs(maxZ - minZ) < 1.0E-12) {
            return new XYdZSolid(planetModel, minX, maxX, minY, maxY, (minZ + maxZ) * 0.5);
        }
        return new StandardXYZSolid(planetModel, minX, maxX, minY, maxY, minZ, maxZ);
    }
}

