/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.SegmentInfos;
import org.elasticsearch.common.Base64;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.lucene.Lucene;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;

public final class CommitStats
implements Streamable,
ToXContent {
    private Map<String, String> userData;
    private long generation;
    private String id;
    private int numDocs;

    public CommitStats(SegmentInfos segmentInfos) {
        this.userData = MapBuilder.newMapBuilder().putAll(segmentInfos.getUserData()).immutableMap();
        this.generation = segmentInfos.getLastGeneration();
        if (segmentInfos.getId() != null) {
            this.id = Base64.encodeBytes(segmentInfos.getId());
        }
        this.numDocs = Lucene.getNumDocs(segmentInfos);
    }

    private CommitStats() {
    }

    public static CommitStats readCommitStatsFrom(StreamInput in) throws IOException {
        CommitStats commitStats = new CommitStats();
        commitStats.readFrom(in);
        return commitStats;
    }

    public static CommitStats readOptionalCommitStatsFrom(StreamInput in) throws IOException {
        return in.readOptionalStreamable(new CommitStats());
    }

    public Map<String, String> getUserData() {
        return this.userData;
    }

    public long getGeneration() {
        return this.generation;
    }

    public String getId() {
        return this.id;
    }

    public int getNumDocs() {
        return this.numDocs;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        MapBuilder<String, String> builder = MapBuilder.newMapBuilder();
        for (int i = in.readVInt(); i > 0; --i) {
            builder.put(in.readString(), in.readString());
        }
        this.userData = builder.immutableMap();
        this.generation = in.readLong();
        this.id = in.readOptionalString();
        this.numDocs = in.readInt();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVInt(this.userData.size());
        for (Map.Entry<String, String> entry : this.userData.entrySet()) {
            out.writeString(entry.getKey());
            out.writeString(entry.getValue());
        }
        out.writeLong(this.generation);
        out.writeOptionalString(this.id);
        out.writeInt(this.numDocs);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(Fields.COMMIT);
        builder.field(Fields.ID, this.id);
        builder.field(Fields.GENERATION, this.generation);
        builder.field(Fields.USER_DATA, (Object)this.userData);
        builder.field(Fields.NUM_DOCS, this.numDocs);
        builder.endObject();
        return builder;
    }

    static final class Fields {
        static final XContentBuilderString GENERATION = new XContentBuilderString("generation");
        static final XContentBuilderString USER_DATA = new XContentBuilderString("user_data");
        static final XContentBuilderString ID = new XContentBuilderString("id");
        static final XContentBuilderString COMMIT = new XContentBuilderString("commit");
        static final XContentBuilderString NUM_DOCS = new XContentBuilderString("num_docs");

        Fields() {
        }
    }
}

