/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.filters;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationStreams;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.InternalMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.BucketStreamContext;
import org.elasticsearch.search.aggregations.bucket.BucketStreams;
import org.elasticsearch.search.aggregations.bucket.filters.Filters;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public class InternalFilters
extends InternalMultiBucketAggregation<InternalFilters, Bucket>
implements Filters {
    public static final InternalAggregation.Type TYPE = new InternalAggregation.Type("filters");
    private static final AggregationStreams.Stream STREAM = new AggregationStreams.Stream(){

        @Override
        public InternalFilters readResult(StreamInput in) throws IOException {
            InternalFilters filters = new InternalFilters();
            filters.readFrom(in);
            return filters;
        }
    };
    private static final BucketStreams.Stream<Bucket> BUCKET_STREAM = new BucketStreams.Stream<Bucket>(){

        @Override
        public Bucket readResult(StreamInput in, BucketStreamContext context) throws IOException {
            Bucket filters = new Bucket(context.keyed());
            filters.readFrom(in);
            return filters;
        }

        @Override
        public BucketStreamContext getBucketStreamContext(Bucket bucket) {
            BucketStreamContext context = new BucketStreamContext();
            context.keyed(bucket.keyed);
            return context;
        }
    };
    private List<Bucket> buckets;
    private Map<String, Bucket> bucketMap;
    private boolean keyed;

    public static void registerStream() {
        AggregationStreams.registerStream(STREAM, TYPE.stream());
        BucketStreams.registerStream(BUCKET_STREAM, TYPE.stream());
    }

    public InternalFilters() {
    }

    public InternalFilters(String name, List<Bucket> buckets, boolean keyed, List<PipelineAggregator> pipelineAggregators, Map<String, Object> metaData) {
        super(name, pipelineAggregators, metaData);
        this.buckets = buckets;
        this.keyed = keyed;
    }

    @Override
    public InternalAggregation.Type type() {
        return TYPE;
    }

    @Override
    public InternalFilters create(List<Bucket> buckets) {
        return new InternalFilters(this.name, buckets, this.keyed, this.pipelineAggregators(), this.metaData);
    }

    @Override
    public Bucket createBucket(InternalAggregations aggregations, Bucket prototype) {
        return new Bucket(prototype.key, prototype.docCount, aggregations, prototype.keyed);
    }

    public List<Bucket> getBuckets() {
        return this.buckets;
    }

    @Override
    public Bucket getBucketByKey(String key) {
        if (this.bucketMap == null) {
            this.bucketMap = new HashMap<String, Bucket>(this.buckets.size());
            for (Bucket bucket : this.buckets) {
                this.bucketMap.put(bucket.getKey(), bucket);
            }
        }
        return this.bucketMap.get(key);
    }

    @Override
    public InternalAggregation doReduce(List<InternalAggregation> aggregations, InternalAggregation.ReduceContext reduceContext) {
        ArrayList bucketsList = null;
        for (InternalAggregation aggregation : aggregations) {
            InternalFilters internalFilters = (InternalFilters)aggregation;
            if (bucketsList == null) {
                bucketsList = new ArrayList(internalFilters.buckets.size());
                for (Bucket bucket : internalFilters.buckets) {
                    ArrayList<Bucket> sameRangeList = new ArrayList<Bucket>(aggregations.size());
                    sameRangeList.add(bucket);
                    bucketsList.add(sameRangeList);
                }
                continue;
            }
            int i = 0;
            for (Bucket bucket : internalFilters.buckets) {
                ((List)bucketsList.get(i++)).add(bucket);
            }
        }
        InternalFilters reduced = new InternalFilters(this.name, new ArrayList<Bucket>(bucketsList.size()), this.keyed, this.pipelineAggregators(), this.getMetaData());
        for (List list : bucketsList) {
            reduced.buckets.add(((Bucket)list.get(0)).reduce(list, reduceContext));
        }
        return reduced;
    }

    @Override
    protected void doReadFrom(StreamInput in) throws IOException {
        this.keyed = in.readBoolean();
        int size = in.readVInt();
        ArrayList<Bucket> buckets = new ArrayList<Bucket>(size);
        for (int i = 0; i < size; ++i) {
            Bucket bucket = new Bucket(this.keyed);
            bucket.readFrom(in);
            buckets.add(bucket);
        }
        this.buckets = buckets;
        this.bucketMap = null;
    }

    @Override
    protected void doWriteTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.keyed);
        out.writeVInt(this.buckets.size());
        for (Bucket bucket : this.buckets) {
            bucket.writeTo(out);
        }
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.keyed) {
            builder.startObject(InternalAggregation.CommonFields.BUCKETS);
        } else {
            builder.startArray(InternalAggregation.CommonFields.BUCKETS);
        }
        for (Bucket bucket : this.buckets) {
            bucket.toXContent(builder, params);
        }
        if (this.keyed) {
            builder.endObject();
        } else {
            builder.endArray();
        }
        return builder;
    }

    public static class Bucket
    extends InternalMultiBucketAggregation.InternalBucket
    implements Filters.Bucket {
        private final boolean keyed;
        private String key;
        private long docCount;
        InternalAggregations aggregations;

        private Bucket(boolean keyed) {
            this.keyed = keyed;
        }

        public Bucket(String key, long docCount, InternalAggregations aggregations, boolean keyed) {
            this.key = key;
            this.docCount = docCount;
            this.aggregations = aggregations;
            this.keyed = keyed;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            return this.key;
        }

        @Override
        public long getDocCount() {
            return this.docCount;
        }

        @Override
        public Aggregations getAggregations() {
            return this.aggregations;
        }

        Bucket reduce(List<Bucket> buckets, InternalAggregation.ReduceContext context) {
            Bucket reduced = null;
            ArrayList<InternalAggregations> aggregationsList = new ArrayList<InternalAggregations>(buckets.size());
            for (Bucket bucket : buckets) {
                if (reduced == null) {
                    reduced = new Bucket(bucket.key, bucket.docCount, bucket.aggregations, bucket.keyed);
                } else {
                    reduced.docCount += bucket.docCount;
                }
                aggregationsList.add(bucket.aggregations);
            }
            reduced.aggregations = InternalAggregations.reduce(aggregationsList, context);
            return reduced;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            if (this.keyed) {
                builder.startObject(this.key);
            } else {
                builder.startObject();
            }
            builder.field(InternalAggregation.CommonFields.DOC_COUNT, this.docCount);
            this.aggregations.toXContentInternal(builder, params);
            builder.endObject();
            return builder;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.key = in.readOptionalString();
            this.docCount = in.readVLong();
            this.aggregations = InternalAggregations.readAggregations(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalString(this.key);
            out.writeVLong(this.docCount);
            this.aggregations.writeTo(out);
        }
    }
}

