/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.jcs.access.CacheAccess;
import org.apache.commons.jcs.access.behavior.ICacheAccess;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractTMSTileSource;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.cache.BufferedImageCacheEntry;
import org.openstreetmap.josm.data.cache.JCSCacheManager;
import org.openstreetmap.josm.data.imagery.CachedTileLoaderFactory;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.data.imagery.TileLoaderFactory;
import org.openstreetmap.josm.data.preferences.IntegerProperty;
import org.openstreetmap.josm.gui.layer.AbstractTileSourceLayer;

public abstract class AbstractCachedTileSourceLayer<T extends AbstractTMSTileSource>
extends AbstractTileSourceLayer<T> {
    private static Map<String, TileLoaderFactory> loaderFactories = new ConcurrentHashMap<String, TileLoaderFactory>();
    private static final String PREFERENCE_PREFIX = "imagery.cache.";
    private static volatile TileLoaderFactory loaderFactoryOverride;
    public static final IntegerProperty MAX_DISK_CACHE_SIZE;
    private ICacheAccess<String, BufferedImageCacheEntry> cache;
    private volatile TileLoaderFactory loaderFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AbstractCachedTileSourceLayer(ImageryInfo imageryInfo) {
        super(imageryInfo);
        if (loaderFactoryOverride != null) {
            this.loaderFactory = loaderFactoryOverride;
            return;
        }
        String string = this.getClass().getCanonicalName();
        this.loaderFactory = loaderFactories.get(string);
        if (this.loaderFactory != null) return;
        Class<AbstractCachedTileSourceLayer> clazz = AbstractCachedTileSourceLayer.class;
        synchronized (AbstractCachedTileSourceLayer.class) {
            this.loaderFactory = loaderFactories.get(string);
            if (this.loaderFactory != null) return;
            this.loaderFactory = new CachedTileLoaderFactory(this.getCache(), this.getTileLoaderClass());
            loaderFactories.put(string, this.loaderFactory);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    protected synchronized TileLoaderFactory getTileLoaderFactory() {
        if (this.loaderFactory == null) {
            this.loaderFactory = new CachedTileLoaderFactory(this.getCache(), this.getTileLoaderClass());
        }
        return this.loaderFactory;
    }

    private synchronized ICacheAccess<String, BufferedImageCacheEntry> getCache() {
        if (this.cache != null) {
            return this.cache;
        }
        try {
            this.cache = JCSCacheManager.getCache(this.getCacheName(), 0, this.getDiskCacheSize(), CachedTileLoaderFactory.PROP_TILECACHE_DIR.get());
            return this.cache;
        }
        catch (IOException iOException) {
            Main.warn(iOException);
            return null;
        }
    }

    public static synchronized void setTileLoaderFactory(TileLoaderFactory tileLoaderFactory) {
        loaderFactoryOverride = tileLoaderFactory;
    }

    public static TileLoaderFactory getTileLoaderFactory(String string, Class<? extends TileLoader> clazz) {
        return new CachedTileLoaderFactory(AbstractCachedTileSourceLayer.getCache(string), clazz);
    }

    public static CacheAccess<String, BufferedImageCacheEntry> getCache(String string) {
        try {
            return JCSCacheManager.getCache(string, 0, MAX_DISK_CACHE_SIZE.get() * 1024, CachedTileLoaderFactory.PROP_TILECACHE_DIR.get());
        }
        catch (IOException iOException) {
            Main.warn(iOException);
            return null;
        }
    }

    protected abstract Class<? extends TileLoader> getTileLoaderClass();

    protected int getDiskCacheSize() {
        return MAX_DISK_CACHE_SIZE.get() * 1024;
    }

    protected abstract String getCacheName();

    static {
        MAX_DISK_CACHE_SIZE = new IntegerProperty("imagery.cache.max_disk_size", 512);
    }
}

