/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.regexp;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.dsl.internal.SpecializationNode;
import com.oracle.truffle.api.dsl.internal.SpecializedNode;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.profiles.BranchProfile;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.builtins.CoreMethodNode;
import org.jruby.truffle.core.regexp.MatchDataNodes;
import org.jruby.truffle.language.NotProvided;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.language.RubyNode;
import org.jruby.truffle.language.RubyTypesGen;

@GeneratedBy(value=MatchDataNodes.class)
public final class MatchDataNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(GetIndexNodeFactory.getInstance(), BeginNodeFactory.getInstance(), CapturesNodeFactory.getInstance(), EndNodeFactory.getInstance(), ByteBeginNodeFactory.getInstance(), ByteEndNodeFactory.getInstance(), LengthNodeFactory.getInstance(), PreMatchNodeFactory.getInstance(), PostMatchNodeFactory.getInstance(), ToANodeFactory.getInstance(), ToSNodeFactory.getInstance(), RegexpNodeFactory.getInstance(), AllocateNodeFactory.getInstance());
    }

    @GeneratedBy(value=MatchDataNodes.RubiniusSourceNode.class)
    public static final class RubiniusSourceNodeGen
    extends MatchDataNodes.RubiniusSourceNode {
        @Node.Child
        private RubyNode self_;
        @CompilerDirectives.CompilationFinal
        private boolean seenUnsupported0;

        private RubiniusSourceNodeGen(RubyNode self) {
            this.self_ = self;
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MONOMORPHIC;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            DynamicObject selfValue_;
            try {
                selfValue_ = this.self_.executeDynamicObject(frameValue);
            }
            catch (UnexpectedResultException ex) {
                throw this.unsupported(ex.getResult());
            }
            return this.rubiniusSource(selfValue_);
        }

        @Override
        public void executeVoid(VirtualFrame frameValue) {
            this.execute(frameValue);
        }

        private UnsupportedSpecializationException unsupported(Object selfValue) {
            if (!this.seenUnsupported0) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.seenUnsupported0 = true;
            }
            return new UnsupportedSpecializationException(this, new Node[]{this.self_}, selfValue);
        }

        public static MatchDataNodes.RubiniusSourceNode create(RubyNode self) {
            return new RubiniusSourceNodeGen(self);
        }
    }

    @GeneratedBy(value=MatchDataNodes.AllocateNode.class)
    public static final class AllocateNodeFactory
    extends NodeFactoryBase<MatchDataNodes.AllocateNode> {
        private static AllocateNodeFactory allocateNodeFactoryInstance;

        private AllocateNodeFactory() {
            super(MatchDataNodes.AllocateNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode.class}});
        }

        @Override
        public MatchDataNodes.AllocateNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode)) {
                return AllocateNodeFactory.create((RubyNode)arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MatchDataNodes.AllocateNode> getInstance() {
            if (allocateNodeFactoryInstance == null) {
                allocateNodeFactoryInstance = new AllocateNodeFactory();
            }
            return allocateNodeFactoryInstance;
        }

        public static MatchDataNodes.AllocateNode create(RubyNode operand) {
            return new AllocateNodeGen(operand);
        }

        @GeneratedBy(value=MatchDataNodes.AllocateNode.class)
        public static final class AllocateNodeGen
        extends MatchDataNodes.AllocateNode {
            @Node.Child
            private RubyNode operand_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private AllocateNodeGen(RubyNode operand) {
                this.operand_ = operand;
            }

            @Override
            public RubyNode getOperand() {
                return this.operand_;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject operandValue_;
                try {
                    operandValue_ = this.operand_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.allocate(operandValue_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object operandValue) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.operand_}, operandValue);
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.RegexpNode.class)
    public static final class RegexpNodeFactory
    extends NodeFactoryBase<MatchDataNodes.RegexpNode> {
        private static RegexpNodeFactory regexpNodeFactoryInstance;

        private RegexpNodeFactory() {
            super(MatchDataNodes.RegexpNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public MatchDataNodes.RegexpNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return RegexpNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MatchDataNodes.RegexpNode> getInstance() {
            if (regexpNodeFactoryInstance == null) {
                regexpNodeFactoryInstance = new RegexpNodeFactory();
            }
            return regexpNodeFactoryInstance;
        }

        public static MatchDataNodes.RegexpNode create(RubyNode[] arguments) {
            return new RegexpNodeGen(arguments);
        }

        @GeneratedBy(value=MatchDataNodes.RegexpNode.class)
        public static final class RegexpNodeGen
        extends MatchDataNodes.RegexpNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private RegexpNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.regexp(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.ToSNode.class)
    public static final class ToSNodeFactory
    extends NodeFactoryBase<MatchDataNodes.ToSNode> {
        private static ToSNodeFactory toSNodeFactoryInstance;

        private ToSNodeFactory() {
            super(MatchDataNodes.ToSNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public MatchDataNodes.ToSNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ToSNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MatchDataNodes.ToSNode> getInstance() {
            if (toSNodeFactoryInstance == null) {
                toSNodeFactoryInstance = new ToSNodeFactory();
            }
            return toSNodeFactoryInstance;
        }

        public static MatchDataNodes.ToSNode create(RubyNode[] arguments) {
            return new ToSNodeGen(arguments);
        }

        @GeneratedBy(value=MatchDataNodes.ToSNode.class)
        public static final class ToSNodeGen
        extends MatchDataNodes.ToSNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ToSNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toS(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.ToANode.class)
    public static final class ToANodeFactory
    extends NodeFactoryBase<MatchDataNodes.ToANode> {
        private static ToANodeFactory toANodeFactoryInstance;

        private ToANodeFactory() {
            super(MatchDataNodes.ToANode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public MatchDataNodes.ToANode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ToANodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MatchDataNodes.ToANode> getInstance() {
            if (toANodeFactoryInstance == null) {
                toANodeFactoryInstance = new ToANodeFactory();
            }
            return toANodeFactoryInstance;
        }

        public static MatchDataNodes.ToANode create(RubyNode[] arguments) {
            return new ToANodeGen(arguments);
        }

        @GeneratedBy(value=MatchDataNodes.ToANode.class)
        public static final class ToANodeGen
        extends MatchDataNodes.ToANode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private ToANodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toA(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.PostMatchNode.class)
    public static final class PostMatchNodeFactory
    extends NodeFactoryBase<MatchDataNodes.PostMatchNode> {
        private static PostMatchNodeFactory postMatchNodeFactoryInstance;

        private PostMatchNodeFactory() {
            super(MatchDataNodes.PostMatchNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MatchDataNodes.PostMatchNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PostMatchNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MatchDataNodes.PostMatchNode> getInstance() {
            if (postMatchNodeFactoryInstance == null) {
                postMatchNodeFactoryInstance = new PostMatchNodeFactory();
            }
            return postMatchNodeFactoryInstance;
        }

        public static MatchDataNodes.PostMatchNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PostMatchNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MatchDataNodes.PostMatchNode.class)
        public static final class PostMatchNodeGen
        extends MatchDataNodes.PostMatchNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PostMatchNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.postMatch(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.PreMatchNode.class)
    public static final class PreMatchNodeFactory
    extends NodeFactoryBase<MatchDataNodes.PreMatchNode> {
        private static PreMatchNodeFactory preMatchNodeFactoryInstance;

        private PreMatchNodeFactory() {
            super(MatchDataNodes.PreMatchNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        @Override
        public MatchDataNodes.PreMatchNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PreMatchNodeFactory.create((RubyContext)arguments[0], (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MatchDataNodes.PreMatchNode> getInstance() {
            if (preMatchNodeFactoryInstance == null) {
                preMatchNodeFactoryInstance = new PreMatchNodeFactory();
            }
            return preMatchNodeFactoryInstance;
        }

        public static MatchDataNodes.PreMatchNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return new PreMatchNodeGen(context, sourceSection, arguments);
        }

        @GeneratedBy(value=MatchDataNodes.PreMatchNode.class)
        public static final class PreMatchNodeGen
        extends MatchDataNodes.PreMatchNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private PreMatchNodeGen(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.preMatch(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.LengthNode.class)
    public static final class LengthNodeFactory
    extends NodeFactoryBase<MatchDataNodes.LengthNode> {
        private static LengthNodeFactory lengthNodeFactoryInstance;

        private LengthNodeFactory() {
            super(MatchDataNodes.LengthNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public MatchDataNodes.LengthNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return LengthNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MatchDataNodes.LengthNode> getInstance() {
            if (lengthNodeFactoryInstance == null) {
                lengthNodeFactoryInstance = new LengthNodeFactory();
            }
            return lengthNodeFactoryInstance;
        }

        public static MatchDataNodes.LengthNode create(RubyNode[] arguments) {
            return new LengthNodeGen(arguments);
        }

        @GeneratedBy(value=MatchDataNodes.LengthNode.class)
        public static final class LengthNodeGen
        extends MatchDataNodes.LengthNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private LengthNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.executeInteger(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.executeInteger(frameValue);
            }

            @Override
            public int executeInteger(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.length(arguments0Value_);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.ByteEndNode.class)
    public static final class ByteEndNodeFactory
    extends NodeFactoryBase<MatchDataNodes.ByteEndNode> {
        private static ByteEndNodeFactory byteEndNodeFactoryInstance;

        private ByteEndNodeFactory() {
            super(MatchDataNodes.ByteEndNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public MatchDataNodes.ByteEndNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ByteEndNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MatchDataNodes.ByteEndNode> getInstance() {
            if (byteEndNodeFactoryInstance == null) {
                byteEndNodeFactoryInstance = new ByteEndNodeFactory();
            }
            return byteEndNodeFactoryInstance;
        }

        public static MatchDataNodes.ByteEndNode create(RubyNode[] arguments) {
            return new ByteEndNodeGen(arguments);
        }

        @GeneratedBy(value=MatchDataNodes.ByteEndNode.class)
        public static final class ByteEndNodeGen
        extends MatchDataNodes.ByteEndNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ByteEndNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="byteEnd(DynamicObject, int)", value=MatchDataNodes.ByteEndNode.class)
            private static final class ByteEndNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                ByteEndNode_(ByteEndNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((ByteEndNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (this.root.inBounds(arguments0Value_, arguments1Value_)) {
                        return this.root.byteEnd(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && this.root.inBounds(arguments0Value_ = (DynamicObject)arguments0Value, arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType))) {
                        return this.root.byteEnd(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ByteEndNodeGen root, Object arguments1Value) {
                    return new ByteEndNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=MatchDataNodes.ByteEndNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ByteEndNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ByteEndNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MatchDataNodes.ByteEndNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ByteEndNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ByteEndNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MatchDataNodes.ByteEndNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ByteEndNodeGen root;

                BaseNode_(ByteEndNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ByteEndNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value) && this.root.inBounds(arguments0Value_ = (DynamicObject)arguments0Value, arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value))) {
                        return ByteEndNode_.create(this.root, arguments1Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.ByteBeginNode.class)
    public static final class ByteBeginNodeFactory
    extends NodeFactoryBase<MatchDataNodes.ByteBeginNode> {
        private static ByteBeginNodeFactory byteBeginNodeFactoryInstance;

        private ByteBeginNodeFactory() {
            super(MatchDataNodes.ByteBeginNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public MatchDataNodes.ByteBeginNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return ByteBeginNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MatchDataNodes.ByteBeginNode> getInstance() {
            if (byteBeginNodeFactoryInstance == null) {
                byteBeginNodeFactoryInstance = new ByteBeginNodeFactory();
            }
            return byteBeginNodeFactoryInstance;
        }

        public static MatchDataNodes.ByteBeginNode create(RubyNode[] arguments) {
            return new ByteBeginNodeGen(arguments);
        }

        @GeneratedBy(value=MatchDataNodes.ByteBeginNode.class)
        public static final class ByteBeginNodeGen
        extends MatchDataNodes.ByteBeginNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private ByteBeginNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="byteBegin(DynamicObject, int)", value=MatchDataNodes.ByteBeginNode.class)
            private static final class ByteBeginNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                ByteBeginNode_(ByteBeginNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((ByteBeginNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (this.root.inBounds(arguments0Value_, arguments1Value_)) {
                        return this.root.byteBegin(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && this.root.inBounds(arguments0Value_ = (DynamicObject)arguments0Value, arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType))) {
                        return this.root.byteBegin(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ByteBeginNodeGen root, Object arguments1Value) {
                    return new ByteBeginNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=MatchDataNodes.ByteBeginNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(ByteBeginNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ByteBeginNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MatchDataNodes.ByteBeginNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(ByteBeginNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(ByteBeginNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MatchDataNodes.ByteBeginNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected ByteBeginNodeGen root;

                BaseNode_(ByteBeginNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (ByteBeginNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value) && this.root.inBounds(arguments0Value_ = (DynamicObject)arguments0Value, arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value))) {
                        return ByteBeginNode_.create(this.root, arguments1Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.EndNode.class)
    public static final class EndNodeFactory
    extends NodeFactoryBase<MatchDataNodes.EndNode> {
        private static EndNodeFactory endNodeFactoryInstance;

        private EndNodeFactory() {
            super(MatchDataNodes.EndNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public MatchDataNodes.EndNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return EndNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MatchDataNodes.EndNode> getInstance() {
            if (endNodeFactoryInstance == null) {
                endNodeFactoryInstance = new EndNodeFactory();
            }
            return endNodeFactoryInstance;
        }

        public static MatchDataNodes.EndNode create(RubyNode[] arguments) {
            return new EndNodeGen(arguments);
        }

        @GeneratedBy(value=MatchDataNodes.EndNode.class)
        public static final class EndNodeGen
        extends MatchDataNodes.EndNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private EndNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="endError(DynamicObject, int)", value=MatchDataNodes.EndNode.class)
            private static final class EndErrorNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                EndErrorNode_(EndNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((EndErrorNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!this.root.inBounds(arguments0Value_, arguments1Value_)) {
                        return this.root.endError(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && !this.root.inBounds(arguments0Value_ = (DynamicObject)arguments0Value, arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType))) {
                        return this.root.endError(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EndNodeGen root, Object arguments1Value) {
                    return new EndErrorNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="end(DynamicObject, int)", value=MatchDataNodes.EndNode.class)
            private static final class EndNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                EndNode_(EndNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((EndNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (this.root.inBounds(arguments0Value_, arguments1Value_)) {
                        return this.root.end(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && this.root.inBounds(arguments0Value_ = (DynamicObject)arguments0Value, arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType))) {
                        return this.root.end(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EndNodeGen root, Object arguments1Value) {
                    return new EndNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=MatchDataNodes.EndNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(EndNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EndNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MatchDataNodes.EndNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(EndNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(EndNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MatchDataNodes.EndNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected EndNodeGen root;

                BaseNode_(EndNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (EndNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value);
                        if (this.root.inBounds(arguments0Value_, arguments1Value_)) {
                            return EndNode_.create(this.root, arguments1Value);
                        }
                        return EndErrorNode_.create(this.root, arguments1Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.CapturesNode.class)
    public static final class CapturesNodeFactory
    extends NodeFactoryBase<MatchDataNodes.CapturesNode> {
        private static CapturesNodeFactory capturesNodeFactoryInstance;

        private CapturesNodeFactory() {
            super(MatchDataNodes.CapturesNode.class, new Class[]{RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public MatchDataNodes.CapturesNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return CapturesNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MatchDataNodes.CapturesNode> getInstance() {
            if (capturesNodeFactoryInstance == null) {
                capturesNodeFactoryInstance = new CapturesNodeFactory();
            }
            return capturesNodeFactoryInstance;
        }

        public static MatchDataNodes.CapturesNode create(RubyNode[] arguments) {
            return new CapturesNodeGen(arguments);
        }

        @GeneratedBy(value=MatchDataNodes.CapturesNode.class)
        public static final class CapturesNodeGen
        extends MatchDataNodes.CapturesNode {
            @Node.Child
            private RubyNode arguments0_;
            @CompilerDirectives.CompilationFinal
            private boolean seenUnsupported0;

            private CapturesNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                DynamicObject arguments0Value_;
                try {
                    arguments0Value_ = this.arguments0_.executeDynamicObject(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    throw this.unsupported(ex.getResult());
                }
                return this.toA(arguments0Value_);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.execute(frameValue);
            }

            private UnsupportedSpecializationException unsupported(Object arguments0Value) {
                if (!this.seenUnsupported0) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.seenUnsupported0 = true;
                }
                return new UnsupportedSpecializationException(this, new Node[]{this.arguments0_}, arguments0Value);
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.BeginNode.class)
    public static final class BeginNodeFactory
    extends NodeFactoryBase<MatchDataNodes.BeginNode> {
        private static BeginNodeFactory beginNodeFactoryInstance;

        private BeginNodeFactory() {
            super(MatchDataNodes.BeginNode.class, new Class[]{RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public MatchDataNodes.BeginNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return BeginNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MatchDataNodes.BeginNode> getInstance() {
            if (beginNodeFactoryInstance == null) {
                beginNodeFactoryInstance = new BeginNodeFactory();
            }
            return beginNodeFactoryInstance;
        }

        public static MatchDataNodes.BeginNode create(RubyNode[] arguments) {
            return new BeginNodeGen(arguments);
        }

        @GeneratedBy(value=MatchDataNodes.BeginNode.class)
        public static final class BeginNodeGen
        extends MatchDataNodes.BeginNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private BeginNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="beginError(DynamicObject, int)", value=MatchDataNodes.BeginNode.class)
            private static final class BeginErrorNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                BeginErrorNode_(BeginNodeGen root, Object arguments1Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((BeginErrorNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (!this.root.inBounds(arguments0Value_, arguments1Value_)) {
                        return this.root.beginError(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && !this.root.inBounds(arguments0Value_ = (DynamicObject)arguments0Value, arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType))) {
                        return this.root.beginError(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BeginNodeGen root, Object arguments1Value) {
                    return new BeginErrorNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(methodName="begin(DynamicObject, int)", value=MatchDataNodes.BeginNode.class)
            private static final class BeginNode_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;

                BeginNode_(BeginNodeGen root, Object arguments1Value) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((BeginNode_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult());
                    }
                    if (this.root.inBounds(arguments0Value_, arguments1Value_)) {
                        return this.root.begin(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && this.root.inBounds(arguments0Value_ = (DynamicObject)arguments0Value, arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType))) {
                        return this.root.begin(arguments0Value_, arguments1Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BeginNodeGen root, Object arguments1Value) {
                    return new BeginNode_(root, arguments1Value);
                }
            }

            @GeneratedBy(value=MatchDataNodes.BeginNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(BeginNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BeginNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MatchDataNodes.BeginNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(BeginNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value);
                }

                static BaseNode_ create(BeginNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MatchDataNodes.BeginNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected BeginNodeGen root;

                BaseNode_(BeginNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (BeginNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value);
                        if (this.root.inBounds(arguments0Value_, arguments1Value_)) {
                            return BeginNode_.create(this.root, arguments1Value);
                        }
                        return BeginErrorNode_.create(this.root, arguments1Value);
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }
            }
        }
    }

    @GeneratedBy(value=MatchDataNodes.GetIndexNode.class)
    public static final class GetIndexNodeFactory
    extends NodeFactoryBase<MatchDataNodes.GetIndexNode> {
        private static GetIndexNodeFactory getIndexNodeFactoryInstance;

        private GetIndexNodeFactory() {
            super(MatchDataNodes.GetIndexNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, new Class[][]{{RubyNode[].class}});
        }

        @Override
        public MatchDataNodes.GetIndexNode createNode(Object ... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof RubyNode[])) {
                return GetIndexNodeFactory.create((RubyNode[])arguments[0]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static NodeFactory<MatchDataNodes.GetIndexNode> getInstance() {
            if (getIndexNodeFactoryInstance == null) {
                getIndexNodeFactoryInstance = new GetIndexNodeFactory();
            }
            return getIndexNodeFactoryInstance;
        }

        public static MatchDataNodes.GetIndexNode create(RubyNode[] arguments) {
            return new GetIndexNodeGen(arguments);
        }

        @GeneratedBy(value=MatchDataNodes.GetIndexNode.class)
        public static final class GetIndexNodeGen
        extends MatchDataNodes.GetIndexNode
        implements SpecializedNode {
            @Node.Child
            private RubyNode arguments0_;
            @Node.Child
            private RubyNode arguments1_;
            @Node.Child
            private RubyNode arguments2_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1Type_;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2Type_;
            @Node.Child
            private BaseNode_ specialization_;

            private GetIndexNodeGen(RubyNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
                this.arguments2_ = arguments != null && 2 < arguments.length ? arguments[2] : null;
                this.specialization_ = UninitializedNode_.create(this);
            }

            @Override
            public NodeCost getCost() {
                return this.specialization_.getNodeCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                return this.specialization_.execute(frameValue);
            }

            @Override
            public void executeVoid(VirtualFrame frameValue) {
                this.specialization_.executeVoid(frameValue);
            }

            @Override
            public SpecializationNode getSpecializationNode() {
                return this.specialization_;
            }

            @Override
            public Node deepCopy() {
                return SpecializationNode.updateRoot(super.deepCopy());
            }

            @GeneratedBy(methodName="getIndex(DynamicObject, DynamicObject, NotProvided)", value=MatchDataNodes.GetIndexNode.class)
            private static final class GetIndex3Node_
            extends BaseNode_ {
                GetIndex3Node_(GetIndexNodeGen root) {
                    super(root, 6);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isIntRange(arguments1Value_)) {
                            return this.root.getIndex(arguments0Value_, arguments1Value_, arguments2Value_);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new GetIndex3Node_(root);
                }
            }

            @GeneratedBy(methodName="getIndex(VirtualFrame, DynamicObject, Object, NotProvided, ConditionProfile)", value=MatchDataNodes.GetIndexNode.class)
            private static final class GetIndex2Node_
            extends BaseNode_ {
                private final ConditionProfile indexOutOfBoundsProfile;

                GetIndex2Node_(GetIndexNodeGen root, ConditionProfile indexOutOfBoundsProfile) {
                    super(root, 5);
                    this.indexOutOfBoundsProfile = indexOutOfBoundsProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (!(RubyGuards.isRubySymbol(arguments1Value) || RubyGuards.isRubyString(arguments1Value) || RubyGuards.isIntRange(arguments1Value))) {
                            return this.root.getIndex(frameValue, arguments0Value_, arguments1Value, arguments2Value_, this.indexOutOfBoundsProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, ConditionProfile indexOutOfBoundsProfile) {
                    return new GetIndex2Node_(root, indexOutOfBoundsProfile);
                }
            }

            @GeneratedBy(methodName="getIndexString(DynamicObject, DynamicObject, NotProvided, ConditionProfile)", value=MatchDataNodes.GetIndexNode.class)
            private static final class GetIndexStringNode_
            extends BaseNode_ {
                private final ConditionProfile indexOutOfBoundsProfile;

                GetIndexStringNode_(GetIndexNodeGen root, ConditionProfile indexOutOfBoundsProfile) {
                    super(root, 4);
                    this.indexOutOfBoundsProfile = indexOutOfBoundsProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isRubyString(arguments1Value_)) {
                            return this.root.getIndexString(arguments0Value_, arguments1Value_, arguments2Value_, this.indexOutOfBoundsProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, ConditionProfile indexOutOfBoundsProfile) {
                    return new GetIndexStringNode_(root, indexOutOfBoundsProfile);
                }
            }

            @GeneratedBy(methodName="getIndexSymbol(DynamicObject, DynamicObject, NotProvided, BranchProfile, ConditionProfile)", value=MatchDataNodes.GetIndexNode.class)
            private static final class GetIndexSymbolNode_
            extends BaseNode_ {
                private final BranchProfile errorProfile;
                private final ConditionProfile indexOutOfBoundsProfile;

                GetIndexSymbolNode_(GetIndexNodeGen root, BranchProfile errorProfile, ConditionProfile indexOutOfBoundsProfile) {
                    super(root, 3);
                    this.errorProfile = errorProfile;
                    this.indexOutOfBoundsProfile = indexOutOfBoundsProfile;
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && arguments1Value instanceof DynamicObject && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        DynamicObject arguments1Value_ = (DynamicObject)arguments1Value;
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        if (RubyGuards.isRubySymbol(arguments1Value_)) {
                            return this.root.getIndexSymbol(arguments0Value_, arguments1Value_, arguments2Value_, this.errorProfile, this.indexOutOfBoundsProfile);
                        }
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, BranchProfile errorProfile, ConditionProfile indexOutOfBoundsProfile) {
                    return new GetIndexSymbolNode_(root, errorProfile, indexOutOfBoundsProfile);
                }
            }

            @GeneratedBy(methodName="getIndex(DynamicObject, int, int)", value=MatchDataNodes.GetIndexNode.class)
            private static final class GetIndex1Node_
            extends BaseNode_ {
                private final Class<?> arguments1ImplicitType;
                private final Class<?> arguments2ImplicitType;

                GetIndex1Node_(GetIndexNodeGen root, Object arguments1Value, Object arguments2Value) {
                    super(root, 2);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.arguments2ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments2Value);
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetIndex1Node_)other).arguments1ImplicitType && this.arguments2ImplicitType == ((GetIndex1Node_)other).arguments2ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    int arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        if (this.arguments2ImplicitType == Integer.TYPE) {
                            arguments2Value_ = this.root.arguments2_.executeInteger(frameValue);
                        } else {
                            Object arguments2Value__ = this.executeArguments2_(frameValue);
                            arguments2Value_ = RubyTypesGen.expectImplicitInteger(arguments2Value__, this.arguments2ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    return this.root.getIndex(arguments0Value_, arguments1Value_, arguments2Value_);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && RubyTypesGen.isImplicitInteger(arguments2Value, this.arguments2ImplicitType)) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        int arguments2Value_ = RubyTypesGen.asImplicitInteger(arguments2Value, this.arguments2ImplicitType);
                        return this.root.getIndex(arguments0Value_, arguments1Value_, arguments2Value_);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, Object arguments1Value, Object arguments2Value) {
                    return new GetIndex1Node_(root, arguments1Value, arguments2Value);
                }
            }

            @GeneratedBy(methodName="getIndex(DynamicObject, int, NotProvided, ConditionProfile)", value=MatchDataNodes.GetIndexNode.class)
            private static final class GetIndex0Node_
            extends BaseNode_ {
                private final ConditionProfile indexOutOfBoundsProfile;
                private final Class<?> arguments1ImplicitType;

                GetIndex0Node_(GetIndexNodeGen root, Object arguments1Value, ConditionProfile indexOutOfBoundsProfile) {
                    super(root, 1);
                    this.arguments1ImplicitType = RubyTypesGen.getImplicitIntegerClass(arguments1Value);
                    this.indexOutOfBoundsProfile = indexOutOfBoundsProfile;
                }

                @Override
                public boolean isSame(SpecializationNode other) {
                    return super.isSame(other) && this.arguments1ImplicitType == ((GetIndex0Node_)other).arguments1ImplicitType;
                }

                @Override
                public Object execute(VirtualFrame frameValue) {
                    NotProvided arguments2Value_;
                    int arguments1Value_;
                    DynamicObject arguments0Value_;
                    try {
                        arguments0Value_ = this.root.arguments0_.executeDynamicObject(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments1Value = this.executeArguments1_(frameValue);
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().execute_(frameValue, ex.getResult(), arguments1Value, arguments2Value);
                    }
                    try {
                        if (this.arguments1ImplicitType == Integer.TYPE) {
                            arguments1Value_ = this.root.arguments1_.executeInteger(frameValue);
                        } else {
                            Object arguments1Value__ = this.executeArguments1_(frameValue);
                            arguments1Value_ = RubyTypesGen.expectImplicitInteger(arguments1Value__, this.arguments1ImplicitType);
                        }
                    }
                    catch (UnexpectedResultException ex) {
                        Object arguments2Value = this.executeArguments2_(frameValue);
                        return this.getNext().execute_(frameValue, arguments0Value_, ex.getResult(), arguments2Value);
                    }
                    try {
                        arguments2Value_ = this.root.arguments2_.executeNotProvided(frameValue);
                    }
                    catch (UnexpectedResultException ex) {
                        return this.getNext().execute_(frameValue, arguments0Value_, arguments1Value_, ex.getResult());
                    }
                    return this.root.getIndex(arguments0Value_, arguments1Value_, arguments2Value_, this.indexOutOfBoundsProfile);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject && RubyTypesGen.isImplicitInteger(arguments1Value, this.arguments1ImplicitType) && arguments2Value instanceof NotProvided) {
                        DynamicObject arguments0Value_ = (DynamicObject)arguments0Value;
                        int arguments1Value_ = RubyTypesGen.asImplicitInteger(arguments1Value, this.arguments1ImplicitType);
                        NotProvided arguments2Value_ = (NotProvided)arguments2Value;
                        return this.root.getIndex(arguments0Value_, arguments1Value_, arguments2Value_, this.indexOutOfBoundsProfile);
                    }
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root, Object arguments1Value, ConditionProfile indexOutOfBoundsProfile) {
                    return new GetIndex0Node_(root, arguments1Value, indexOutOfBoundsProfile);
                }
            }

            @GeneratedBy(value=MatchDataNodes.GetIndexNode.class)
            private static final class PolymorphicNode_
            extends BaseNode_ {
                PolymorphicNode_(GetIndexNodeGen root) {
                    super(root, 0);
                }

                @Override
                public SpecializationNode merge(SpecializationNode newNode, Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.polymorphicMerge(newNode, super.merge(newNode, frameValue, arguments0Value, arguments1Value, arguments2Value));
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.getNext().execute_(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new PolymorphicNode_(root);
                }
            }

            @GeneratedBy(value=MatchDataNodes.GetIndexNode.class)
            private static final class UninitializedNode_
            extends BaseNode_ {
                UninitializedNode_(GetIndexNodeGen root) {
                    super(root, Integer.MAX_VALUE);
                }

                @Override
                public Object execute_(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.uninitialized((Frame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                static BaseNode_ create(GetIndexNodeGen root) {
                    return new UninitializedNode_(root);
                }
            }

            @GeneratedBy(value=MatchDataNodes.GetIndexNode.class)
            private static abstract class BaseNode_
            extends SpecializationNode {
                @CompilerDirectives.CompilationFinal
                protected GetIndexNodeGen root;

                BaseNode_(GetIndexNodeGen root, int index) {
                    super(index);
                    this.root = root;
                }

                @Override
                protected final void setRoot(Node root) {
                    this.root = (GetIndexNodeGen)root;
                }

                @Override
                protected final Node[] getSuppliedChildren() {
                    return new Node[]{this.root.arguments0_, this.root.arguments1_, this.root.arguments2_};
                }

                @Override
                public final Object acceptAndExecute(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    return this.execute_((VirtualFrame)frameValue, arguments0Value, arguments1Value, arguments2Value);
                }

                public abstract Object execute_(VirtualFrame var1, Object var2, Object var3, Object var4);

                public Object execute(VirtualFrame frameValue) {
                    Object arguments0Value_ = this.root.arguments0_.execute(frameValue);
                    Object arguments1Value_ = this.executeArguments1_(frameValue);
                    Object arguments2Value_ = this.executeArguments2_(frameValue);
                    return this.execute_(frameValue, arguments0Value_, arguments1Value_, arguments2Value_);
                }

                public void executeVoid(VirtualFrame frameValue) {
                    this.execute(frameValue);
                }

                @Override
                protected final SpecializationNode createNext(Frame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                    if (arguments0Value instanceof DynamicObject) {
                        if (RubyTypesGen.isImplicitInteger(arguments1Value)) {
                            if (arguments2Value instanceof NotProvided) {
                                ConditionProfile indexOutOfBoundsProfile1 = ConditionProfile.createBinaryProfile();
                                return GetIndex0Node_.create(this.root, arguments1Value, indexOutOfBoundsProfile1);
                            }
                            if (RubyTypesGen.isImplicitInteger(arguments2Value)) {
                                return GetIndex1Node_.create(this.root, arguments1Value, arguments2Value);
                            }
                        }
                        if (arguments2Value instanceof NotProvided) {
                            DynamicObject arguments1Value_;
                            if (arguments1Value instanceof DynamicObject) {
                                arguments1Value_ = (DynamicObject)arguments1Value;
                                if (RubyGuards.isRubySymbol(arguments1Value_)) {
                                    BranchProfile errorProfile3 = BranchProfile.create();
                                    ConditionProfile indexOutOfBoundsProfile3 = ConditionProfile.createBinaryProfile();
                                    return GetIndexSymbolNode_.create(this.root, errorProfile3, indexOutOfBoundsProfile3);
                                }
                                if (RubyGuards.isRubyString(arguments1Value_)) {
                                    ConditionProfile indexOutOfBoundsProfile4 = ConditionProfile.createBinaryProfile();
                                    return GetIndexStringNode_.create(this.root, indexOutOfBoundsProfile4);
                                }
                            }
                            if (!(RubyGuards.isRubySymbol(arguments1Value) || RubyGuards.isRubyString(arguments1Value) || RubyGuards.isIntRange(arguments1Value))) {
                                ConditionProfile indexOutOfBoundsProfile5 = ConditionProfile.createBinaryProfile();
                                return GetIndex2Node_.create(this.root, indexOutOfBoundsProfile5);
                            }
                            if (arguments1Value instanceof DynamicObject && RubyGuards.isIntRange(arguments1Value_ = (DynamicObject)arguments1Value)) {
                                return GetIndex3Node_.create(this.root);
                            }
                        }
                    }
                    return null;
                }

                @Override
                protected final SpecializationNode createPolymorphic() {
                    return PolymorphicNode_.create(this.root);
                }

                protected final BaseNode_ getNext() {
                    return (BaseNode_)this.next;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments1_(Frame frameValue) {
                    Object object;
                    Class arguments1Type_ = this.root.arguments1Type_;
                    if (arguments1Type_ == Integer.TYPE) {
                        return this.root.arguments1_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments1Type_ != null) return this.root.arguments1_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments1_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments1Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments1Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments1Type_ = _type;
                    return object;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                protected final Object executeArguments2_(Frame frameValue) {
                    Object object;
                    Class arguments2Type_ = this.root.arguments2Type_;
                    if (arguments2Type_ == Integer.TYPE) {
                        return this.root.arguments2_.executeInteger((VirtualFrame)frameValue);
                    }
                    if (arguments2Type_ != null) return this.root.arguments2_.execute((VirtualFrame)frameValue);
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    Class<Object> _type = Object.class;
                    try {
                        Object _value = this.root.arguments2_.execute((VirtualFrame)frameValue);
                        _type = _value instanceof Integer ? Integer.TYPE : Object.class;
                        object = _value;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.root.arguments2Type_ = _type;
                            throw throwable;
                        }
                        catch (UnexpectedResultException ex) {
                            this.root.arguments2Type_ = Object.class;
                            return ex.getResult();
                        }
                    }
                    this.root.arguments2Type_ = _type;
                    return object;
                }
            }
        }
    }
}

