/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.language.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.language.RubyNode;

@NodeInfo(cost=NodeCost.NONE)
public final class SequenceNode
extends RubyNode {
    @Node.Children
    private final RubyNode[] body;

    public SequenceNode(RubyContext context, SourceSection sourceSection, RubyNode ... body) {
        super(context, sourceSection);
        this.body = body;
    }

    @Override
    @ExplodeLoop
    public Object execute(VirtualFrame frame) {
        for (int n = 0; n < this.body.length - 1; ++n) {
            this.body[n].executeVoid(frame);
        }
        return this.body[this.body.length - 1].execute(frame);
    }

    @Override
    @ExplodeLoop
    public void executeVoid(VirtualFrame frame) {
        for (int n = 0; n < this.body.length; ++n) {
            this.body[n].executeVoid(frame);
        }
    }

    public RubyNode[] getSequence() {
        return this.body;
    }
}

