/*
 * Decompiled with CFR 0.152.
 */
package org.encog.parse.expression.epl;

import java.util.StringTokenizer;
import org.encog.ml.ea.exception.EACompileError;
import org.encog.ml.prg.EncogProgram;
import org.encog.ml.prg.ProgramNode;
import org.encog.ml.prg.expvalue.ExpressionValue;
import org.encog.ml.prg.extension.EncogOpcodeRegistry;
import org.encog.ml.prg.extension.ProgramExtensionTemplate;
import org.encog.util.SimpleParser;
import org.encog.util.csv.CSVFormat;
import org.encog.util.datastruct.StackObject;

public class ParseEPL {
    private final EncogProgram holder;
    private SimpleParser parser;
    private StackObject<ProgramNode> nodeStack = new StackObject(100);

    public ParseEPL(EncogProgram theHolder) {
        this.holder = theHolder;
    }

    public ProgramNode parse(String expression) {
        this.parser = new SimpleParser(expression);
        while (!this.parser.eol()) {
            this.parser.eatWhiteSpace();
            if (this.parser.readChar() != '[') {
                throw new EACompileError("Expected [");
            }
            this.parser.eatWhiteSpace();
            StringBuilder cmd = new StringBuilder();
            while (this.parser.peek() != ']' && !this.parser.eol()) {
                cmd.append(this.parser.readChar());
            }
            if (this.parser.peek() != ']') {
                throw new EACompileError("Expected ]");
            }
            this.parser.advance();
            StringTokenizer tok = new StringTokenizer(cmd.toString(), ":");
            String name = tok.nextToken();
            int childCount = Integer.parseInt(tok.nextToken());
            ProgramExtensionTemplate temp = EncogOpcodeRegistry.INSTANCE.findOpcode(name, childCount);
            if (temp == null) {
                throw new EACompileError("Invalid instruction: " + name);
            }
            ProgramNode[] args = new ProgramNode[childCount];
            for (int i = args.length - 1; i >= 0; --i) {
                args[i] = this.nodeStack.pop();
            }
            ProgramNode node = this.holder.getFunctions().factorProgramNode(name, this.holder, args);
            this.nodeStack.push(node);
            for (int i = 0; i < temp.getDataSize(); ++i) {
                String str = tok.nextToken().trim();
                int idx = str.indexOf(35);
                if (idx != -1) {
                    int enumType = Integer.parseInt(str.substring(0, idx));
                    int enumVal = Integer.parseInt(str.substring(idx + 1));
                    node.getData()[0] = new ExpressionValue(enumType, enumVal);
                    continue;
                }
                if (str.length() == 1 && "tf".indexOf(Character.toLowerCase(str.charAt(0))) != -1) {
                    node.getData()[i] = new ExpressionValue(str.equalsIgnoreCase("t"));
                    continue;
                }
                if (str.charAt(0) == '\"') {
                    node.getData()[i] = new ExpressionValue(str.substring(1, str.length() - 1));
                    continue;
                }
                if (str.indexOf(46) == -1 && str.toLowerCase().indexOf(101) == -1) {
                    long l;
                    try {
                        l = Long.parseLong(str);
                    }
                    catch (NumberFormatException ex) {
                        l = 0L;
                    }
                    node.getData()[i] = new ExpressionValue(l);
                    continue;
                }
                node.getData()[i] = new ExpressionValue(CSVFormat.EG_FORMAT.parse(str));
            }
        }
        return this.nodeStack.pop();
    }
}

