/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.jbrofuzz.encode;

public class Base32 {
    private static final String BASE32CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ234567";
    private static final int[] base32Lookup;

    static {
        int[] nArray = new int[80];
        nArray[0] = 255;
        nArray[1] = 255;
        nArray[2] = 26;
        nArray[3] = 27;
        nArray[4] = 28;
        nArray[5] = 29;
        nArray[6] = 30;
        nArray[7] = 31;
        nArray[8] = 255;
        nArray[9] = 255;
        nArray[10] = 255;
        nArray[11] = 255;
        nArray[12] = 255;
        nArray[13] = 255;
        nArray[14] = 255;
        nArray[15] = 255;
        nArray[16] = 255;
        nArray[18] = 1;
        nArray[19] = 2;
        nArray[20] = 3;
        nArray[21] = 4;
        nArray[22] = 5;
        nArray[23] = 6;
        nArray[24] = 7;
        nArray[25] = 8;
        nArray[26] = 9;
        nArray[27] = 10;
        nArray[28] = 11;
        nArray[29] = 12;
        nArray[30] = 13;
        nArray[31] = 14;
        nArray[32] = 15;
        nArray[33] = 16;
        nArray[34] = 17;
        nArray[35] = 18;
        nArray[36] = 19;
        nArray[37] = 20;
        nArray[38] = 21;
        nArray[39] = 22;
        nArray[40] = 23;
        nArray[41] = 24;
        nArray[42] = 25;
        nArray[43] = 255;
        nArray[44] = 255;
        nArray[45] = 255;
        nArray[46] = 255;
        nArray[47] = 255;
        nArray[48] = 255;
        nArray[50] = 1;
        nArray[51] = 2;
        nArray[52] = 3;
        nArray[53] = 4;
        nArray[54] = 5;
        nArray[55] = 6;
        nArray[56] = 7;
        nArray[57] = 8;
        nArray[58] = 9;
        nArray[59] = 10;
        nArray[60] = 11;
        nArray[61] = 12;
        nArray[62] = 13;
        nArray[63] = 14;
        nArray[64] = 15;
        nArray[65] = 16;
        nArray[66] = 17;
        nArray[67] = 18;
        nArray[68] = 19;
        nArray[69] = 20;
        nArray[70] = 21;
        nArray[71] = 22;
        nArray[72] = 23;
        nArray[73] = 24;
        nArray[74] = 25;
        nArray[75] = 255;
        nArray[76] = 255;
        nArray[77] = 255;
        nArray[78] = 255;
        nArray[79] = 255;
        base32Lookup = nArray;
    }

    public static String encode(byte[] bytes) {
        int i = 0;
        int index = 0;
        int digit = 0;
        int add = 0;
        switch (bytes.length) {
            case 1: {
                add = 6;
                break;
            }
            case 2: {
                add = 4;
                break;
            }
            case 3: {
                add = 3;
                break;
            }
            case 4: {
                add = 1;
            }
        }
        StringBuffer base32 = new StringBuffer((bytes.length + 7) * 8 / 5 + add);
        while (i < bytes.length) {
            int currByte;
            int n = currByte = bytes[i] >= 0 ? bytes[i] : bytes[i] + 256;
            if (index > 3) {
                int nextByte = i + 1 < bytes.length ? (bytes[i + 1] >= 0 ? bytes[i + 1] : bytes[i + 1] + 256) : 0;
                digit = currByte & 255 >> index;
                index = (index + 5) % 8;
                digit <<= index;
                digit |= nextByte >> 8 - index;
                ++i;
            } else {
                digit = currByte >> 8 - (index + 5) & 0x1F;
                if ((index = (index + 5) % 8) == 0) {
                    ++i;
                }
            }
            base32.append(BASE32CHARS.charAt(digit));
        }
        switch (bytes.length) {
            case 1: {
                base32.append("======");
                break;
            }
            case 2: {
                base32.append("====");
                break;
            }
            case 3: {
                base32.append("===");
                break;
            }
            case 4: {
                base32.append("=");
            }
        }
        return base32.toString();
    }

    public static byte[] decode(String base32) {
        byte[] bytes = new byte[base32.length() * 5 / 8];
        int i = 0;
        int index = 0;
        int offset = 0;
        while (i < base32.length()) {
            int digit;
            int lookup = base32.charAt(i) - 48;
            if (lookup >= 0 && lookup < base32Lookup.length && (digit = base32Lookup[lookup]) != 255) {
                if (index <= 3) {
                    if ((index = (index + 5) % 8) == 0) {
                        int n = offset++;
                        bytes[n] = (byte)(bytes[n] | digit);
                        if (offset >= bytes.length) {
                            break;
                        }
                    } else {
                        int n = offset;
                        bytes[n] = (byte)(bytes[n] | digit << 8 - index);
                    }
                } else {
                    index = (index + 5) % 8;
                    int n = offset++;
                    bytes[n] = (byte)(bytes[n] | digit >>> index);
                    if (offset >= bytes.length) break;
                    int n2 = offset;
                    bytes[n2] = (byte)(bytes[n2] | digit << 8 - index);
                }
            }
            ++i;
        }
        return bytes;
    }
}

