/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.AbstractPlainDatagramSocketImpl;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketOption;
import jdk.net.ExtendedSocketOptions;
import jdk.net.SocketFlow;
import sun.net.ExtendedOptionsImpl;

class PlainDatagramSocketImpl
extends AbstractPlainDatagramSocketImpl {
    PlainDatagramSocketImpl() {
    }

    @Override
    protected <T> void setOption(SocketOption<T> name, T value) throws IOException {
        if (!name.equals(ExtendedSocketOptions.SO_FLOW_SLA)) {
            super.setOption(name, value);
        } else {
            if (this.isClosed()) {
                throw new SocketException("Socket closed");
            }
            ExtendedOptionsImpl.checkSetOptionPermission(name);
            ExtendedOptionsImpl.checkValueType(value, SocketFlow.class);
            ExtendedOptionsImpl.setFlowOption(this.getFileDescriptor(), (SocketFlow)value);
        }
    }

    @Override
    protected <T> T getOption(SocketOption<T> name) throws IOException {
        if (!name.equals(ExtendedSocketOptions.SO_FLOW_SLA)) {
            return super.getOption(name);
        }
        if (this.isClosed()) {
            throw new SocketException("Socket closed");
        }
        ExtendedOptionsImpl.checkGetOptionPermission(name);
        SocketFlow flow = SocketFlow.create();
        ExtendedOptionsImpl.getFlowOption(this.getFileDescriptor(), flow);
        return (T)flow;
    }

    @Override
    protected synchronized native void bind0(int var1, InetAddress var2) throws SocketException;

    @Override
    protected native void send(DatagramPacket var1) throws IOException;

    @Override
    protected synchronized native int peek(InetAddress var1) throws IOException;

    @Override
    protected synchronized native int peekData(DatagramPacket var1) throws IOException;

    @Override
    protected synchronized native void receive0(DatagramPacket var1) throws IOException;

    @Override
    protected native void setTimeToLive(int var1) throws IOException;

    @Override
    protected native int getTimeToLive() throws IOException;

    @Override
    protected native void setTTL(byte var1) throws IOException;

    @Override
    protected native byte getTTL() throws IOException;

    @Override
    protected native void join(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected native void leave(InetAddress var1, NetworkInterface var2) throws IOException;

    @Override
    protected native void datagramSocketCreate() throws SocketException;

    @Override
    protected native void datagramSocketClose();

    @Override
    protected native void socketSetOption(int var1, Object var2) throws SocketException;

    @Override
    protected native Object socketGetOption(int var1) throws SocketException;

    @Override
    protected native void connect0(InetAddress var1, int var2) throws SocketException;

    @Override
    protected native void disconnect0(int var1);

    private static native void init();

    static {
        PlainDatagramSocketImpl.init();
    }
}

