/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.libraries.formula.function.math;

import java.math.BigDecimal;
import org.pentaho.reporting.libraries.formula.EvaluationException;
import org.pentaho.reporting.libraries.formula.FormulaContext;
import org.pentaho.reporting.libraries.formula.LibFormulaErrorValue;
import org.pentaho.reporting.libraries.formula.function.Function;
import org.pentaho.reporting.libraries.formula.function.ParameterCallback;
import org.pentaho.reporting.libraries.formula.lvalues.TypeValuePair;
import org.pentaho.reporting.libraries.formula.typing.NumberSequence;
import org.pentaho.reporting.libraries.formula.typing.Type;
import org.pentaho.reporting.libraries.formula.typing.TypeRegistry;
import org.pentaho.reporting.libraries.formula.typing.coretypes.NumberType;
import org.pentaho.reporting.libraries.formula.util.NumberUtil;

public class SumFunction
implements Function {
    public static final BigDecimal ZERO = new BigDecimal(0.0);
    private static final long serialVersionUID = -8604838130517819412L;

    public String getCanonicalName() {
        return "SUM";
    }

    protected boolean isStrictSequenceNeeded() {
        return true;
    }

    public TypeValuePair evaluate(FormulaContext context, ParameterCallback parameters) throws EvaluationException {
        BigDecimal computedResult = ZERO;
        int parameterCount = parameters.getParameterCount();
        if (parameterCount == 0) {
            throw EvaluationException.getInstance(LibFormulaErrorValue.ERROR_ARGUMENTS_VALUE);
        }
        TypeRegistry typeRegistry = context.getTypeRegistry();
        for (int paramIdx = 0; paramIdx < parameterCount; ++paramIdx) {
            Type type = parameters.getType(paramIdx);
            Object value = parameters.getValue(paramIdx);
            NumberSequence sequence = typeRegistry.convertToNumberSequence(type, value, this.isStrictSequenceNeeded());
            while (sequence.hasNext()) {
                computedResult = this.compute(sequence.nextNumber(), computedResult);
            }
        }
        return new TypeValuePair(NumberType.GENERIC_NUMBER, computedResult);
    }

    private BigDecimal compute(Number value, BigDecimal computedResult) {
        if (value == null) {
            return computedResult;
        }
        return computedResult.add(NumberUtil.getAsBigDecimal(value));
    }
}

