/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.action.index.NodeIndexDeletedAction;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.threadpool.ThreadPool;

public class MetaDataDeleteIndexService
extends AbstractComponent {
    private final ThreadPool threadPool;
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final NodeIndexDeletedAction nodeIndexDeletedAction;

    @Inject
    public MetaDataDeleteIndexService(Settings settings, ThreadPool threadPool, ClusterService clusterService, AllocationService allocationService, NodeIndexDeletedAction nodeIndexDeletedAction) {
        super(settings);
        this.threadPool = threadPool;
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.nodeIndexDeletedAction = nodeIndexDeletedAction;
    }

    public void deleteIndices(final Request request, Listener userListener) {
        final List<String> indices = Arrays.asList(request.indices);
        final DeleteIndexListener listener = new DeleteIndexListener(userListener);
        this.clusterService.submitStateUpdateTask("delete-index " + indices, new ClusterStateUpdateTask(Priority.URGENT){

            @Override
            public TimeValue timeout() {
                return request.masterTimeout;
            }

            @Override
            public void onFailure(String source, Throwable t) {
                listener.onFailure(t);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
                MetaData.Builder metaDataBuilder = MetaData.builder(currentState.metaData());
                ClusterBlocks.Builder clusterBlocksBuilder = ClusterBlocks.builder().blocks(currentState.blocks());
                for (String index : indices) {
                    if (!currentState.metaData().hasConcreteIndex(index)) {
                        throw new IndexNotFoundException(index);
                    }
                    MetaDataDeleteIndexService.this.logger.debug("[{}] deleting index", index);
                    routingTableBuilder.remove(index);
                    clusterBlocksBuilder.removeIndexBlocks(index);
                    metaDataBuilder.remove(index);
                }
                int count = currentState.nodes().size();
                final AtomicInteger counter = new AtomicInteger((count += currentState.nodes().dataNodes().size()) * indices.size());
                final NodeIndexDeletedAction.Listener nodeIndexDeleteListener = new NodeIndexDeletedAction.Listener(){

                    @Override
                    public void onNodeIndexDeleted(String deleted, String nodeId) {
                        if (indices.contains(deleted) && counter.decrementAndGet() == 0) {
                            listener.onResponse(new Response(true));
                            MetaDataDeleteIndexService.this.nodeIndexDeletedAction.remove(this);
                        }
                    }

                    @Override
                    public void onNodeIndexStoreDeleted(String deleted, String nodeId) {
                        if (indices.contains(deleted) && counter.decrementAndGet() == 0) {
                            listener.onResponse(new Response(true));
                            MetaDataDeleteIndexService.this.nodeIndexDeletedAction.remove(this);
                        }
                    }
                };
                MetaDataDeleteIndexService.this.nodeIndexDeletedAction.add(nodeIndexDeleteListener);
                listener.future = MetaDataDeleteIndexService.this.threadPool.schedule(request.timeout, "same", new Runnable(){

                    @Override
                    public void run() {
                        listener.onResponse(new Response(false));
                        MetaDataDeleteIndexService.this.nodeIndexDeletedAction.remove(nodeIndexDeleteListener);
                    }
                });
                MetaData newMetaData = metaDataBuilder.build();
                ClusterBlocks blocks = clusterBlocksBuilder.build();
                RoutingAllocation.Result routingResult = MetaDataDeleteIndexService.this.allocationService.reroute(ClusterState.builder(currentState).routingTable(routingTableBuilder.build()).metaData(newMetaData).build(), "deleted indices [" + indices + "]");
                return ClusterState.builder(currentState).routingResult(routingResult).metaData(newMetaData).blocks(blocks).build();
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
            }
        });
    }

    public static class Response {
        private final boolean acknowledged;

        public Response(boolean acknowledged) {
            this.acknowledged = acknowledged;
        }

        public boolean acknowledged() {
            return this.acknowledged;
        }
    }

    public static class Request {
        final String[] indices;
        TimeValue timeout = TimeValue.timeValueSeconds(10L);
        TimeValue masterTimeout = MasterNodeRequest.DEFAULT_MASTER_NODE_TIMEOUT;

        public Request(String[] indices) {
            this.indices = indices;
        }

        public Request timeout(TimeValue timeout) {
            this.timeout = timeout;
            return this;
        }

        public Request masterTimeout(TimeValue masterTimeout) {
            this.masterTimeout = masterTimeout;
            return this;
        }
    }

    public static interface Listener {
        public void onResponse(Response var1);

        public void onFailure(Throwable var1);
    }

    class DeleteIndexListener
    implements Listener {
        private final AtomicBoolean notified = new AtomicBoolean();
        private final Listener listener;
        volatile ScheduledFuture<?> future;

        private DeleteIndexListener(Listener listener) {
            this.listener = listener;
        }

        @Override
        public void onResponse(Response response) {
            if (this.notified.compareAndSet(false, true)) {
                FutureUtils.cancel(this.future);
                this.listener.onResponse(response);
            }
        }

        @Override
        public void onFailure(Throwable t) {
            if (this.notified.compareAndSet(false, true)) {
                FutureUtils.cancel(this.future);
                this.listener.onFailure(t);
            }
        }
    }
}

