/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.tasks;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.Consumer;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.common.util.concurrent.ConcurrentMapLong;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequest;

public class TaskManager
extends AbstractComponent
implements ClusterStateListener {
    private final ConcurrentMapLong<Task> tasks = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
    private final ConcurrentMapLong<CancellableTaskHolder> cancellableTasks = ConcurrentCollections.newConcurrentMapLongWithAggressiveConcurrency();
    private final AtomicLong taskIdGenerator = new AtomicLong();
    private final Map<TaskId, String> banedParents = new ConcurrentHashMap<TaskId, String>();
    private DiscoveryNodes lastDiscoveryNodes = DiscoveryNodes.EMPTY_NODES;

    public TaskManager(Settings settings) {
        super(settings);
    }

    public Task register(String type, String action, TransportRequest request) {
        Task task = request.createTask(this.taskIdGenerator.incrementAndGet(), type, action);
        if (task != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("register {} [{}] [{}] [{}]", task.getId(), type, action, task.getDescription());
            }
            if (task instanceof CancellableTask) {
                String reason;
                CancellableTask cancellableTask = (CancellableTask)task;
                CancellableTaskHolder holder = new CancellableTaskHolder(cancellableTask);
                CancellableTaskHolder oldHolder = this.cancellableTasks.put(task.getId(), holder);
                assert (oldHolder == null);
                if (task.getParentTaskId().isSet() && !this.banedParents.isEmpty() && (reason = this.banedParents.get(task.getParentTaskId())) != null) {
                    try {
                        holder.cancel(reason);
                        throw new IllegalStateException("Task cancelled before it started: " + reason);
                    }
                    catch (Throwable throwable) {
                        this.unregister(task);
                        throw throwable;
                    }
                }
            } else {
                Task previousTask = this.tasks.put(task.getId(), task);
                assert (previousTask == null);
            }
        }
        return task;
    }

    public Set<String> cancel(CancellableTask task, String reason, Consumer<Set<String>> listener) {
        CancellableTaskHolder holder = this.cancellableTasks.get(task.getId());
        if (holder != null) {
            this.logger.trace("cancelling task with id {}", task.getId());
            return holder.cancel(reason, listener);
        }
        return null;
    }

    public Task unregister(Task task) {
        this.logger.trace("unregister task for id: {}", task.getId());
        if (task instanceof CancellableTask) {
            CancellableTaskHolder holder = this.cancellableTasks.remove(task.getId());
            if (holder != null) {
                holder.finish();
                return holder.getTask();
            }
            return null;
        }
        return this.tasks.remove(task.getId());
    }

    public Map<Long, Task> getTasks() {
        HashMap<Long, CancellableTask> taskHashMap = new HashMap<Long, CancellableTask>(this.tasks);
        for (CancellableTaskHolder holder : this.cancellableTasks.values()) {
            taskHashMap.put(holder.getTask().getId(), holder.getTask());
        }
        return Collections.unmodifiableMap(taskHashMap);
    }

    public Map<Long, CancellableTask> getCancellableTasks() {
        HashMap<Long, CancellableTask> taskHashMap = new HashMap<Long, CancellableTask>();
        for (CancellableTaskHolder holder : this.cancellableTasks.values()) {
            taskHashMap.put(holder.getTask().getId(), holder.getTask());
        }
        return Collections.unmodifiableMap(taskHashMap);
    }

    public Task getTask(long id) {
        Task task = this.tasks.get(id);
        if (task != null) {
            return task;
        }
        return this.getCancellableTask(id);
    }

    public CancellableTask getCancellableTask(long id) {
        CancellableTaskHolder holder = this.cancellableTasks.get(id);
        if (holder != null) {
            return holder.getTask();
        }
        return null;
    }

    public int getBanCount() {
        return this.banedParents.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBan(TaskId parentTaskId, String reason) {
        this.logger.trace("setting ban for the parent task {} {}", parentTaskId, reason);
        Map<TaskId, String> map = this.banedParents;
        synchronized (map) {
            if (this.lastDiscoveryNodes.nodeExists(parentTaskId.getNodeId())) {
                this.banedParents.put(parentTaskId, reason);
            }
        }
        for (Map.Entry taskEntry : this.cancellableTasks.entrySet()) {
            CancellableTaskHolder holder = (CancellableTaskHolder)taskEntry.getValue();
            if (!holder.hasParent(parentTaskId)) continue;
            holder.cancel(reason);
        }
    }

    public void removeBan(TaskId parentTaskId) {
        this.logger.trace("removing ban for the parent task {}", parentTaskId);
        this.banedParents.remove(parentTaskId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.nodesRemoved()) {
            Map<TaskId, String> map = this.banedParents;
            synchronized (map) {
                this.lastDiscoveryNodes = event.state().getNodes();
                Iterator<TaskId> banIterator = this.banedParents.keySet().iterator();
                while (banIterator.hasNext()) {
                    TaskId taskId = banIterator.next();
                    if (this.lastDiscoveryNodes.nodeExists(taskId.getNodeId())) continue;
                    this.logger.debug("Removing ban for the parent [{}] on the node [{}], reason: the parent node is gone", taskId, event.state().getNodes().localNode());
                    banIterator.remove();
                }
            }
            for (Map.Entry taskEntry : this.cancellableTasks.entrySet()) {
                CancellableTaskHolder holder = (CancellableTaskHolder)taskEntry.getValue();
                CancellableTask task = holder.getTask();
                TaskId parentTaskId = task.getParentTaskId();
                if (!parentTaskId.isSet() || this.lastDiscoveryNodes.nodeExists(parentTaskId.getNodeId()) || !task.cancelOnParentLeaving()) continue;
                holder.cancel("Coordinating node [" + parentTaskId.getNodeId() + "] left the cluster");
            }
        }
    }

    public void registerChildTask(Task task, String node) {
        if (task == null || !(task instanceof CancellableTask)) {
            return;
        }
        CancellableTaskHolder holder = this.cancellableTasks.get(task.getId());
        if (holder != null) {
            holder.registerChildTaskNode(node);
        }
    }

    private static class CancellableTaskHolder {
        private static final String TASK_FINISHED_MARKER = "task finished";
        private final CancellableTask task;
        private final Set<String> nodesWithChildTasks = new HashSet<String>();
        private volatile String cancellationReason = null;
        private volatile Consumer<Set<String>> cancellationListener = null;

        public CancellableTaskHolder(CancellableTask task) {
            this.task = task;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Set<String> cancel(String reason, Consumer<Set<String>> listener) {
            Set<String> nodes;
            CancellableTaskHolder cancellableTaskHolder = this;
            synchronized (cancellableTaskHolder) {
                assert (reason != null);
                if (this.cancellationReason == null) {
                    this.cancellationReason = reason;
                    this.cancellationListener = listener;
                    nodes = Collections.unmodifiableSet(this.nodesWithChildTasks);
                } else {
                    nodes = null;
                }
            }
            if (nodes != null) {
                this.task.cancel(reason);
            }
            return nodes;
        }

        public Set<String> cancel(String reason) {
            return this.cancel(reason, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            Consumer<Set<String>> listener = null;
            Set<String> nodes = null;
            CancellableTaskHolder cancellableTaskHolder = this;
            synchronized (cancellableTaskHolder) {
                if (this.cancellationReason != null) {
                    if (this.cancellationListener != null) {
                        listener = this.cancellationListener;
                        nodes = Collections.unmodifiableSet(this.nodesWithChildTasks);
                        this.cancellationListener = null;
                    }
                } else {
                    this.cancellationReason = TASK_FINISHED_MARKER;
                }
            }
            if (listener != null) {
                listener.accept(nodes);
            }
        }

        public boolean hasParent(TaskId parentTaskId) {
            return this.task.getParentTaskId().equals(parentTaskId);
        }

        public CancellableTask getTask() {
            return this.task;
        }

        public synchronized void registerChildTaskNode(String nodeId) {
            if (this.cancellationReason != null) {
                throw new IllegalStateException("cannot register child task request, the task is already cancelled");
            }
            this.nodesWithChildTasks.add(nodeId);
        }
    }
}

