/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.watcher;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.WatcherHandle;

public class ResourceWatcherService
extends AbstractLifecycleComponent<ResourceWatcherService> {
    private final boolean enabled;
    private final ThreadPool threadPool;
    final ResourceMonitor lowMonitor;
    final ResourceMonitor mediumMonitor;
    final ResourceMonitor highMonitor;
    private volatile ThreadPool.Cancellable lowFuture;
    private volatile ThreadPool.Cancellable mediumFuture;
    private volatile ThreadPool.Cancellable highFuture;

    @Inject
    public ResourceWatcherService(Settings settings, ThreadPool threadPool) {
        super(settings);
        this.enabled = settings.getAsBoolean("resource.reload.enabled", (Boolean)true);
        this.threadPool = threadPool;
        TimeValue interval = settings.getAsTime("resource.reload.interval.low", Frequency.LOW.interval);
        this.lowMonitor = new ResourceMonitor(interval, Frequency.LOW);
        interval = settings.getAsTime("resource.reload.interval.medium", settings.getAsTime("resource.reload.interval", Frequency.MEDIUM.interval));
        this.mediumMonitor = new ResourceMonitor(interval, Frequency.MEDIUM);
        interval = settings.getAsTime("resource.reload.interval.high", Frequency.HIGH.interval);
        this.highMonitor = new ResourceMonitor(interval, Frequency.HIGH);
        this.logRemovedSetting("watcher.enabled", "resource.reload.enabled");
        this.logRemovedSetting("watcher.interval", "resource.reload.interval");
        this.logRemovedSetting("watcher.interval.low", "resource.reload.interval.low");
        this.logRemovedSetting("watcher.interval.medium", "resource.reload.interval.medium");
        this.logRemovedSetting("watcher.interval.high", "resource.reload.interval.high");
    }

    @Override
    protected void doStart() {
        if (!this.enabled) {
            return;
        }
        this.lowFuture = this.threadPool.scheduleWithFixedDelay(this.lowMonitor, this.lowMonitor.interval, "same");
        this.mediumFuture = this.threadPool.scheduleWithFixedDelay(this.mediumMonitor, this.mediumMonitor.interval, "same");
        this.highFuture = this.threadPool.scheduleWithFixedDelay(this.highMonitor, this.highMonitor.interval, "same");
    }

    @Override
    protected void doStop() {
        if (!this.enabled) {
            return;
        }
        this.lowFuture.cancel();
        this.mediumFuture.cancel();
        this.highFuture.cancel();
    }

    @Override
    protected void doClose() {
    }

    public <W extends ResourceWatcher> WatcherHandle<W> add(W watcher) throws IOException {
        return this.add(watcher, Frequency.MEDIUM);
    }

    public <W extends ResourceWatcher> WatcherHandle<W> add(W watcher, Frequency frequency) throws IOException {
        watcher.init();
        switch (frequency) {
            case LOW: {
                return this.lowMonitor.add(watcher);
            }
            case MEDIUM: {
                return this.mediumMonitor.add(watcher);
            }
            case HIGH: {
                return this.highMonitor.add(watcher);
            }
        }
        throw new IllegalArgumentException("Unknown frequency [" + (Object)((Object)frequency) + "]");
    }

    public void notifyNow() {
        this.notifyNow(Frequency.MEDIUM);
    }

    public void notifyNow(Frequency frequency) {
        switch (frequency) {
            case LOW: {
                this.lowMonitor.run();
                break;
            }
            case MEDIUM: {
                this.mediumMonitor.run();
                break;
            }
            case HIGH: {
                this.highMonitor.run();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown frequency [" + (Object)((Object)frequency) + "]");
            }
        }
    }

    class ResourceMonitor
    implements Runnable {
        final TimeValue interval;
        final Frequency frequency;
        final Set<ResourceWatcher> watchers = new CopyOnWriteArraySet<ResourceWatcher>();

        private ResourceMonitor(TimeValue interval, Frequency frequency) {
            this.interval = interval;
            this.frequency = frequency;
        }

        private <W extends ResourceWatcher> WatcherHandle<W> add(W watcher) {
            this.watchers.add(watcher);
            return new WatcherHandle<W>(this, watcher);
        }

        @Override
        public synchronized void run() {
            for (ResourceWatcher watcher : this.watchers) {
                try {
                    watcher.checkAndNotify();
                }
                catch (IOException e) {
                    ResourceWatcherService.this.logger.trace("failed to check resource watcher", e, new Object[0]);
                }
            }
        }
    }

    public static enum Frequency {
        HIGH(TimeValue.timeValueSeconds(5L)),
        MEDIUM(TimeValue.timeValueSeconds(30L)),
        LOW(TimeValue.timeValueSeconds(60L));

        final TimeValue interval;

        private Frequency(TimeValue interval) {
            this.interval = interval;
        }
    }
}

