/*
 * Decompiled with CFR 0.152.
 */
package org.grails.transaction;

import grails.transaction.TransactionManagerAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.core.PriorityOrdered;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class TransactionManagerPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements BeanFactoryAware,
PriorityOrdered {
    private ConfigurableListableBeanFactory beanFactory;
    private PlatformTransactionManager transactionManager;
    private int order = Integer.MAX_VALUE;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        Assert.isInstanceOf(ConfigurableListableBeanFactory.class, (Object)beanFactory, (String)"TransactionManagerPostProcessor requires a ConfigurableListableBeanFactory");
        this.beanFactory = (ConfigurableListableBeanFactory)beanFactory;
        this.initialize();
    }

    public boolean postProcessAfterInstantiation(Object bean, String name) throws BeansException {
        if (bean instanceof TransactionManagerAware) {
            TransactionManagerAware tma = (TransactionManagerAware)bean;
            tma.setTransactionManager(this.transactionManager);
        }
        return true;
    }

    private void initialize() {
        if (this.beanFactory.containsBean("transactionManager")) {
            this.transactionManager = (PlatformTransactionManager)this.beanFactory.getBean("transactionManager", PlatformTransactionManager.class);
        } else {
            String[] beanNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.beanFactory, PlatformTransactionManager.class, (boolean)false, (boolean)false);
            if (beanNames.length > 0) {
                this.transactionManager = (PlatformTransactionManager)this.beanFactory.getBean(beanNames[0]);
            }
        }
    }

    public int getOrder() {
        return this.order;
    }
}

