/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.cli.command.shell;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jline.console.ConsoleReader;
import jline.console.completer.AggregateCompleter;
import jline.console.completer.ArgumentCompleter;
import jline.console.completer.Completer;
import jline.console.completer.FileNameCompleter;
import jline.console.completer.StringsCompleter;
import org.springframework.boot.cli.command.Command;
import org.springframework.boot.cli.command.options.OptionHelp;
import org.springframework.boot.cli.util.Log;

public class CommandCompleter
extends StringsCompleter {
    private final Map<String, Completer> commandCompleters = new HashMap<String, Completer>();
    private final List<Command> commands = new ArrayList<Command>();
    private final ConsoleReader console;

    public CommandCompleter(ConsoleReader consoleReader, ArgumentCompleter.ArgumentDelimiter argumentDelimiter, Iterable<Command> commands) {
        this.console = consoleReader;
        ArrayList<String> names = new ArrayList<String>();
        for (Command command : commands) {
            this.commands.add(command);
            names.add(command.getName());
            ArrayList<String> options = new ArrayList<String>();
            for (OptionHelp optionHelp : command.getOptionsHelp()) {
                options.addAll(optionHelp.getOptions());
            }
            AggregateCompleter argumentCompleters = new AggregateCompleter(new Completer[]{new StringsCompleter(options), new FileNameCompleter()});
            ArgumentCompleter argumentCompleter = new ArgumentCompleter(argumentDelimiter, new Completer[]{argumentCompleters});
            argumentCompleter.setStrict(false);
            this.commandCompleters.put(command.getName(), (Completer)argumentCompleter);
        }
        this.getStrings().addAll(names);
    }

    public int complete(String buffer, int cursor, List<CharSequence> candidates) {
        String commandName;
        int completionIndex = super.complete(buffer, cursor, candidates);
        int spaceIndex = buffer.indexOf(32);
        String string = commandName = spaceIndex == -1 ? "" : buffer.substring(0, spaceIndex);
        if (!"".equals(commandName.trim())) {
            for (Command command : this.commands) {
                if (!command.getName().equals(commandName)) continue;
                if (cursor == buffer.length() && buffer.endsWith(" ")) {
                    this.printUsage(command);
                    break;
                }
                Completer completer = this.commandCompleters.get(command.getName());
                if (completer == null) continue;
                completionIndex = completer.complete(buffer, cursor, candidates);
                break;
            }
        }
        return completionIndex;
    }

    private void printUsage(Command command) {
        try {
            int maxOptionsLength = 0;
            ArrayList<OptionHelpLine> optionHelpLines = new ArrayList<OptionHelpLine>();
            for (OptionHelp optionHelp : command.getOptionsHelp()) {
                OptionHelpLine optionHelpLine = new OptionHelpLine(optionHelp);
                optionHelpLines.add(optionHelpLine);
                maxOptionsLength = Math.max(maxOptionsLength, optionHelpLine.getOptions().length());
            }
            this.console.println();
            this.console.println((CharSequence)"Usage:");
            this.console.println((CharSequence)(command.getName() + " " + command.getUsageHelp()));
            for (OptionHelpLine optionHelpLine : optionHelpLines) {
                this.console.println((CharSequence)String.format("\t%" + maxOptionsLength + "s: %s", optionHelpLine.getOptions(), optionHelpLine.getUsage()));
            }
            this.console.drawLine();
        }
        catch (IOException ex) {
            Log.error(ex.getMessage() + " (" + ex.getClass().getName() + ")");
        }
    }

    private static class OptionHelpLine {
        private final String options;
        private final String usage;

        OptionHelpLine(OptionHelp optionHelp) {
            StringBuffer options = new StringBuffer();
            for (String option : optionHelp.getOptions()) {
                options.append(options.length() == 0 ? "" : ", ");
                options.append(option);
            }
            this.options = options.toString();
            this.usage = optionHelp.getUsageHelp();
        }

        public String getOptions() {
            return this.options;
        }

        public String getUsage() {
            return this.usage;
        }
    }
}

