// -*- c++ -*-
// Generated by gmmproc 2.42.0 -- DO NOT MODIFY!
#ifndef _GSTREAMERMM_BUFFER_H
#define _GSTREAMERMM_BUFFER_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* gstreamermm - a C++ wrapper for gstreamer
 *
 * Copyright 2008 The gstreamermm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <gst/gst.h>
#include <gstreamermm/miniobject.h>
#include <gstreamermm/clock.h>
#include <gstreamermm/memory.h>
#include <gstreamermm/mapinfo.h>


namespace Gst
{

/** @addtogroup gstreamermmEnums gstreamermm Enums and Flags */

/** 
 *  @var BufferFlags BUFFER_FLAG_LIVE
 *  The buffer is live data and should be discarded in the PAUSED state.
 * 
 *  @var BufferFlags BUFFER_FLAG_DECODE_ONLY
 *  The buffer contains data that should be dropped because it will be clipped against the segment boundaries or because it does not contain data that should be shown to the user.
 * 
 *  @var BufferFlags BUFFER_FLAG_DISCONT
 *  The buffer marks a data discontinuity in the stream. This typically occurs after a seek or a dropped buffer from a live or network source.
 * 
 *  @var BufferFlags BUFFER_FLAG_RESYNC
 *  The buffer timestamps might have a discontinuity and this buffer is a good point to resynchronize.
 * 
 *  @var BufferFlags BUFFER_FLAG_CORRUPTED
 *  The buffer data is corrupted.
 * 
 *  @var BufferFlags BUFFER_FLAG_MARKER
 *  The buffer contains a media specific marker. for video this is typically the end of a frame boundary, for audio this is usually the start of a talkspurt.
 * 
 *  @var BufferFlags BUFFER_FLAG_HEADER
 *  The buffer contains header information that is needed to decode the following data.
 * 
 *  @var BufferFlags BUFFER_FLAG_GAP
 *  The buffer has been created to fill a gap in the stream and contains media neutral data (elements can switch to optimized code path that ignores the buffer content).
 * 
 *  @var BufferFlags BUFFER_FLAG_DROPPABLE
 *  The buffer can be dropped without breaking the stream, for example to reduce bandwidth.
 * 
 *  @var BufferFlags BUFFER_FLAG_DELTA_UNIT
 *  This unit cannot be decoded independently.
 * 
 *  @var BufferFlags BUFFER_FLAG_LAST
 *  Additional media specific flags can be added starting from this flag.
 * 
 *  @enum BufferFlags
 * 
 * A set of buffer flags used to describe properties of a Gst::Buffer.
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%BufferFlags operator|(BufferFlags, BufferFlags)</tt><br>
 * <tt>%BufferFlags operator&(BufferFlags, BufferFlags)</tt><br>
 * <tt>%BufferFlags operator^(BufferFlags, BufferFlags)</tt><br>
 * <tt>%BufferFlags operator~(BufferFlags)</tt><br>
 * <tt>%BufferFlags& operator|=(BufferFlags&, BufferFlags)</tt><br>
 * <tt>%BufferFlags& operator&=(BufferFlags&, BufferFlags)</tt><br>
 * <tt>%BufferFlags& operator^=(BufferFlags&, BufferFlags)</tt><br>
 */
enum BufferFlags
{
  BUFFER_FLAG_LIVE = (GST_MINI_OBJECT_FLAG_LAST << 0),
  BUFFER_FLAG_DECODE_ONLY = (GST_MINI_OBJECT_FLAG_LAST << 1),
  BUFFER_FLAG_DISCONT = (GST_MINI_OBJECT_FLAG_LAST << 2),
  BUFFER_FLAG_RESYNC = (GST_MINI_OBJECT_FLAG_LAST << 3),
  BUFFER_FLAG_CORRUPTED = (GST_MINI_OBJECT_FLAG_LAST << 4),
  BUFFER_FLAG_MARKER = (GST_MINI_OBJECT_FLAG_LAST << 5),
  BUFFER_FLAG_HEADER = (GST_MINI_OBJECT_FLAG_LAST << 6),
  BUFFER_FLAG_GAP = (GST_MINI_OBJECT_FLAG_LAST << 7),
  BUFFER_FLAG_DROPPABLE = (GST_MINI_OBJECT_FLAG_LAST << 8),
  BUFFER_FLAG_DELTA_UNIT = (GST_MINI_OBJECT_FLAG_LAST << 9),
  BUFFER_FLAG_LAST = (GST_MINI_OBJECT_FLAG_LAST << 16)
};

/** @ingroup gstreamermmEnums */
inline BufferFlags operator|(BufferFlags lhs, BufferFlags rhs)
  { return static_cast<BufferFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline BufferFlags operator&(BufferFlags lhs, BufferFlags rhs)
  { return static_cast<BufferFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline BufferFlags operator^(BufferFlags lhs, BufferFlags rhs)
  { return static_cast<BufferFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline BufferFlags operator~(BufferFlags flags)
  { return static_cast<BufferFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline BufferFlags& operator|=(BufferFlags& lhs, BufferFlags rhs)
  { return (lhs = static_cast<BufferFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline BufferFlags& operator&=(BufferFlags& lhs, BufferFlags rhs)
  { return (lhs = static_cast<BufferFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline BufferFlags& operator^=(BufferFlags& lhs, BufferFlags rhs)
  { return (lhs = static_cast<BufferFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::BufferFlags> : public Glib::Value_Flags<Gst::BufferFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{

/** 
 *  @var BufferCopyFlags BUFFER_COPY_NONE
 *  Copy nothing.
 * 
 *  @var BufferCopyFlags BUFFER_COPY_FLAGS
 *  Flag indicating that buffer flags should be copied.
 * 
 *  @var BufferCopyFlags BUFFER_COPY_TIMESTAMPS
 *  Flag indicating that buffer pts, dts, duration, offset and offset_end should be copied.
 * 
 *  @var BufferCopyFlags BUFFER_COPY_MEMORY
 *  Flag indicating that buffer memory should be reffed and appended to already existing memory. Unless the memory is marked as NO_SHARE, no actual copy of the memory is made but it is simply reffed. Add @a GST_BUFFER_COPY_DEEP to force a real copy.
 * 
 *  @var BufferCopyFlags BUFFER_COPY_MERGE
 *  Flag indicating that buffer memory should be merged.
 * 
 *  @var BufferCopyFlags BUFFER_COPY_META
 *  Flag indicating that buffer meta should be copied.
 * 
 *  @var BufferCopyFlags BUFFER_COPY_DEEP
 *  Flag indicating that memory should always be copied instead of reffed (Since 1.2).
 * 
 *  @enum BufferCopyFlags
 * 
 * A set of flags that can be provided to the gst_buffer_copy_into()
 * function to specify which items should be copied.
 * @ingroup gstreamermmEnums
 * @par Bitwise operators:
 * <tt>%BufferCopyFlags operator|(BufferCopyFlags, BufferCopyFlags)</tt><br>
 * <tt>%BufferCopyFlags operator&(BufferCopyFlags, BufferCopyFlags)</tt><br>
 * <tt>%BufferCopyFlags operator^(BufferCopyFlags, BufferCopyFlags)</tt><br>
 * <tt>%BufferCopyFlags operator~(BufferCopyFlags)</tt><br>
 * <tt>%BufferCopyFlags& operator|=(BufferCopyFlags&, BufferCopyFlags)</tt><br>
 * <tt>%BufferCopyFlags& operator&=(BufferCopyFlags&, BufferCopyFlags)</tt><br>
 * <tt>%BufferCopyFlags& operator^=(BufferCopyFlags&, BufferCopyFlags)</tt><br>
 */
enum BufferCopyFlags
{
  BUFFER_COPY_NONE = 0x0,
  BUFFER_COPY_FLAGS = (1 << 0),
  BUFFER_COPY_TIMESTAMPS = (1 << 1),
  BUFFER_COPY_META = (1 << 2),
  BUFFER_COPY_MEMORY = (1 << 3),
  BUFFER_COPY_MERGE = (1 << 4),
  BUFFER_COPY_DEEP = (1 << 5)
};

/** @ingroup gstreamermmEnums */
inline BufferCopyFlags operator|(BufferCopyFlags lhs, BufferCopyFlags rhs)
  { return static_cast<BufferCopyFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline BufferCopyFlags operator&(BufferCopyFlags lhs, BufferCopyFlags rhs)
  { return static_cast<BufferCopyFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline BufferCopyFlags operator^(BufferCopyFlags lhs, BufferCopyFlags rhs)
  { return static_cast<BufferCopyFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup gstreamermmEnums */
inline BufferCopyFlags operator~(BufferCopyFlags flags)
  { return static_cast<BufferCopyFlags>(~static_cast<unsigned>(flags)); }

/** @ingroup gstreamermmEnums */
inline BufferCopyFlags& operator|=(BufferCopyFlags& lhs, BufferCopyFlags rhs)
  { return (lhs = static_cast<BufferCopyFlags>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline BufferCopyFlags& operator&=(BufferCopyFlags& lhs, BufferCopyFlags rhs)
  { return (lhs = static_cast<BufferCopyFlags>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup gstreamermmEnums */
inline BufferCopyFlags& operator^=(BufferCopyFlags& lhs, BufferCopyFlags rhs)
  { return (lhs = static_cast<BufferCopyFlags>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gst


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gst::BufferCopyFlags> : public Glib::Value_Flags<Gst::BufferCopyFlags>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gst
{


/**
 * SECTION:gstbuffer
 * @short_description: Data-passing buffer type
 * @see_also: #GstPad, #GstMiniObject, #GstMemory, #GstMeta, #GstBufferPool
 *
 * Buffers are the basic unit of data transfer in GStreamer. They contain the
 * timing and offset along with other arbitrary metadata that is associated
 * with the #GstMemory blocks that the buffer contains.
 *
 * Buffers are usually created with Gst::Buffer::create. After a buffer has been
 * created one will typically allocate memory for it and add it to the buffer.
 * The following example creates a buffer that can hold a given video frame
 * with a given width, height and bits per plane.
 *
 * Buffers can contain a list of Gst::Memory objects. You can retrieve how many
 * memory objects with n_memory() and you can get a pointer
 * to memory with peek_memory()
 *
 * A buffer will usually have timestamps, and a duration, but neither of these
 * are guaranteed (they may be set to #GST_CLOCK_TIME_NONE). Whenever a
 * meaningful value can be given for these, they should be set. The timestamps
 * and duration are measured in nanoseconds (they are Gst::ClockTime values).
 *
 * The buffer DTS refers to the timestamp when the buffer should be decoded and
 * is usually monotonically increasing. The buffer PTS refers to the timestamp when
 * the buffer content should be presented to the user and is not always
 * monotonically increasing.
 *
 * A buffer can also have one or both of a start and an end offset. These are
 * media-type specific. For video buffers, the start offset will generally be
 * the frame number. For audio buffers, it will be the number of samples
 * produced so far. For compressed data, it could be the byte offset in a
 * source or destination file. Likewise, the end offset will be the offset of
 * the end of the buffer. These can only be meaningfully interpreted if you
 * know the media type of the buffer (the preceeding CAPS event). Either or both
 * can be set to Gst::BUFFER_OFFSET_NONE.
 *
 * To efficiently create a smaller buffer out of an existing one, you can
 * use copy_region(). This method tries to share the memory objects
 * between the two buffers.
 *
 * If a plug-in wants to modify the buffer data or metadata in-place, it should
 * first obtain a buffer that is safe to modify by using
 * create_writable().  This function is optimized so that a copy will
 * only be made when it is necessary.
 *
 * Several flags of the buffer can be set and unset with the
 * GST_BUFFER_FLAG_SET() and GST_BUFFER_FLAG_UNSET() macros. Use
 * GST_BUFFER_FLAG_IS_SET() to test if a certain Gst::BufferFlag is set.
 *
 * Buffers can be efficiently merged into a larger buffer with
 * append(). Copying of memory will only be done when absolutely
 * needed.
 *
 * Arbitrary extra metadata can be set on a buffer with add_meta().
 * Metadata can be retrieved with get_meta(). See also Gst::Meta
 *
 * An element should either unref the buffer or push it out on a src pad
 * using Gst::Pad::push() (see Gst::Pad).
 */
class Buffer : public MiniObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Buffer CppObjectType;
  typedef GstBuffer BaseObjectType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  static Glib::RefPtr<Buffer> create();

  /** Increment the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void reference()   const;

  /** Decrement the reference count for this object.
   * You should never need to do this manually - use the object via a RefPtr instead.
   */
  void unreference() const;

  ///Provides access to the underlying C instance.
  GstBuffer*       gobj();

  ///Provides access to the underlying C instance.
  const GstBuffer* gobj() const;

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GstBuffer* gobj_copy() const;

protected:
  // Do not derive this.  Gst::Buffer can neither be constructed nor deleted.
  Buffer();
  void operator delete(void*, std::size_t);

private:
  // noncopyable
  Buffer(const Buffer&);
  Buffer& operator=(const Buffer&);


public:
  /** Create a copy of the given buffer. This will also make a newly allocated
   * copy of the data the source buffer contains.
   * @return The Gst::Buffer copy.
   */
  Glib::RefPtr<Gst::Buffer> copy() const;
  

  /** Copies the information from @a src into @a dest.
   * 
   * If @a dest already contains memory and @a flags contains GST_BUFFER_COPY_MEMORY,
   * the memory from @a src will be appended to @a dest.
   * 
   *  @a flags indicate which fields will be copied.
   * 
   * @param src A source Gst::Buffer.
   * @param flags Flags indicating what metadata fields should be copied.
   * @param offset Offset to copy from.
   * @param size Total size to copy. If -1, all data is copied.
   * @return <tt>true</tt> if the copying succeeded, <tt>false</tt> otherwise.
   */
  static void copy_into(const Glib::RefPtr<Gst::Buffer>& destination_buffer, const Glib::RefPtr<Gst::Buffer>& source_buffer, BufferCopyFlags flags, gsize offset, gsize size);

  
  /** Creates a sub-buffer from @a parent at @a offset and @a size.
   * This sub-buffer uses the actual memory space of the parent buffer.
   * This function will copy the offset and timestamp fields when the
   * offset is 0. If not, they will be set to Gst::CLOCK_TIME_NONE and 
   * Gst::BUFFER_OFFSET_NONE.
   * If @a offset equals 0 and @a size equals the total size of @a buffer, the
   * duration and offset end fields are also copied. If not they will be set
   * to Gst::CLOCK_TIME_NONE and Gst::BUFFER_OFFSET_NONE.
   * 
   * MT safe.
   * 
   * @param flags The Gst::BufferCopyFlags.
   * @param offset The offset into parent Gst::Buffer at which the new sub-buffer 
   * begins.
   * @param size The size of the new Gst::Buffer sub-buffer, in bytes.
   * @return The new Gst::Buffer or <tt>0</tt> if the arguments were
   * invalid.
   */
  Glib::RefPtr<Gst::Buffer> copy_region(Gst::BufferCopyFlags flags, gsize offset, gsize size);

  static Glib::RefPtr<Gst::Buffer> create(guint size);

  /** Makes a writable buffer from the given buffer. If the source buffer is
   * already writable, this will simply return the same buffer. A copy will
   * otherwise be made.
   * @return A buffer (possibly the same pointer) that is writable.
   */
  Glib::RefPtr<Gst::Buffer> create_writable();

  
  /** Get the memory block at index @a idx in @a buffer.
   * 
   * @param idx An index.
   * @return A Gst::Memory that contains the data of the
   * memory block at @a idx. Use gst_memory_unref() after usage.
   */
  Glib::RefPtr<Gst::Memory> get_memory(guint idx) const;

  
  /** Get the total size of the memory blocks in @a buffer.
   * 
   * @return Total size of the memory blocks in @a buffer.
   */
  gsize get_size() const;

  
  /** Get the total size of the memory blocks in @a b.
   * 
   * When not <tt>0</tt>, @a offset will contain the offset of the data in the
   * first memory block in @a buffer and @a maxsize will contain the sum of
   * the size and @a offset and the amount of extra padding on the last
   * memory block.  @a offset and @a maxsize can be used to resize the
   * buffer memory blocks with gst_buffer_resize().
   * 
   * @param offset A pointer to the offset.
   * @param maxsize A pointer to the maxsize.
   * @return Total size of the memory blocks in @a buffer.
   */
  gsize get_sizes(gsize& offset, gsize& max_size) const;

  
  /** Get the total size of @a length memory blocks stating from @a idx in @a buffer.
   * 
   * When not <tt>0</tt>, @a offset will contain the offset of the data in the
   * memory block in @a buffer at @a idx and @a maxsize will contain the sum of the size
   * and @a offset and the amount of extra padding on the memory block at @a idx +
   *  @a length -1.
   *  @a offset and @a maxsize can be used to resize the buffer memory blocks with
   * gst_buffer_resize_range().
   * 
   * @param idx An index.
   * @param length A length.
   * @param offset A pointer to the offset.
   * @param maxsize A pointer to the maxsize.
   * @return Total size of @a length memory blocks starting at @a idx in @a buffer.
   */
  gsize get_sizes_range(guint idx, gint length, gsize& offset, gsize& max_size) const;

  
  /** Set the total size of the @a length memory blocks starting at @a idx in
   *  @a buffer
   * 
   * @param idx An index.
   * @param length A length.
   * @param offset The offset adjustement.
   * @param size The new size or -1 to just adjust the offset.
   * @return <tt>true</tt> if resizing succeeded, <tt>false</tt> otherwise.
   */
  bool resize_range(guint idx, gint length, gssize offset, gssize size);

  
  /** Set the offset and total size of the memory blocks in @a buffer.
   * 
   * @param offset The offset adjustement.
   * @param size The new size or -1 to just adjust the offset.
   */
  void resize(gssize offset, gssize size);

  
  /** Set the total size of the memory blocks in @a buffer.
   * 
   * @param size The new size.
   */
  void set_size(gssize size);

  
  /** Get the memory block at @a idx in @a buffer. The memory block stays valid until
   * the memory block in @a buffer is removed, replaced or merged, typically with
   * any call that modifies the memory in @a buffer.
   * 
   * @param idx An index.
   * @return The Gst::Memory at @a idx.
   */
  Glib::RefPtr<Gst::Memory> peek_memory(guint idx);

  
  /** Get the amount of memory blocks that this buffer has. This amount is never
   * larger than what gst_buffer_get_max_memory() returns.
   * 
   * @return The amount of memory block in this buffer.
   */
  guint n_memory() const;

  /** Insert the memory block @mem to @buffer at @idx. This function takes ownership
   * of @mem and thus doesn't increase its refcount.
   *
   * Only get_max_memory() can be added to a buffer. If more memory is
   * added, existing memory blocks will automatically be merged to make room for
   * the new memory.
   *
   * @param idx: the index to add the memory at, or -1 to append it to the end.
   * @param mem: a Gst::Memory.
   */
  void insert_memory(guint idx, Glib::RefPtr<Gst::Memory>& mem);
  

  /** Get all the memory block in @a buffer. The memory blocks will be merged
   * into one large Gst::Memory.
   * 
   * @return A Gst::Memory that contains the merged memory.
   * Use gst_memory_unref() after usage.
   */
  Glib::RefPtr<Gst::Memory> get_all_memory() const;

  
  /** Copy @a size bytes from @a src to @a buffer at @a offset.
   * 
   * @param offset The offset to fill.
   * @param src The source address.
   * @param size The size to fill.
   * @return The amount of bytes copied. This value can be lower than @a size
   * when @a buffer did not contain enough data.
   */
  gsize fill(gsize offset, gconstpointer src, gsize size);

  
  /** Append all the memory from @a buf2 to @a buf1. The result buffer will contain a
   * concatenation of the memory of @a buf1 and @a buf2.
   * 
   * @param buf2 The second source Gst::Buffer to append.
   * @return The new Gst::Buffer that contains the memory
   * of the two source buffers.
   */
  Glib::RefPtr<Gst::Buffer> append(const Glib::RefPtr<Gst::Buffer>& buf) const;

  
  /** Append @a size bytes at @a offset from @a buf2 to @a buf1. The result buffer will
   * contain a concatenation of the memory of @a buf1 and the requested region of
   *  @a buf2.
   * 
   * @param buf2 The second source Gst::Buffer to append.
   * @param offset The offset in @a buf2.
   * @param size The size or -1 of @a buf2.
   * @return The new Gst::Buffer that contains the memory
   * of the two source buffers.
   */
  Glib::RefPtr<Gst::Buffer> append_region(const Glib::RefPtr<Gst::Buffer>& buf, gssize offset, gssize size) const;

  /** Replaces @a length memory blocks in @a buffer starting at @a idx with @a mem.
   *
   * If @a length is -1, all memory starting from @a idx will be removed and
   * replaced with @a mem.
   *
   *  @a buffer should be writable.
   *
   * @param idx An index.
   * @param length A length should not be 0.
   * @param mem A Gst::Memory.
   */
  void replace_memory_range(guint idx, gint length, Glib::RefPtr<Gst::Memory>& mem);
  

  /** Get @a length memory blocks in @a buffer starting at @a idx. The memory blocks will
   * be merged into one large Gst::Memory.
   * 
   * If @a length is -1, all memory starting from @a idx is merged.
   * 
   * @param idx An index.
   * @param length A length.
   * @return A Gst::Memory that contains the merged data of @a length
   * blocks starting at @a idx. Use gst_memory_unref() after usage.
   */
  Glib::RefPtr<Gst::Memory> get_memory_range(guint idx, gint length);

  
  /** Remove @a length memory blocks in @a buffer starting from @a idx.
   * 
   *  @a length can be -1, in which case all memory starting from @a idx is removed.
   * 
   * @param idx An index.
   * @param length A length.
   */
  void remove_memory_range(guint idx, gint length);

  
  /** Find the memory blocks that span @a size bytes starting from @a offset
   * in @a buffer.
   * 
   * When this function returns <tt>true</tt>, @a idx will contain the index of the first
   * memory bock where the byte for @a offset can be found and @a length contains the
   * number of memory blocks containing the @a size remaining bytes. @a skip contains
   * the number of bytes to skip in the memory bock at @a idx to get to the byte
   * for @a offset.
   * 
   *  @a size can be -1 to get all the memory blocks after @a idx.
   * 
   * @param offset An offset.
   * @param size A size.
   * @param idx Pointer to index.
   * @param length Pointer to length.
   * @param skip Pointer to skip.
   * @return <tt>true</tt> when @a size bytes starting from @a offset could be found in
   *  @a buffer and @a idx, @a length and @a skip will be filled.
   */
  bool find_memory(gsize offset, gsize size, guint& idx, guint& length, gsize& skip);

  /** Prepend the memory block @mem to @buffer. This function takes
   * ownership of @mem and thus doesn't increase its refcount.
   *
   * This function is identical to insert_memory() with an index of 0.
   * See insert_memory() for more details.
   *
   * @param mem: a Gst::Memory.
   */
   void prepend_memory(Glib::RefPtr<Gst::Memory>& mem);
  

  /** Append the memory block @mem to @buffer. This function takes
   * ownership of @mem and thus doesn't increase its refcount.

   * This function is identical to insert_memory() with an index of -1.
   * See insert_memory() for more details.
   *
   * @param mem: a Gst::Memory.
   */
  void append_memory(Glib::RefPtr<Gst::Memory>& mem);
  ;

  
  /** Remove the memory block in @a b at index @a i.
   * 
   * @param idx An index.
   */
  void remove_memory(guint idx);

  
  /** Remove all the memory blocks in @a buffer.
   * 
   */
  void remove_all_memory();

  
  /** Fill @a buf with @a size bytes with @a val starting from @a offset.
   * 
   * @param offset The offset in @a buffer.
   * @param val The value to set.
   * @param size The size to set.
   * @return The amount of bytes filled. This value can be lower than @a size
   * when @a buffer did not contain enough data.
   */
  gsize memset(gsize offset, guint8 val, gsize size);

  /** Replaces the memory block at index @a idx in @a buffer with @a mem.
   *
   * @param idx An index.
   * @param mem A Gst::Memory.
   */
  void replace_memory(guint idx, Glib::RefPtr<Gst::Memory>& mem);
  

  /** Replaces all memory in @a buffer with @a mem.
   *
   * @param mem A Gst::Memory.
   */
  void replace_all_memory(Glib::RefPtr<Gst::Memory>& mem);
  

  /** Copy @a size bytes starting from @a offset in @a buffer to @a dest.
   * 
   * @param offset The offset to extract.
   * @param dest The destination address.
   * @param size The size to extract.
   * @return The amount of bytes extracted. This value can be lower than @a size
   * when @a buffer did not contain enough data.
   */
  gsize extract(gsize offset, gpointer dest, gsize size);

  
  /** Extracts a copy of at most @a size bytes the data at @a offset into a Bytes.
   *  @a dest must be freed using Glib::free() when done.
   * 
   * @param offset The offset to extract.
   * @param size The size to extract.
   * @param dest A pointer where
   * the destination array will be written.
   * @param dest_size A location where the size of @a dest can be written.
   */
  void extract_dup(gsize offset, gsize size, gpointer& dest, gsize& dest_size);

  
  /** Compare @a size bytes starting from @a offset in @a buffer with the memory in @a mem.
   * 
   * @param offset The offset in @a buffer.
   * @param mem The memory to compare.
   * @param size The size to compare.
   * @return 0 if the memory is equal.
   */
  int memcmp(gsize offset, gconstpointer mem, gsize size);

   ClockTime get_pts() const;
    void set_pts(const ClockTime& value);
 
   ClockTime get_dts() const;
    void set_dts(const ClockTime& value);
 
  /** Get duration of this buffer.
   * @return he duration in nanoseconds (as a Gst::ClockTime) of the data in
   * the buffer. Value will be Gst::CLOCK_TIME_NONE if the duration is unknown.
   */
   ClockTime get_duration() const;
    void set_duration(const ClockTime& value);
 
  
  /** This function fills @a info with the Gst::MapInfo of all merged memory
   * blocks in @a buffer.
   * 
   *  @a flags describe the desired access of the memory. When @a flags is
   * Gst::MAP_WRITE, @a buffer should be writable (as returned from
   * gst_buffer_is_writable()).
   * 
   * When @a buffer is writable but the memory isn't, a writable copy will
   * automatically be created and returned. The readonly copy of the
   * buffer memory will then also be replaced with this writable copy.
   * 
   * The memory in @a info should be unmapped with gst_buffer_unmap() after
   * usage.
   * 
   * @param info Info about the mapping.
   * @param flags Flags for the mapping.
   * @return <tt>true</tt> if the map succeeded and @a info contains valid data.
   */
  bool map(const Glib::RefPtr<Gst::MapInfo>& info, MapFlags flags);

  
  /** This function fills @a info with the Gst::MapInfo of @a length merged memory blocks
   * starting at @a idx in @a buffer. When @a length is -1, all memory blocks starting
   * from @a idx are merged and mapped.
   * 
   *  @a flags describe the desired access of the memory. When @a flags is
   * Gst::MAP_WRITE, @a buffer should be writable (as returned from
   * gst_buffer_is_writable()).
   * 
   * When @a buffer is writable but the memory isn't, a writable copy will
   * automatically be created and returned. The readonly copy of the buffer memory
   * will then also be replaced with this writable copy.
   * 
   * The memory in @a info should be unmapped with gst_buffer_unmap() after usage.
   * 
   * @param idx An index.
   * @param length A length.
   * @param info Info about the mapping.
   * @param flags Flags for the mapping.
   * @return <tt>true</tt> if the map succeeded and @a info contains valid
   * data.
   */
  bool map_range(guint idx, gint length, const Glib::RefPtr<Gst::MapInfo>& info, MapFlags flags);

  
  /** Release the memory previously mapped with gst_buffer_map().
   * 
   * @param info A Gst::MapInfo.
   */
  void unmap(const Glib::RefPtr<Gst::MapInfo>& info);
  /** Get the offset of this buffer.
   * @return The offset in the source file of the beginning of this buffer.
   */
   guint64 get_offset() const;
 
  /** Get the offset end of this buffer.
   * @return The offset in the source file of the end of this buffer.
   */
   guint64 get_offset_end() const;
 
  /** Constant for no-offset return results.
   */
  static guint64 offset_none();


};

}//namespace Gst


namespace Glib
{

  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gst::Buffer
   */
  Glib::RefPtr<Gst::Buffer> wrap(GstBuffer* object, bool take_copy = false);

} // namespace Glib


#endif /* _GSTREAMERMM_BUFFER_H */

