/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.format.format;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.NodeChildren;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.object.DynamicObject;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.format.FormatNode;
import org.jruby.truffle.core.format.printf.PrintfSimpleTreeBuilder;

@NodeChildren(value={@NodeChild(value="width", type=FormatNode.class), @NodeChild(value="precision", type=FormatNode.class), @NodeChild(value="value", type=FormatNode.class)})
public abstract class FormatIntegerBinaryNode
extends FormatNode {
    private final char format;
    private final boolean hasPlusFlag;
    private final boolean useAlternativeFormat;
    private final boolean hasMinusFlag;
    private final boolean hasSpaceFlag;
    private final boolean hasZeroFlag;

    public FormatIntegerBinaryNode(RubyContext context, char format, boolean hasPlusFlag, boolean useAlternativeFormat, boolean hasMinusFlag, boolean hasSpaceFlag, boolean hasZeroFlag) {
        super(context);
        this.format = format;
        this.hasPlusFlag = hasPlusFlag;
        this.useAlternativeFormat = useAlternativeFormat;
        this.hasMinusFlag = hasMinusFlag;
        this.hasSpaceFlag = hasSpaceFlag;
        this.hasZeroFlag = hasZeroFlag;
    }

    @Specialization
    public byte[] format(int width, int precision, int value) {
        boolean isNegative = value < 0;
        boolean negativeAndPadded = isNegative && (this.hasSpaceFlag || this.hasPlusFlag);
        String formatted = negativeAndPadded ? Integer.toBinaryString(-value) : Integer.toBinaryString(value);
        return FormatIntegerBinaryNode.getFormattedString(formatted, width, precision, isNegative, this.hasSpaceFlag, this.hasPlusFlag, this.hasZeroFlag, this.useAlternativeFormat, this.hasMinusFlag, this.format);
    }

    @CompilerDirectives.TruffleBoundary
    @Specialization(guards={"isRubyBignum(value)"})
    public byte[] format(int width, int precision, DynamicObject value) {
        String formatted;
        boolean negativeAndPadded;
        BigInteger bigInteger = Layouts.BIGNUM.getValue(value);
        boolean isNegative = bigInteger.signum() == -1;
        boolean bl = negativeAndPadded = isNegative && (this.hasSpaceFlag || this.hasPlusFlag);
        if (negativeAndPadded) {
            formatted = bigInteger.abs().toString(2);
        } else if (!isNegative) {
            formatted = bigInteger.toString(2);
        } else {
            byte[] bytes;
            StringBuilder builder = new StringBuilder();
            for (byte b : bytes = bigInteger.toByteArray()) {
                builder.append(Integer.toBinaryString(b & 0xFF));
            }
            formatted = builder.toString();
        }
        return FormatIntegerBinaryNode.getFormattedString(formatted, width, precision, isNegative, this.hasSpaceFlag, this.hasPlusFlag, this.hasZeroFlag, this.useAlternativeFormat, this.hasMinusFlag, this.format);
    }

    @CompilerDirectives.TruffleBoundary
    private static byte[] getFormattedString(String formatted, int width, int precision, boolean isNegative, boolean isSpacePadded, boolean hasPlusFlag, boolean hasZeroFlag, boolean useAlternativeFormat, boolean hasMinusFlag, char format) {
        if (width < 0 && width != PrintfSimpleTreeBuilder.DEFAULT) {
            width = -width;
            hasMinusFlag = true;
        }
        if (isNegative && !isSpacePadded && !hasPlusFlag) {
            if (formatted.contains("0")) {
                if ((formatted = formatted.substring(formatted.indexOf(48), formatted.length())).length() + 3 < precision) {
                    int addOnes;
                    for (int i = addOnes = precision - (formatted.length() + 3); i > 0; --i) {
                        formatted = "1" + formatted;
                    }
                }
                formatted = "..1" + formatted;
            } else {
                formatted = "..1";
            }
        } else if ((hasZeroFlag || precision != PrintfSimpleTreeBuilder.DEFAULT) && !hasMinusFlag) {
            int padZeros;
            int n = padZeros = precision != PrintfSimpleTreeBuilder.DEFAULT ? precision : width;
            while (formatted.length() < padZeros) {
                formatted = "0" + formatted;
            }
        }
        while (formatted.length() < width) {
            if (!hasMinusFlag) {
                formatted = " " + formatted;
                continue;
            }
            formatted = formatted + " ";
        }
        if (useAlternativeFormat) {
            formatted = format == 'B' ? "0B" + formatted : "0b" + formatted;
        }
        if (isSpacePadded || hasPlusFlag) {
            formatted = isNegative ? "-" + formatted : (hasPlusFlag ? "+" + formatted : " " + formatted);
        }
        return formatted.getBytes(StandardCharsets.US_ASCII);
    }
}

