/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.core.string;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.DynamicObject;
import java.nio.charset.Charset;
import org.jcodings.Encoding;
import org.jruby.RubyEncoding;
import org.jruby.truffle.Layouts;
import org.jruby.truffle.RubyContext;
import org.jruby.truffle.core.array.ArrayOperations;
import org.jruby.truffle.core.encoding.EncodingNodes;
import org.jruby.truffle.core.rope.CodeRange;
import org.jruby.truffle.core.rope.Rope;
import org.jruby.truffle.core.rope.RopeOperations;
import org.jruby.truffle.core.string.StringCodeRangeableWrapper;
import org.jruby.truffle.language.RubyGuards;
import org.jruby.truffle.util.ByteListUtils;
import org.jruby.truffle.util.StringUtils;
import org.jruby.util.ByteList;

public abstract class StringOperations {
    public static DynamicObject createString(RubyContext context, ByteList bytes) {
        return Layouts.STRING.createString(context.getCoreLibrary().getStringFactory(), StringOperations.ropeFromByteList(bytes, CodeRange.CR_UNKNOWN));
    }

    public static DynamicObject create7BitString(RubyContext context, ByteList bytes) {
        return Layouts.STRING.createString(context.getCoreLibrary().getStringFactory(), StringOperations.ropeFromByteList(bytes, CodeRange.CR_7BIT));
    }

    public static DynamicObject createString(RubyContext context, Rope rope) {
        return Layouts.STRING.createString(context.getCoreLibrary().getStringFactory(), rope);
    }

    @CompilerDirectives.TruffleBoundary
    public static String getString(DynamicObject string) {
        return RopeOperations.decodeRope(StringOperations.rope(string));
    }

    public static StringCodeRangeableWrapper getCodeRangeableReadWrite(final DynamicObject string, EncodingNodes.CheckEncodingNode checkEncodingNode) {
        return new StringCodeRangeableWrapper(string, checkEncodingNode){
            private final ByteList byteList;
            int codeRange;
            {
                super(string2, checkEncodingNode);
                this.byteList = RopeOperations.toByteListCopy(StringOperations.rope(string));
                this.codeRange = StringOperations.getCodeRange(string).toInt();
            }

            @Override
            public void setCodeRange(int newCodeRange) {
                this.codeRange = newCodeRange;
            }

            @Override
            public int getCodeRange() {
                return this.codeRange;
            }

            @Override
            public ByteList getByteList() {
                return this.byteList;
            }
        };
    }

    public static StringCodeRangeableWrapper getCodeRangeableReadOnly(final DynamicObject string, EncodingNodes.CheckEncodingNode checkEncodingNode) {
        return new StringCodeRangeableWrapper(string, checkEncodingNode){

            @Override
            public ByteList getByteList() {
                return StringOperations.getByteListReadOnly(string);
            }
        };
    }

    public static CodeRange getCodeRange(DynamicObject string) {
        return Layouts.STRING.getRope(string).getCodeRange();
    }

    public static void setCodeRange(DynamicObject string, int codeRange) {
        int existingCodeRange = StringOperations.getCodeRange(string).toInt();
        if (existingCodeRange != codeRange) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new RuntimeException(StringUtils.format("Tried changing the code range value for a rope from %d to %d", existingCodeRange, codeRange));
        }
    }

    public static boolean isCodeRangeValid(DynamicObject string) {
        return StringOperations.getCodeRange(string) == CodeRange.CR_VALID;
    }

    public static void clearCodeRange(DynamicObject string) {
        StringOperations.setCodeRange(string, CodeRange.CR_UNKNOWN.toInt());
    }

    public static void keepCodeRange(DynamicObject string) {
        if (StringOperations.getCodeRange(string) == CodeRange.CR_BROKEN) {
            StringOperations.clearCodeRange(string);
        }
    }

    public static int normalizeIndex(int length, int index) {
        return ArrayOperations.normalizeIndex(length, index);
    }

    public static int clampExclusiveIndex(DynamicObject string, int index) {
        assert (RubyGuards.isRubyString(string));
        return ArrayOperations.clampExclusiveIndex(StringOperations.rope(string).byteLength(), index);
    }

    @CompilerDirectives.TruffleBoundary
    public static Rope encodeRope(CharSequence value, Encoding encoding, CodeRange codeRange) {
        Charset charset = encoding.getCharset();
        if (charset == null) {
            charset = Charset.defaultCharset();
        }
        byte[] bytes = charset == RubyEncoding.UTF8 ? RubyEncoding.encodeUTF8((CharSequence)value) : (charset == RubyEncoding.UTF16 ? RubyEncoding.encodeUTF16((CharSequence)value) : RubyEncoding.encode((CharSequence)value, (Charset)charset));
        return RopeOperations.create(bytes, encoding, codeRange);
    }

    public static Rope encodeRope(CharSequence value, Encoding encoding) {
        return StringOperations.encodeRope(value, encoding, CodeRange.CR_UNKNOWN);
    }

    @CompilerDirectives.TruffleBoundary
    public static Rope createRope(String s, Encoding encoding) {
        return RopeOperations.create(ByteList.encode((CharSequence)s, (String)"ISO-8859-1"), encoding, CodeRange.CR_UNKNOWN);
    }

    public static ByteList getByteListReadOnly(DynamicObject object) {
        return RopeOperations.getByteListReadOnly(StringOperations.rope(object));
    }

    public static Rope ropeFromByteList(ByteList byteList) {
        return RopeOperations.create(byteList.bytes(), byteList.getEncoding(), CodeRange.CR_UNKNOWN);
    }

    public static Rope ropeFromByteList(ByteList byteList, CodeRange codeRange) {
        return RopeOperations.create(byteList.bytes(), byteList.getEncoding(), codeRange);
    }

    public static Rope ropeFromByteList(ByteList byteList, int codeRange) {
        return RopeOperations.create(byteList.bytes(), byteList.getEncoding(), CodeRange.fromInt(codeRange));
    }

    @CompilerDirectives.TruffleBoundary
    public static ByteList createByteList(CharSequence s) {
        return ByteListUtils.create(s);
    }

    public static Rope rope(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return Layouts.STRING.getRope(string);
    }

    public static void setRope(DynamicObject string, Rope rope) {
        assert (RubyGuards.isRubyString(string));
        Layouts.STRING.setRope(string, rope);
    }

    public static Encoding encoding(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringOperations.rope(string).getEncoding();
    }

    public static CodeRange codeRange(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return StringOperations.rope(string).getCodeRange();
    }

    public static String decodeUTF8(DynamicObject string) {
        assert (RubyGuards.isRubyString(string));
        return RopeOperations.decodeUTF8(Layouts.STRING.getRope(string));
    }

    public static boolean isUTF8ValidOneByte(byte b) {
        return b >= 0;
    }

    public static boolean isUTF8ValidTwoBytes(byte ... bytes) {
        assert (bytes.length == 2);
        if ((bytes[0] & 0xFF) >= 194 && (bytes[0] & 0xFF) <= 223) {
            return (bytes[1] & 0xFF) >= 128 && (bytes[1] & 0xFF) <= 191;
        }
        return false;
    }

    public static boolean isUTF8ValidThreeBytes(byte ... bytes) {
        assert (bytes.length == 3);
        if ((bytes[0] & 0xFF) < 224 || (bytes[0] & 0xFF) > 239) {
            return false;
        }
        if ((bytes[2] & 0xFF) < 128 || (bytes[2] & 0xFF) > 191) {
            return false;
        }
        if ((bytes[1] & 0xFF) >= 128 || (bytes[2] & 0xFF) <= 191) {
            if ((bytes[0] & 0xFF) == 224) {
                return (bytes[1] & 0xFF) >= 160;
            }
            if ((bytes[0] & 0xFF) == 237) {
                return (bytes[1] & 0xFF) <= 159;
            }
            return true;
        }
        return false;
    }

    public static boolean isUTF8ValidFourBytes(byte ... bytes) {
        assert (bytes.length == 4);
        if ((bytes[3] & 0xFF) < 128 || (bytes[3] & 0xFF) > 191) {
            return false;
        }
        if ((bytes[2] & 0xFF) < 128 || (bytes[2] & 0xFF) > 191) {
            return false;
        }
        if ((bytes[0] & 0xFF) < 240 || (bytes[0] & 0xFF) > 244) {
            return false;
        }
        if ((bytes[1] & 0xFF) >= 128 || (bytes[2] & 0xFF) <= 191) {
            if ((bytes[0] & 0xFF) == 240) {
                return (bytes[1] & 0xFF) >= 144;
            }
            if ((bytes[0] & 0xFF) == 244) {
                return (bytes[1] & 0xFF) <= 143;
            }
            return true;
        }
        return false;
    }

    public static boolean isUTF8ValidFiveBytes(byte ... bytes) {
        assert (bytes.length == 5);
        return false;
    }

    public static boolean isUTF8ValidSixBytes(byte ... bytes) {
        assert (bytes.length == 6);
        return false;
    }
}

