/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.DrawingEditor;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.standard.AbstractCommand;
import CH.ifa.draw.standard.StandardFigureSelection;
import CH.ifa.draw.util.Clipboard;

public abstract class FigureTransferCommand
extends AbstractCommand {
    protected FigureTransferCommand(String name, DrawingEditor newDrawingEditor) {
        super(name, newDrawingEditor);
    }

    protected void deleteFigures(FigureEnumeration fe) {
        while (fe.hasMoreElements()) {
            this.view().drawing().orphan(fe.nextFigure());
        }
        this.view().clearSelection();
    }

    protected void copyFigures(FigureEnumeration fe, int figureCount) {
        Clipboard.getClipboard().setContents(new StandardFigureSelection(fe, figureCount));
    }

    FigureEnumeration insertFigures(FigureEnumeration fe, int dx, int dy) {
        return this.view().insertFigures(fe, dx, dy, false);
    }
}

