/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.standard;

import CH.ifa.draw.framework.Figure;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.framework.FigureSelection;
import CH.ifa.draw.standard.FigureEnumerator;
import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;

public class StandardFigureSelection
implements FigureSelection,
Serializable {
    private byte[] fData;
    public static final String TYPE = "CH.ifa.draw.Figures";

    public StandardFigureSelection(FigureEnumeration figures, int figureCount) {
        ByteArrayOutputStream output = new ByteArrayOutputStream(200);
        StorableOutput writer = new StorableOutput(output);
        writer.writeInt(figureCount);
        while (figures.hasMoreElements()) {
            writer.writeStorable(figures.nextFigure());
        }
        writer.close();
        this.fData = output.toByteArray();
    }

    public String getType() {
        return TYPE;
    }

    public Object getData(String type) {
        if (type.equals(TYPE)) {
            ByteArrayInputStream input = new ByteArrayInputStream(this.fData);
            Vector<Figure> result = new Vector<Figure>(10);
            StorableInput reader = new StorableInput(input);
            try {
                int count = reader.readInt();
                for (int numRead = 0; numRead < count; ++numRead) {
                    Figure newFigure = (Figure)reader.readStorable();
                    result.addElement(newFigure);
                }
            }
            catch (IOException e) {
                System.err.println(e.toString());
            }
            return new FigureEnumerator(result);
        }
        return null;
    }

    public static FigureEnumeration duplicateFigures(FigureEnumeration toBeCloned, int figureCount) {
        StandardFigureSelection duplicater = new StandardFigureSelection(toBeCloned, figureCount);
        return (FigureEnumeration)duplicater.getData(duplicater.getType());
    }
}

