/*
 * Decompiled with CFR 0.152.
 */
package CH.ifa.draw.util;

import CH.ifa.draw.framework.DrawingView;
import CH.ifa.draw.framework.FigureEnumeration;
import CH.ifa.draw.util.Undoable;

public class UndoRedoActivity
implements Undoable {
    private Undoable myReversedActivity;

    protected UndoRedoActivity(Undoable newReversedActivity) {
        this.setReversedActivity(newReversedActivity);
    }

    public boolean undo() {
        if (this.isRedoable()) {
            return this.getReversedActivity().redo();
        }
        return false;
    }

    public boolean redo() {
        if (this.isUndoable()) {
            return this.getReversedActivity().undo();
        }
        return false;
    }

    public boolean isUndoable() {
        return this.getReversedActivity().isRedoable();
    }

    public void setUndoable(boolean newIsUndoable) {
        this.getReversedActivity().setRedoable(newIsUndoable);
    }

    public boolean isRedoable() {
        return this.getReversedActivity().isUndoable();
    }

    public void setRedoable(boolean newIsRedoable) {
        this.getReversedActivity().setUndoable(newIsRedoable);
    }

    public void setAffectedFigures(FigureEnumeration newAffectedFigures) {
        this.getReversedActivity().setAffectedFigures(newAffectedFigures);
    }

    public FigureEnumeration getAffectedFigures() {
        return this.getReversedActivity().getAffectedFigures();
    }

    public int getAffectedFiguresCount() {
        return this.getReversedActivity().getAffectedFiguresCount();
    }

    public DrawingView getDrawingView() {
        return this.getReversedActivity().getDrawingView();
    }

    public void release() {
        this.getReversedActivity().release();
    }

    protected void setReversedActivity(Undoable newReversedActivity) {
        this.myReversedActivity = newReversedActivity;
    }

    public Undoable getReversedActivity() {
        return this.myReversedActivity;
    }

    public static Undoable createUndoRedoActivity(Undoable toBeReversed) {
        if (toBeReversed instanceof UndoRedoActivity) {
            return ((UndoRedoActivity)toBeReversed).getReversedActivity();
        }
        return new UndoRedoActivity(toBeReversed);
    }
}

