/*
 * Decompiled with CFR 0.152.
 */
package ch.ehi.umleditor.umlpresentation;

import ch.ehi.basics.tools.AbstractVisitor;
import ch.ehi.uml1_4.changepropagation.MetaModel;
import ch.ehi.uml1_4.changepropagation.MetaModelChange;
import ch.ehi.umleditor.umlpresentation.Association;
import ch.ehi.umleditor.umlpresentation.PresentationAbstractClass;
import ch.ehi.umleditor.umlpresentation.PresentationNode;
import ch.ehi.umleditor.umlpresentation.PresentationRole;
import ch.ehi.umleditor.umlpresentation.WayPoint;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Iterator;

public class PresentationAssocClass
extends PresentationAbstractClass {
    private Association association;
    private double classAngle;
    private double classRadius;

    @Override
    public void unlinkAll() {
        this.detachAssociation();
        super.unlinkAll();
    }

    @Override
    public void enumerateChildren(AbstractVisitor visitor) {
        Object it = null;
        super.enumerateChildren(visitor);
    }

    @Override
    public boolean isMoveable() {
        return this.getAssociation().isLinkMoveable();
    }

    public boolean isLinkWithoutClass() {
        return !this.getAssociation().isAssocClassVisible();
    }

    public void attachAssociation(Association association1) {
        if (this.association != null) {
            throw new IllegalStateException("already a association attached");
        }
        if (association1 == null) {
            throw new IllegalArgumentException("null may not be attached as association");
        }
        this.association = association1;
        association1._linkLinkPresentation(this);
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "attachAssociation"));
    }

    public Association detachAssociation() {
        Association ret = null;
        if (this.association != null) {
            this.association._unlinkLinkPresentation(this);
            ret = this.association;
            this.association = null;
        }
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "detachAssociation"));
        return ret;
    }

    public Association getAssociation() {
        if (this.association == null) {
            throw new IllegalStateException("no association attached");
        }
        return this.association;
    }

    public boolean containsAssociation() {
        return this.association != null;
    }

    public void _linkAssociation(Association association1) {
        this.association = association1;
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "_linkAssociation"));
    }

    public void _unlinkAssociation(Association association1) {
        this.association = null;
        MetaModel.getInstance().notifyChange(new MetaModelChange(this, "_unlinkAssociation"));
    }

    public double getClassAngle() {
        return this.classAngle;
    }

    public void setClassAngle(double value1) {
        if (this.classAngle != value1) {
            this.classAngle = value1;
            MetaModel.getInstance().notifyChange(new MetaModelChange(this, "setClassAngle"));
        }
    }

    public double getClassRadius() {
        return this.classRadius;
    }

    public void setClassRadius(double value1) {
        if (this.classRadius != value1) {
            this.classRadius = value1;
            MetaModel.getInstance().notifyChange(new MetaModelChange(this, "setClassRadius"));
        }
    }

    @Override
    public int getEast() {
        if (this.isMoveable()) {
            return super.getEast();
        }
        if (this.containsAssociation()) {
            int ret;
            Association assoc = this.getAssociation();
            Iterator rolei = assoc.iteratorRolePresentation();
            if (!rolei.hasNext()) {
                return super.getEast();
            }
            PresentationRole role1 = (PresentationRole)rolei.next();
            if (!rolei.hasNext()) {
                return super.getEast();
            }
            PresentationRole role2 = (PresentationRole)rolei.next();
            Rectangle start = this.getPoint(role1);
            if (start == null) {
                return super.getEast();
            }
            Rectangle end = this.getPoint(role2);
            if (end == null) {
                return super.getEast();
            }
            Point startCenter = this.getCenter(start);
            Point endCenter = this.getCenter(end);
            if (startCenter.getX() == endCenter.getX()) {
                ret = (int)startCenter.getX();
            } else {
                double endX;
                double startX;
                if (startCenter.getX() > endCenter.getX()) {
                    Rectangle mr = start;
                    start = end;
                    end = mr;
                    Point mp = startCenter;
                    startCenter = endCenter;
                    endCenter = mp;
                }
                double m = (endCenter.getY() - startCenter.getY()) / (endCenter.getX() - startCenter.getX());
                if (start.getWidth() == 0.0) {
                    startX = start.getX();
                } else {
                    double mStart = start.getHeight() / start.getWidth();
                    startX = Math.abs(m) > mStart ? startCenter.getX() + start.getHeight() / 2.0 / Math.abs(m) : start.getX() + start.getWidth();
                }
                if (end.getWidth() == 0.0) {
                    endX = end.getX();
                } else {
                    double mEnd = end.getHeight() / end.getWidth();
                    endX = Math.abs(m) > mEnd ? endCenter.getX() - end.getHeight() / 2.0 / Math.abs(m) : end.getX();
                }
                ret = ((int)startX + (int)endX) / 2;
            }
            super.setEast(ret);
            return ret;
        }
        return super.getEast();
    }

    @Override
    public void setEast(int value1) {
        super.setEast(value1);
    }

    @Override
    public int getSouth() {
        if (this.isMoveable()) {
            return super.getSouth();
        }
        if (this.containsAssociation()) {
            int ret;
            Association assoc = this.getAssociation();
            Iterator rolei = assoc.iteratorRolePresentation();
            if (!rolei.hasNext()) {
                return super.getSouth();
            }
            PresentationRole role1 = (PresentationRole)rolei.next();
            if (!rolei.hasNext()) {
                return super.getSouth();
            }
            PresentationRole role2 = (PresentationRole)rolei.next();
            Rectangle start = this.getPoint(role1);
            if (start == null) {
                return super.getSouth();
            }
            Rectangle end = this.getPoint(role2);
            if (end == null) {
                return super.getSouth();
            }
            Point startCenter = this.getCenter(start);
            Point endCenter = this.getCenter(end);
            if (startCenter.getY() == endCenter.getY()) {
                ret = (int)startCenter.getY();
            } else {
                double endY;
                double startY;
                if (startCenter.getY() > endCenter.getY()) {
                    Rectangle mr = start;
                    start = end;
                    end = mr;
                    Point mp = startCenter;
                    startCenter = endCenter;
                    endCenter = mp;
                }
                double m = (endCenter.getX() - startCenter.getX()) / (endCenter.getY() - startCenter.getY());
                if (start.getHeight() == 0.0) {
                    startY = start.getY();
                } else {
                    double mStart = start.getWidth() / start.getHeight();
                    startY = Math.abs(m) > mStart ? startCenter.getY() + start.getWidth() / 2.0 / Math.abs(m) : start.getY() + start.getHeight();
                }
                if (end.getHeight() == 0.0) {
                    endY = end.getY();
                } else {
                    double mEnd = end.getWidth() / end.getHeight();
                    endY = Math.abs(m) > mEnd ? endCenter.getY() - end.getWidth() / 2.0 / Math.abs(m) : end.getY();
                }
                ret = ((int)startY + (int)endY) / 2;
            }
            super.setSouth(ret);
            return ret;
        }
        return super.getSouth();
    }

    @Override
    public void setSouth(int value1) {
        super.setSouth(value1);
    }

    private Rectangle getPoint(PresentationRole role) {
        PresentationNode node = null;
        Iterator ep = role.iteratorEndpoint();
        if (ep.hasNext()) {
            node = (PresentationNode)ep.next();
            if (node == this && ep.hasNext()) {
                node = (PresentationNode)ep.next();
                if (role.sizeWayPoint() > 0) {
                    Iterator wpi = role.iteratorWayPoint();
                    WayPoint wp = (WayPoint)wpi.next();
                    return new Rectangle(wp.getEast(), wp.getSouth(), 0, 0);
                }
            } else if (role.sizeWayPoint() > 0) {
                Iterator wpi = role.iteratorWayPoint();
                WayPoint wp = (WayPoint)wpi.next();
                while (wpi.hasNext()) {
                    wp = (WayPoint)wpi.next();
                }
                return new Rectangle(wp.getEast(), wp.getSouth(), 0, 0);
            }
        }
        if (node != null) {
            int nodeEast = node.getEast();
            int nodeSouth = node.getSouth();
            if (node instanceof PresentationAssocClass) {
                nodeEast = (int)((PresentationAssocClass)node).getClassAngle();
                nodeSouth = (int)((PresentationAssocClass)node).getClassRadius();
            }
            return new Rectangle(nodeEast, nodeSouth, node.getWidth(), node.getHeight());
        }
        return null;
    }

    private Point getCenter(Rectangle rect) {
        return new Point((int)rect.getX() + (int)(rect.getWidth() / 2.0), (int)rect.getY() + (int)(rect.getHeight() / 2.0));
    }
}

