/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.client;

import ch.softenvironment.client.UserActionRights;
import ch.softenvironment.view.DetailView;
import ch.softenvironment.view.SearchView;
import java.awt.Frame;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ViewManager {
    private static final String ALL_CLASSES = "<ALL>";
    Map searchViews = new HashMap();
    Map detailViews = new HashMap();
    Map userActionRights = new HashMap();

    private boolean activateView(Window view) {
        if (view == null) {
            return false;
        }
        view.setVisible(true);
        if (view instanceof Frame) {
            ((Frame)view).setState(0);
        }
        view.toFront();
        return true;
    }

    public boolean activateView(Class searchView) {
        return this.activateView((Window)this.searchViews.get(searchView));
    }

    public boolean activateView(List objects) {
        if (objects.size() == 1) {
            Window view = this.getView(objects.get(0));
            if (view != null) {
                return this.activateView(view);
            }
            return false;
        }
        return false;
    }

    public void checkIn(List objects, Window view) {
        if (objects != null && view instanceof DetailView) {
            for (Object object : objects) {
                if (this.detailViews.containsKey(object)) continue;
                this.detailViews.put(object, view);
            }
        }
        if (objects == null && view instanceof SearchView) {
            this.searchViews.put(view.getClass(), view);
        }
    }

    public void checkOut(Window view) {
        if (view instanceof DetailView) {
            ArrayList keys = new ArrayList();
            for (Object key : this.detailViews.keySet()) {
                if (!this.detailViews.get(key).equals(view)) continue;
                keys.add(key);
            }
            Iterator<Object> iterator = keys.iterator();
            while (iterator.hasNext()) {
                this.detailViews.remove(iterator.next());
            }
        }
        if (view instanceof SearchView && this.searchViews.containsKey(view.getClass())) {
            this.searchViews.remove(view.getClass());
        }
    }

    public void closeAll() {
        ArrayList views = new ArrayList();
        views.addAll(this.searchViews.values());
        views.addAll(this.detailViews.values());
        this.searchViews = new HashMap();
        this.detailViews = new HashMap();
        Iterator iterator = views.iterator();
        while (iterator.hasNext()) {
            ((Window)iterator.next()).dispose();
        }
    }

    public void closeAll(List objects) {
        Iterator iterator = objects.iterator();
        while (iterator.hasNext()) {
            Window view = this.getView(iterator.next());
            if (view == null) continue;
            Window[] windows = view.getOwnedWindows();
            for (int i = 0; i < windows.length; ++i) {
                windows[i].dispose();
            }
            view.dispose();
        }
    }

    private Window getView(Object object) {
        for (Object key : this.detailViews.keySet()) {
            if (!key.equals(object)) continue;
            return (Window)this.detailViews.get(key);
        }
        return null;
    }

    public UserActionRights getRights(Class model) {
        if (this.userActionRights.containsKey(model)) {
            return (UserActionRights)this.userActionRights.get(model);
        }
        if (this.userActionRights.containsKey(ALL_CLASSES)) {
            return (UserActionRights)this.userActionRights.get(ALL_CLASSES);
        }
        return new UserActionRights(100);
    }

    public void setRights(UserActionRights rights) {
        this.userActionRights.put(ALL_CLASSES, rights);
    }

    public void setRights(UserActionRights rights, Class model) {
        this.userActionRights.put(model, rights);
    }
}

