/*
 * Decompiled with CFR 0.152.
 */
package ch.softenvironment.util;

import ch.softenvironment.util.DeveloperException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;

public class DateUtils {
    public static String calcTimeDifference(Date start, Date end) {
        if (start == null || end == null) {
            throw new DeveloperException("<start> nor <end> must be null!");
        }
        if (end.getTime() < start.getTime()) {
            throw new DeveloperException("<start> must be earlier than <end>!");
        }
        long seconds = (end.getTime() - start.getTime()) / 1000L;
        String value = "";
        long hours = seconds / 3600L;
        if (hours > 0L) {
            value = value + hours + "h";
            seconds %= 3600L;
        }
        long minutes = seconds / 60L;
        value = value + minutes + "min. ";
        return value + (seconds %= 60L) + "s";
    }

    public static Date getBeginingOfWeek() {
        GregorianCalendar now = new GregorianCalendar();
        int day = now.get(7);
        long lastMondayDiff = day - 2;
        return new Date(now.getTimeInMillis() - lastMondayDiff * 24L * 60L * 60L * 1000L);
    }

    public static Date getEndOfMonth() {
        GregorianCalendar now = new GregorianCalendar();
        GregorianCalendar firstNextMonth = new GregorianCalendar(now.get(1), now.get(2) + 1, 1);
        return new Date(firstNextMonth.getTimeInMillis() - 86400000L);
    }

    public static Date getEndOfWeek() {
        Date monday = DateUtils.getBeginingOfWeek();
        return new Date(monday.getTime() + 518400000L);
    }

    public static Date getFirstOfMonth() {
        GregorianCalendar now = new GregorianCalendar();
        return new GregorianCalendar(now.get(1), now.get(2), 1).getTime();
    }

    public static Date getEndOfYear() {
        GregorianCalendar now = new GregorianCalendar();
        return new GregorianCalendar(now.get(1), 11, 31).getTime();
    }

    public static Date getFirstOfYear() {
        GregorianCalendar now = new GregorianCalendar();
        return new GregorianCalendar(now.get(1), 0, 1).getTime();
    }

    public static Double calcHours(Date start, Date end, int precision) {
        if (start == null || end == null) {
            throw new DeveloperException("start nor end must be null!");
        }
        if (end.getTime() < start.getTime()) {
            throw new DeveloperException("start must be earlier end!");
        }
        double milliSeconds = (double)(end.getTime() - start.getTime()) / 1000.0 / 3600.0;
        double accuracy = Math.pow(10.0, precision);
        return new Double((double)Math.round(milliSeconds * accuracy) / accuracy);
    }

    public static Integer getDayInMonth(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return new Integer(cal.get(5));
    }

    public static Integer getYear(Date date) {
        if (date == null) {
            return null;
        }
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(date);
        return new Integer(cal.get(1));
    }

    public static String getSortingDateString(Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat sf = new SimpleDateFormat("yyyy-MM-dd");
        return sf.format(date);
    }

    public static boolean inRange(Date date, Date from, Date to) {
        if (date == null) {
            throw new IllegalArgumentException("date must no be null");
        }
        if (from != null && date.getTime() < from.getTime()) {
            return false;
        }
        return to == null || date.getTime() <= to.getTime();
    }
}

